/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.jsonrpc.types;

import com.google.protobuf.ByteString;
import org.apache.commons.lang3.StringUtils;
import org.tron.api.GrpcAPI;
import org.tron.core.Wallet;
import org.tron.core.exception.JsonRpcInvalidParamsException;
import org.tron.core.exception.JsonRpcInvalidRequestException;
import org.tron.core.services.jsonrpc.JsonRpcApiUtil;
import org.tron.protos.Protocol;
import org.tron.protos.contract.SmartContractOuterClass;

public class CallArguments {
    private String from = "0x0000000000000000000000000000000000000000";
    private String to;
    private String gas = "";
    private String gasPrice = "";
    private String value = "";
    private String data;
    private String nonce;

    public Protocol.Transaction.Contract.ContractType getContractType(Wallet wallet) throws JsonRpcInvalidRequestException, JsonRpcInvalidParamsException {
        Protocol.Transaction.Contract.ContractType contractType;
        if (JsonRpcApiUtil.paramStringIsNull(this.from)) {
            throw new JsonRpcInvalidRequestException("invalid json request");
        }
        if (JsonRpcApiUtil.paramStringIsNull(this.to)) {
            if (JsonRpcApiUtil.paramStringIsNull(this.data)) {
                throw new JsonRpcInvalidRequestException("invalid json request");
            }
            contractType = Protocol.Transaction.Contract.ContractType.CreateSmartContract;
        } else {
            byte[] contractAddressData = JsonRpcApiUtil.addressCompatibleToByteArray(this.to);
            GrpcAPI.BytesMessage.Builder build = GrpcAPI.BytesMessage.newBuilder();
            GrpcAPI.BytesMessage bytesMessage = build.setValue(ByteString.copyFrom((byte[])contractAddressData)).build();
            SmartContractOuterClass.SmartContract smartContract = wallet.getContract(bytesMessage);
            if (smartContract != null) {
                contractType = Protocol.Transaction.Contract.ContractType.TriggerSmartContract;
            } else if (StringUtils.isNotEmpty((CharSequence)this.value)) {
                contractType = Protocol.Transaction.Contract.ContractType.TransferContract;
            } else {
                throw new JsonRpcInvalidRequestException("invalid json request: invalid value");
            }
        }
        return contractType;
    }

    public long parseValue() throws JsonRpcInvalidParamsException {
        return JsonRpcApiUtil.parseQuantityValue(this.value);
    }

    public CallArguments() {
    }

    public CallArguments(String from, String to, String gas, String gasPrice, String value, String data, String nonce) {
        this.from = from;
        this.to = to;
        this.gas = gas;
        this.gasPrice = gasPrice;
        this.value = value;
        this.data = data;
        this.nonce = nonce;
    }

    public String toString() {
        return "CallArguments(from=" + this.getFrom() + ", to=" + this.getTo() + ", gas=" + this.getGas() + ", gasPrice=" + this.getGasPrice() + ", value=" + this.getValue() + ", data=" + this.getData() + ", nonce=" + this.getNonce() + ")";
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getGas() {
        return this.gas;
    }

    public void setGas(String gas) {
        this.gas = gas;
    }

    public String getGasPrice() {
        return this.gasPrice;
    }

    public void setGasPrice(String gasPrice) {
        this.gasPrice = gasPrice;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }
}

