/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.jsonrpc.types;

import com.google.protobuf.ByteString;
import org.apache.commons.lang3.StringUtils;
import org.tron.api.GrpcAPI;
import org.tron.core.Wallet;
import org.tron.core.exception.JsonRpcInvalidParamsException;
import org.tron.core.exception.JsonRpcInvalidRequestException;
import org.tron.core.services.jsonrpc.JsonRpcApiUtil;
import org.tron.core.services.jsonrpc.types.CallArguments;
import org.tron.protos.Protocol;
import org.tron.protos.contract.SmartContractOuterClass;

public class BuildArguments {
    private String from;
    private String to;
    private String gas = "0x0";
    private String gasPrice = "";
    private String value;
    private String data;
    private String nonce = "";
    private Long tokenId = 0L;
    private Long tokenValue = 0L;
    private String abi = "";
    private Long consumeUserResourcePercent = 0L;
    private Long originEnergyLimit = 0L;
    private String name = "";
    private Integer permissionId = 0;
    private String extraData = "";
    private boolean visible = false;

    public BuildArguments(CallArguments args) {
        this.from = args.getFrom();
        this.to = args.getTo();
        this.gas = args.getGas();
        this.gasPrice = args.getGasPrice();
        this.value = args.getValue();
        this.data = args.getData();
    }

    public Protocol.Transaction.Contract.ContractType getContractType(Wallet wallet) throws JsonRpcInvalidRequestException, JsonRpcInvalidParamsException {
        Protocol.Transaction.Contract.ContractType contractType;
        if (JsonRpcApiUtil.paramStringIsNull(this.to)) {
            if (JsonRpcApiUtil.paramStringIsNull(this.data)) {
                throw new JsonRpcInvalidRequestException("invalid json request");
            }
            contractType = Protocol.Transaction.Contract.ContractType.CreateSmartContract;
        } else {
            byte[] contractAddressData = JsonRpcApiUtil.addressCompatibleToByteArray(this.to);
            GrpcAPI.BytesMessage.Builder build = GrpcAPI.BytesMessage.newBuilder();
            GrpcAPI.BytesMessage bytesMessage = build.setValue(ByteString.copyFrom((byte[])contractAddressData)).build();
            SmartContractOuterClass.SmartContract smartContract = wallet.getContract(bytesMessage);
            if (smartContract != null) {
                contractType = Protocol.Transaction.Contract.ContractType.TriggerSmartContract;
            } else if (this.availableTransferAsset()) {
                contractType = Protocol.Transaction.Contract.ContractType.TransferAssetContract;
            } else if (StringUtils.isNotEmpty((CharSequence)this.value)) {
                contractType = Protocol.Transaction.Contract.ContractType.TransferContract;
            } else {
                throw new JsonRpcInvalidRequestException("invalid json request");
            }
        }
        return contractType;
    }

    public long parseValue() throws JsonRpcInvalidParamsException {
        return JsonRpcApiUtil.parseQuantityValue(this.value);
    }

    public long parseGas() throws JsonRpcInvalidParamsException {
        return JsonRpcApiUtil.parseQuantityValue(this.gas);
    }

    private boolean availableTransferAsset() {
        return this.tokenId > 0L && this.tokenValue > 0L && JsonRpcApiUtil.paramQuantityIsNull(this.value);
    }

    public BuildArguments() {
    }

    public BuildArguments(String from, String to, String gas, String gasPrice, String value, String data, String nonce, Long tokenId, Long tokenValue, String abi, Long consumeUserResourcePercent, Long originEnergyLimit, String name, Integer permissionId, String extraData, boolean visible) {
        this.from = from;
        this.to = to;
        this.gas = gas;
        this.gasPrice = gasPrice;
        this.value = value;
        this.data = data;
        this.nonce = nonce;
        this.tokenId = tokenId;
        this.tokenValue = tokenValue;
        this.abi = abi;
        this.consumeUserResourcePercent = consumeUserResourcePercent;
        this.originEnergyLimit = originEnergyLimit;
        this.name = name;
        this.permissionId = permissionId;
        this.extraData = extraData;
        this.visible = visible;
    }

    public String toString() {
        return "BuildArguments(from=" + this.getFrom() + ", to=" + this.getTo() + ", gas=" + this.getGas() + ", gasPrice=" + this.getGasPrice() + ", value=" + this.getValue() + ", data=" + this.getData() + ", nonce=" + this.getNonce() + ", tokenId=" + this.getTokenId() + ", tokenValue=" + this.getTokenValue() + ", abi=" + this.getAbi() + ", consumeUserResourcePercent=" + this.getConsumeUserResourcePercent() + ", originEnergyLimit=" + this.getOriginEnergyLimit() + ", name=" + this.getName() + ", permissionId=" + this.getPermissionId() + ", extraData=" + this.getExtraData() + ", visible=" + this.isVisible() + ")";
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getGas() {
        return this.gas;
    }

    public void setGas(String gas) {
        this.gas = gas;
    }

    public String getGasPrice() {
        return this.gasPrice;
    }

    public void setGasPrice(String gasPrice) {
        this.gasPrice = gasPrice;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public Long getTokenId() {
        return this.tokenId;
    }

    public void setTokenId(Long tokenId) {
        this.tokenId = tokenId;
    }

    public Long getTokenValue() {
        return this.tokenValue;
    }

    public void setTokenValue(Long tokenValue) {
        this.tokenValue = tokenValue;
    }

    public String getAbi() {
        return this.abi;
    }

    public void setAbi(String abi) {
        this.abi = abi;
    }

    public Long getConsumeUserResourcePercent() {
        return this.consumeUserResourcePercent;
    }

    public void setConsumeUserResourcePercent(Long consumeUserResourcePercent) {
        this.consumeUserResourcePercent = consumeUserResourcePercent;
    }

    public Long getOriginEnergyLimit() {
        return this.originEnergyLimit;
    }

    public void setOriginEnergyLimit(Long originEnergyLimit) {
        this.originEnergyLimit = originEnergyLimit;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getPermissionId() {
        return this.permissionId;
    }

    public void setPermissionId(Integer permissionId) {
        this.permissionId = permissionId;
    }

    public String getExtraData() {
        return this.extraData;
    }

    public void setExtraData(String extraData) {
        this.extraData = extraData;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

