/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.jsonrpc.types;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.Wallet;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.services.jsonrpc.JsonRpcApiUtil;
import org.tron.core.services.jsonrpc.types.TransactionResult;
import org.tron.protos.Protocol;

@JsonPropertyOrder(alphabetic=true)
public class BlockResult {
    private String number;
    private String hash;
    private String parentHash;
    private String nonce;
    private String sha3Uncles;
    private String logsBloom;
    private String transactionsRoot;
    private String stateRoot;
    private String receiptsRoot;
    private String miner;
    private String difficulty;
    private String totalDifficulty;
    private String extraData;
    private String size;
    private String gasLimit;
    private String gasUsed;
    private String timestamp;
    private Object[] transactions;
    private String[] uncles;
    private String baseFeePerGas = "0x0";
    private String mixHash = ByteArray.toJsonHex((byte[])new byte[32]);

    public BlockResult() {
    }

    public BlockResult(Protocol.Block block, boolean fullTx, Wallet wallet) {
        BlockCapsule blockCapsule = new BlockCapsule(block);
        this.number = ByteArray.toJsonHex((Long)blockCapsule.getNum());
        this.hash = ByteArray.toJsonHex((byte[])blockCapsule.getBlockId().getBytes());
        this.parentHash = ByteArray.toJsonHex((byte[])block.getBlockHeader().getRawData().getParentHash().toByteArray());
        this.nonce = ByteArray.toJsonHex((byte[])new byte[8]);
        this.sha3Uncles = ByteArray.toJsonHex((byte[])new byte[32]);
        this.logsBloom = ByteArray.toJsonHex((byte[])new byte[256]);
        this.transactionsRoot = ByteArray.toJsonHex((byte[])block.getBlockHeader().getRawData().getTxTrieRoot().toByteArray());
        this.stateRoot = ByteArray.toJsonHex((byte[])block.getBlockHeader().getRawData().getAccountStateRoot().toByteArray());
        this.receiptsRoot = ByteArray.toJsonHex((byte[])new byte[32]);
        this.miner = blockCapsule.getNum() == 0L ? ByteArray.toJsonHex((byte[])new byte[20]) : ByteArray.toJsonHexAddress((byte[])blockCapsule.getWitnessAddress().toByteArray());
        this.difficulty = "0x0";
        this.totalDifficulty = "0x0";
        this.extraData = "0x";
        this.size = ByteArray.toJsonHex((int)block.getSerializedSize());
        this.timestamp = ByteArray.toJsonHex((Long)(blockCapsule.getTimeStamp() / 1000L));
        long gasUsedInBlock = 0L;
        long gasLimitInBlock = 0L;
        ArrayList<Object> txes = new ArrayList<Object>();
        List transactionsList = block.getTransactionsList();
        List transactionInfoList = wallet.getTransactionInfoByBlockNum(blockCapsule.getNum()).getTransactionInfoList();
        if (fullTx) {
            long energyFee = wallet.getEnergyFee(blockCapsule.getTimeStamp());
            for (int i = 0; i < transactionsList.size(); ++i) {
                Protocol.Transaction transaction = (Protocol.Transaction)transactionsList.get(i);
                gasLimitInBlock += transaction.getRawData().getFeeLimit();
                long energyUsageTotal = JsonRpcApiUtil.getEnergyUsageTotal(transactionInfoList, i, blockCapsule.getNum());
                gasUsedInBlock += energyUsageTotal;
                txes.add(new TransactionResult(blockCapsule, i, transaction, energyUsageTotal, energyFee, wallet));
            }
        } else {
            for (int i = 0; i < transactionsList.size(); ++i) {
                gasLimitInBlock += ((Protocol.Transaction)transactionsList.get(i)).getRawData().getFeeLimit();
                gasUsedInBlock += JsonRpcApiUtil.getEnergyUsageTotal(transactionInfoList, i, blockCapsule.getNum());
                byte[] txHash = Sha256Hash.hash((boolean)CommonParameter.getInstance().isECKeyCryptoEngine(), (byte[])((Protocol.Transaction)transactionsList.get(i)).getRawData().toByteArray());
                txes.add(ByteArray.toJsonHex((byte[])txHash));
            }
        }
        this.transactions = txes.toArray();
        this.gasLimit = ByteArray.toJsonHex((Long)gasLimitInBlock);
        this.gasUsed = ByteArray.toJsonHex((Long)gasUsedInBlock);
        this.uncles = new String[0];
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getParentHash() {
        return this.parentHash;
    }

    public void setParentHash(String parentHash) {
        this.parentHash = parentHash;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getSha3Uncles() {
        return this.sha3Uncles;
    }

    public void setSha3Uncles(String sha3Uncles) {
        this.sha3Uncles = sha3Uncles;
    }

    public String getLogsBloom() {
        return this.logsBloom;
    }

    public void setLogsBloom(String logsBloom) {
        this.logsBloom = logsBloom;
    }

    public String getTransactionsRoot() {
        return this.transactionsRoot;
    }

    public void setTransactionsRoot(String transactionsRoot) {
        this.transactionsRoot = transactionsRoot;
    }

    public String getStateRoot() {
        return this.stateRoot;
    }

    public void setStateRoot(String stateRoot) {
        this.stateRoot = stateRoot;
    }

    public String getReceiptsRoot() {
        return this.receiptsRoot;
    }

    public void setReceiptsRoot(String receiptsRoot) {
        this.receiptsRoot = receiptsRoot;
    }

    public String getMiner() {
        return this.miner;
    }

    public void setMiner(String miner) {
        this.miner = miner;
    }

    public String getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(String difficulty) {
        this.difficulty = difficulty;
    }

    public String getTotalDifficulty() {
        return this.totalDifficulty;
    }

    public void setTotalDifficulty(String totalDifficulty) {
        this.totalDifficulty = totalDifficulty;
    }

    public String getExtraData() {
        return this.extraData;
    }

    public void setExtraData(String extraData) {
        this.extraData = extraData;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getGasLimit() {
        return this.gasLimit;
    }

    public void setGasLimit(String gasLimit) {
        this.gasLimit = gasLimit;
    }

    public String getGasUsed() {
        return this.gasUsed;
    }

    public void setGasUsed(String gasUsed) {
        this.gasUsed = gasUsed;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public Object[] getTransactions() {
        return this.transactions;
    }

    public void setTransactions(Object[] transactions) {
        this.transactions = transactions;
    }

    public String[] getUncles() {
        return this.uncles;
    }

    public void setUncles(String[] uncles) {
        this.uncles = uncles;
    }

    public String getBaseFeePerGas() {
        return this.baseFeePerGas;
    }

    public void setBaseFeePerGas(String baseFeePerGas) {
        this.baseFeePerGas = baseFeePerGas;
    }

    public String getMixHash() {
        return this.mixHash;
    }

    public void setMixHash(String mixHash) {
        this.mixHash = mixHash;
    }
}

