/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.jsonrpc.interceptor;

import com.fasterxml.jackson.databind.JsonNode;
import com.googlecode.jsonrpc4j.JsonRpcInterceptor;
import com.googlecode.jsonrpc4j.ProxyUtil;
import io.prometheus.client.Histogram;
import java.lang.reflect.Method;
import java.util.List;
import org.springframework.stereotype.Component;
import org.tron.common.prometheus.Metrics;

@Component
public class MetricInterceptor
implements JsonRpcInterceptor {
    private final ThreadLocal<Histogram.Timer> timer = new ThreadLocal();

    public void preHandleJson(JsonNode json) {
    }

    public void preHandle(Object target, Method method, List<JsonNode> params) {
        this.timer.set(Metrics.histogramStartTimer((String)"tron:jsonrpc_service_latency_seconds", (String[])new String[]{ProxyUtil.getMethodName((Method)method)}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postHandle(Object target, Method method, List<JsonNode> params, JsonNode result) {
        try {
            Metrics.histogramObserve((Histogram.Timer)this.timer.get());
        }
        finally {
            this.timer.remove();
        }
    }

    public void postHandleJson(JsonNode json) {
    }
}

