/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.jsonrpc.filters;

import com.google.protobuf.ByteString;
import org.apache.commons.lang3.StringUtils;
import org.tron.common.utils.ByteArray;
import org.tron.core.Wallet;
import org.tron.core.exception.JsonRpcInvalidParamsException;
import org.tron.core.services.jsonrpc.JsonRpcApiUtil;
import org.tron.core.services.jsonrpc.TronJsonRpc;
import org.tron.core.services.jsonrpc.filters.LogFilter;
import org.tron.protos.Protocol;

public class LogFilterWrapper {
    private final LogFilter logFilter;
    private final long fromBlock;
    private final long toBlock;

    public LogFilterWrapper(TronJsonRpc.FilterRequest fr, long currentMaxBlockNum, Wallet wallet) throws JsonRpcInvalidParamsException {
        long toBlockSrc;
        long fromBlockSrc;
        this.logFilter = new LogFilter(fr);
        if (fr.getBlockHash() != null) {
            String blockHash = ByteArray.fromHex((String)fr.getBlockHash());
            if (fr.getFromBlock() != null || fr.getToBlock() != null) {
                throw new JsonRpcInvalidParamsException("cannot specify both BlockHash and FromBlock/ToBlock, choose one or the other");
            }
            Protocol.Block block = null;
            if (wallet != null) {
                block = wallet.getBlockById(ByteString.copyFrom((byte[])ByteArray.fromHexString((String)blockHash)));
            }
            if (block == null) {
                throw new JsonRpcInvalidParamsException("invalid blockHash");
            }
            toBlockSrc = fromBlockSrc = block.getBlockHeader().getRawData().getNumber();
        } else if (StringUtils.isEmpty((CharSequence)fr.getFromBlock()) && StringUtils.isNotEmpty((CharSequence)fr.getToBlock())) {
            toBlockSrc = JsonRpcApiUtil.getByJsonBlockId(fr.getToBlock());
            if (toBlockSrc == -1L) {
                toBlockSrc = Long.MAX_VALUE;
            }
            fromBlockSrc = Math.min(toBlockSrc, currentMaxBlockNum);
        } else if (StringUtils.isNotEmpty((CharSequence)fr.getFromBlock()) && StringUtils.isEmpty((CharSequence)fr.getToBlock())) {
            fromBlockSrc = JsonRpcApiUtil.getByJsonBlockId(fr.getFromBlock());
            if (fromBlockSrc == -1L) {
                fromBlockSrc = currentMaxBlockNum;
            }
            toBlockSrc = Long.MAX_VALUE;
        } else if (StringUtils.isEmpty((CharSequence)fr.getFromBlock()) && StringUtils.isEmpty((CharSequence)fr.getToBlock())) {
            fromBlockSrc = currentMaxBlockNum;
            toBlockSrc = Long.MAX_VALUE;
        } else {
            fromBlockSrc = JsonRpcApiUtil.getByJsonBlockId(fr.getFromBlock());
            toBlockSrc = JsonRpcApiUtil.getByJsonBlockId(fr.getToBlock());
            if (fromBlockSrc == -1L && toBlockSrc == -1L) {
                fromBlockSrc = currentMaxBlockNum;
                toBlockSrc = Long.MAX_VALUE;
            } else if (fromBlockSrc == -1L && toBlockSrc >= 0L) {
                fromBlockSrc = currentMaxBlockNum;
            } else if (fromBlockSrc >= 0L && toBlockSrc == -1L) {
                toBlockSrc = Long.MAX_VALUE;
            }
            if (fromBlockSrc > toBlockSrc) {
                throw new JsonRpcInvalidParamsException("please verify: fromBlock <= toBlock");
            }
        }
        this.fromBlock = fromBlockSrc;
        this.toBlock = toBlockSrc;
    }

    public LogFilter getLogFilter() {
        return this.logFilter;
    }

    public long getFromBlock() {
        return this.fromBlock;
    }

    public long getToBlock() {
        return this.toBlock;
    }
}

