/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.jsonrpc;

import com.googlecode.jsonrpc4j.HttpStatusCodeProvider;
import com.googlecode.jsonrpc4j.JsonRpcInterceptor;
import com.googlecode.jsonrpc4j.JsonRpcServer;
import com.googlecode.jsonrpc4j.ProxyUtil;
import java.io.IOException;
import java.util.Collections;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.parameter.CommonParameter;
import org.tron.core.Wallet;
import org.tron.core.db.Manager;
import org.tron.core.services.NodeInfoService;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.jsonrpc.TronJsonRpc;
import org.tron.core.services.jsonrpc.TronJsonRpcImpl;

@Component
public class JsonRpcServlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    private JsonRpcServer rpcServer = null;
    @Autowired
    private NodeInfoService nodeInfoService;
    @Autowired
    private Wallet wallet;
    @Autowired
    private Manager manager;
    @Autowired
    private JsonRpcInterceptor interceptor;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        TronJsonRpcImpl jsonRpcImpl = new TronJsonRpcImpl(this.nodeInfoService, this.wallet, this.manager);
        Object compositeService = ProxyUtil.createCompositeServiceProxy((ClassLoader)cl, (Object[])new Object[]{jsonRpcImpl}, (Class[])new Class[]{TronJsonRpc.class}, (boolean)true);
        this.rpcServer = new JsonRpcServer(compositeService);
        HttpStatusCodeProvider httpStatusCodeProvider = new HttpStatusCodeProvider(){

            public int getHttpStatusCode(int resultCode) {
                return 200;
            }

            public Integer getJsonRpcCode(int httpStatusCode) {
                return null;
            }
        };
        this.rpcServer.setHttpStatusCodeProvider(httpStatusCodeProvider);
        this.rpcServer.setShouldLogInvocationErrors(false);
        if (CommonParameter.getInstance().isMetricsPrometheusEnable()) {
            this.rpcServer.setInterceptorList(Collections.singletonList(this.interceptor));
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.rpcServer.handle(req, resp);
    }
}

