/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.interfaceOnSolidity;

import com.google.protobuf.ByteString;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerInterceptor;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.tron.api.DatabaseGrpc;
import org.tron.api.GrpcAPI;
import org.tron.api.WalletSolidityGrpc;
import org.tron.common.application.Service;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.config.args.Args;
import org.tron.core.services.RpcApiService;
import org.tron.core.services.filter.LiteFnQueryGrpcInterceptor;
import org.tron.core.services.interfaceOnSolidity.WalletOnSolidity;
import org.tron.core.services.ratelimiter.RateLimiterInterceptor;
import org.tron.core.services.ratelimiter.RpcApiAccessInterceptor;
import org.tron.protos.Protocol;
import org.tron.protos.contract.AssetIssueContractOuterClass;
import org.tron.protos.contract.ShieldContract;
import org.tron.protos.contract.SmartContractOuterClass;

public class RpcApiServiceOnSolidity
implements Service {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    private int port = Args.getInstance().getRpcOnSolidityPort();
    private Server apiServer;
    @Autowired
    private WalletOnSolidity walletOnSolidity;
    @Autowired
    private RpcApiService rpcApiService;
    @Autowired
    private RateLimiterInterceptor rateLimiterInterceptor;
    @Autowired
    private LiteFnQueryGrpcInterceptor liteFnQueryGrpcInterceptor;
    @Autowired
    private RpcApiAccessInterceptor apiAccessInterceptor;

    @Override
    public void init() {
    }

    @Override
    public void init(CommonParameter args) {
    }

    @Override
    public void start() {
        try {
            NettyServerBuilder serverBuilder = (NettyServerBuilder)NettyServerBuilder.forPort((int)this.port).addService((BindableService)new DatabaseApi());
            CommonParameter parameter = Args.getInstance();
            if (parameter.getRpcThreadNum() > 0) {
                serverBuilder = (NettyServerBuilder)serverBuilder.executor((Executor)Executors.newFixedThreadPool(parameter.getRpcThreadNum()));
            }
            serverBuilder = (NettyServerBuilder)serverBuilder.addService((BindableService)new WalletSolidityApi());
            serverBuilder.maxConcurrentCallsPerConnection(parameter.getMaxConcurrentCallsPerConnection()).flowControlWindow(parameter.getFlowControlWindow()).maxConnectionIdle(parameter.getMaxConnectionIdleInMillis(), TimeUnit.MILLISECONDS).maxConnectionAge(parameter.getMaxConnectionAgeInMillis(), TimeUnit.MILLISECONDS).maxInboundMessageSize(parameter.getMaxMessageSize()).maxHeaderListSize(parameter.getMaxHeaderListSize());
            serverBuilder.intercept((ServerInterceptor)this.rateLimiterInterceptor);
            serverBuilder.intercept((ServerInterceptor)this.apiAccessInterceptor);
            serverBuilder.intercept((ServerInterceptor)this.liteFnQueryGrpcInterceptor);
            this.apiServer = serverBuilder.build();
            this.rateLimiterInterceptor.init(this.apiServer);
            this.apiServer.start();
        }
        catch (IOException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        logger.info("RpcApiServiceOnSolidity started, listening on " + this.port);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            System.err.println("*** shutting down gRPC server on solidity since JVM is shutting down");
            System.err.println("*** server on solidity shut down");
        }));
    }

    private GrpcAPI.TransactionExtention transaction2Extention(Protocol.Transaction transaction) {
        if (transaction == null) {
            return null;
        }
        GrpcAPI.TransactionExtention.Builder trxExtBuilder = GrpcAPI.TransactionExtention.newBuilder();
        GrpcAPI.Return.Builder retBuilder = GrpcAPI.Return.newBuilder();
        trxExtBuilder.setTransaction(transaction);
        trxExtBuilder.setTxid(Sha256Hash.of((boolean)CommonParameter.getInstance().isECKeyCryptoEngine(), (byte[])transaction.getRawData().toByteArray()).getByteString());
        retBuilder.setResult(true).setCode(GrpcAPI.Return.response_code.SUCCESS);
        trxExtBuilder.setResult(retBuilder);
        return trxExtBuilder.build();
    }

    private GrpcAPI.BlockExtention block2Extention(Protocol.Block block) {
        if (block == null) {
            return null;
        }
        GrpcAPI.BlockExtention.Builder builder = GrpcAPI.BlockExtention.newBuilder();
        BlockCapsule blockCapsule = new BlockCapsule(block);
        builder.setBlockHeader(block.getBlockHeader());
        builder.setBlockid(ByteString.copyFrom((byte[])blockCapsule.getBlockId().getBytes()));
        for (int i = 0; i < block.getTransactionsCount(); ++i) {
            Protocol.Transaction transaction = block.getTransactions(i);
            builder.addTransactions(this.transaction2Extention(transaction));
        }
        return builder.build();
    }

    @Override
    public void stop() {
        if (this.apiServer != null) {
            this.apiServer.shutdown();
        }
    }

    private class WalletSolidityApi
    extends WalletSolidityGrpc.WalletSolidityImplBase {
        private WalletSolidityApi() {
        }

        public void getAccount(Protocol.Account request, StreamObserver<Protocol.Account> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getAccount(request, responseObserver));
        }

        public void getAccountById(Protocol.Account request, StreamObserver<Protocol.Account> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getAccountById(request, responseObserver));
        }

        public void listWitnesses(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.WitnessList> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().listWitnesses(request, responseObserver));
        }

        public void getAssetIssueById(GrpcAPI.BytesMessage request, StreamObserver<AssetIssueContractOuterClass.AssetIssueContract> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getAssetIssueById(request, responseObserver));
        }

        public void getAssetIssueByName(GrpcAPI.BytesMessage request, StreamObserver<AssetIssueContractOuterClass.AssetIssueContract> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getAssetIssueByName(request, responseObserver));
        }

        public void getAssetIssueList(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.AssetIssueList> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getAssetIssueList(request, responseObserver));
        }

        public void getAssetIssueListByName(GrpcAPI.BytesMessage request, StreamObserver<GrpcAPI.AssetIssueList> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getAssetIssueListByName(request, responseObserver));
        }

        public void getPaginatedAssetIssueList(GrpcAPI.PaginatedMessage request, StreamObserver<GrpcAPI.AssetIssueList> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getPaginatedAssetIssueList(request, responseObserver));
        }

        public void getExchangeById(GrpcAPI.BytesMessage request, StreamObserver<Protocol.Exchange> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getExchangeById(request, responseObserver));
        }

        public void getNowBlock(GrpcAPI.EmptyMessage request, StreamObserver<Protocol.Block> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getNowBlock(request, responseObserver));
        }

        public void getNowBlock2(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.BlockExtention> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getNowBlock2(request, responseObserver));
        }

        public void getBlockByNum(GrpcAPI.NumberMessage request, StreamObserver<Protocol.Block> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getBlockByNum(request, responseObserver));
        }

        public void getBlockByNum2(GrpcAPI.NumberMessage request, StreamObserver<GrpcAPI.BlockExtention> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getBlockByNum2(request, responseObserver));
        }

        public void getDelegatedResource(GrpcAPI.DelegatedResourceMessage request, StreamObserver<GrpcAPI.DelegatedResourceList> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getDelegatedResource(request, responseObserver));
        }

        public void getDelegatedResourceV2(GrpcAPI.DelegatedResourceMessage request, StreamObserver<GrpcAPI.DelegatedResourceList> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getDelegatedResourceV2(request, responseObserver));
        }

        public void getDelegatedResourceAccountIndex(GrpcAPI.BytesMessage request, StreamObserver<Protocol.DelegatedResourceAccountIndex> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getDelegatedResourceAccountIndex(request, responseObserver));
        }

        public void getDelegatedResourceAccountIndexV2(GrpcAPI.BytesMessage request, StreamObserver<Protocol.DelegatedResourceAccountIndex> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getDelegatedResourceAccountIndexV2(request, responseObserver));
        }

        public void getCanDelegatedMaxSize(GrpcAPI.CanDelegatedMaxSizeRequestMessage request, StreamObserver<GrpcAPI.CanDelegatedMaxSizeResponseMessage> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getCanDelegatedMaxSize(request, responseObserver));
        }

        public void getAvailableUnfreezeCount(GrpcAPI.GetAvailableUnfreezeCountRequestMessage request, StreamObserver<GrpcAPI.GetAvailableUnfreezeCountResponseMessage> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getAvailableUnfreezeCount(request, responseObserver));
        }

        public void getCanWithdrawUnfreezeAmount(GrpcAPI.CanWithdrawUnfreezeAmountRequestMessage request, StreamObserver<GrpcAPI.CanWithdrawUnfreezeAmountResponseMessage> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getCanWithdrawUnfreezeAmount(request, responseObserver));
        }

        public void getTransactionCountByBlockNum(GrpcAPI.NumberMessage request, StreamObserver<GrpcAPI.NumberMessage> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getTransactionCountByBlockNum(request, responseObserver));
        }

        public void getTransactionById(GrpcAPI.BytesMessage request, StreamObserver<Protocol.Transaction> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getTransactionById(request, responseObserver));
        }

        public void getTransactionInfoById(GrpcAPI.BytesMessage request, StreamObserver<Protocol.TransactionInfo> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getTransactionInfoById(request, responseObserver));
        }

        public void listExchanges(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.ExchangeList> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().listExchanges(request, responseObserver));
        }

        public void triggerConstantContract(SmartContractOuterClass.TriggerSmartContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().triggerConstantContract(request, responseObserver));
        }

        public void estimateEnergy(SmartContractOuterClass.TriggerSmartContract request, StreamObserver<GrpcAPI.EstimateEnergyMessage> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().estimateEnergy(request, responseObserver));
        }

        public void getRewardInfo(GrpcAPI.BytesMessage request, StreamObserver<GrpcAPI.NumberMessage> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getRewardInfo(request, responseObserver));
        }

        public void getBrokerageInfo(GrpcAPI.BytesMessage request, StreamObserver<GrpcAPI.NumberMessage> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getBrokerageInfo(request, responseObserver));
        }

        public void getMerkleTreeVoucherInfo(ShieldContract.OutputPointInfo request, StreamObserver<ShieldContract.IncrementalMerkleVoucherInfo> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getMerkleTreeVoucherInfo(request, responseObserver));
        }

        public void scanNoteByIvk(GrpcAPI.IvkDecryptParameters request, StreamObserver<GrpcAPI.DecryptNotes> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().scanNoteByIvk(request, responseObserver));
        }

        public void scanAndMarkNoteByIvk(GrpcAPI.IvkDecryptAndMarkParameters request, StreamObserver<GrpcAPI.DecryptNotesMarked> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().scanAndMarkNoteByIvk(request, responseObserver));
        }

        public void scanNoteByOvk(GrpcAPI.OvkDecryptParameters request, StreamObserver<GrpcAPI.DecryptNotes> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().scanNoteByOvk(request, responseObserver));
        }

        public void isSpend(GrpcAPI.NoteParameters request, StreamObserver<GrpcAPI.SpendResult> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().isSpend(request, responseObserver));
        }

        public void getTransactionInfoByBlockNum(GrpcAPI.NumberMessage request, StreamObserver<GrpcAPI.TransactionInfoList> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getTransactionInfoByBlockNum(request, responseObserver));
        }

        public void scanShieldedTRC20NotesByIvk(GrpcAPI.IvkDecryptTRC20Parameters request, StreamObserver<GrpcAPI.DecryptNotesTRC20> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().scanShieldedTRC20NotesByIvk(request, responseObserver));
        }

        public void scanShieldedTRC20NotesByOvk(GrpcAPI.OvkDecryptTRC20Parameters request, StreamObserver<GrpcAPI.DecryptNotesTRC20> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().scanShieldedTRC20NotesByOvk(request, responseObserver));
        }

        public void isShieldedTRC20ContractNoteSpent(GrpcAPI.NfTRC20Parameters request, StreamObserver<GrpcAPI.NullifierResult> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().isShieldedTRC20ContractNoteSpent(request, responseObserver));
        }

        public void getMarketOrderByAccount(GrpcAPI.BytesMessage request, StreamObserver<Protocol.MarketOrderList> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getMarketOrderByAccount(request, responseObserver));
        }

        public void getMarketOrderById(GrpcAPI.BytesMessage request, StreamObserver<Protocol.MarketOrder> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getMarketOrderById(request, responseObserver));
        }

        public void getMarketPriceByPair(Protocol.MarketOrderPair request, StreamObserver<Protocol.MarketPriceList> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getMarketPriceByPair(request, responseObserver));
        }

        public void getMarketOrderListByPair(Protocol.MarketOrderPair request, StreamObserver<Protocol.MarketOrderList> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getMarketOrderListByPair(request, responseObserver));
        }

        public void getMarketPairList(GrpcAPI.EmptyMessage request, StreamObserver<Protocol.MarketOrderPairList> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getMarketPairList(request, responseObserver));
        }

        public void getBurnTrx(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.NumberMessage> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getBurnTrx(request, responseObserver));
        }

        public void getBlock(GrpcAPI.BlockReq request, StreamObserver<GrpcAPI.BlockExtention> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getWalletSolidityApi().getBlock(request, responseObserver));
        }
    }

    private class DatabaseApi
    extends DatabaseGrpc.DatabaseImplBase {
        private DatabaseApi() {
        }

        public void getBlockReference(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.BlockReference> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getDatabaseApi().getBlockReference(request, responseObserver));
        }

        public void getNowBlock(GrpcAPI.EmptyMessage request, StreamObserver<Protocol.Block> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getDatabaseApi().getNowBlock(request, responseObserver));
        }

        public void getBlockByNum(GrpcAPI.NumberMessage request, StreamObserver<Protocol.Block> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getDatabaseApi().getBlockByNum(request, responseObserver));
        }

        public void getDynamicProperties(GrpcAPI.EmptyMessage request, StreamObserver<Protocol.DynamicProperties> responseObserver) {
            RpcApiServiceOnSolidity.this.walletOnSolidity.futureGet(() -> RpcApiServiceOnSolidity.this.rpcApiService.getDatabaseApi().getDynamicProperties(request, responseObserver));
        }
    }
}

