/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.interfaceOnPBFT;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerInterceptor;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.tron.api.DatabaseGrpc;
import org.tron.api.GrpcAPI;
import org.tron.api.WalletSolidityGrpc;
import org.tron.common.application.Service;
import org.tron.common.parameter.CommonParameter;
import org.tron.core.config.args.Args;
import org.tron.core.services.RpcApiService;
import org.tron.core.services.filter.LiteFnQueryGrpcInterceptor;
import org.tron.core.services.interfaceOnPBFT.WalletOnPBFT;
import org.tron.core.services.ratelimiter.RateLimiterInterceptor;
import org.tron.core.services.ratelimiter.RpcApiAccessInterceptor;
import org.tron.protos.Protocol;
import org.tron.protos.contract.AssetIssueContractOuterClass;
import org.tron.protos.contract.ShieldContract;
import org.tron.protos.contract.SmartContractOuterClass;

public class RpcApiServiceOnPBFT
implements Service {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    private int port = Args.getInstance().getRpcOnPBFTPort();
    private Server apiServer;
    @Autowired
    private WalletOnPBFT walletOnPBFT;
    @Autowired
    private RpcApiService rpcApiService;
    @Autowired
    private RateLimiterInterceptor rateLimiterInterceptor;
    @Autowired
    private LiteFnQueryGrpcInterceptor liteFnQueryGrpcInterceptor;
    @Autowired
    private RpcApiAccessInterceptor apiAccessInterceptor;

    @Override
    public void init() {
    }

    @Override
    public void init(CommonParameter parameter) {
    }

    @Override
    public void start() {
        try {
            NettyServerBuilder serverBuilder = (NettyServerBuilder)NettyServerBuilder.forPort((int)this.port).addService((BindableService)new DatabaseApi());
            CommonParameter args = CommonParameter.getInstance();
            if (args.getRpcThreadNum() > 0) {
                serverBuilder = (NettyServerBuilder)serverBuilder.executor((Executor)Executors.newFixedThreadPool(args.getRpcThreadNum()));
            }
            serverBuilder = (NettyServerBuilder)serverBuilder.addService((BindableService)new WalletPBFTApi());
            serverBuilder.maxConcurrentCallsPerConnection(args.getMaxConcurrentCallsPerConnection()).flowControlWindow(args.getFlowControlWindow()).maxConnectionIdle(args.getMaxConnectionIdleInMillis(), TimeUnit.MILLISECONDS).maxConnectionAge(args.getMaxConnectionAgeInMillis(), TimeUnit.MILLISECONDS).maxInboundMessageSize(args.getMaxMessageSize()).maxHeaderListSize(args.getMaxHeaderListSize());
            serverBuilder.intercept((ServerInterceptor)this.rateLimiterInterceptor);
            serverBuilder.intercept((ServerInterceptor)this.apiAccessInterceptor);
            serverBuilder.intercept((ServerInterceptor)this.liteFnQueryGrpcInterceptor);
            this.apiServer = serverBuilder.build();
            this.rateLimiterInterceptor.init(this.apiServer);
            this.apiServer.start();
        }
        catch (IOException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        logger.info("RpcApiServiceOnPBFT started, listening on " + this.port);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            System.err.println("*** shutting down gRPC server on PBFT since JVM is shutting down");
            System.err.println("*** server on PBFT shut down");
        }));
    }

    @Override
    public void stop() {
        if (this.apiServer != null) {
            this.apiServer.shutdown();
        }
    }

    private class WalletPBFTApi
    extends WalletSolidityGrpc.WalletSolidityImplBase {
        private WalletPBFTApi() {
        }

        public void getAccount(Protocol.Account request, StreamObserver<Protocol.Account> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().getAccount(request, responseObserver));
        }

        public void getAccountById(Protocol.Account request, StreamObserver<Protocol.Account> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().getAccountById(request, responseObserver));
        }

        public void listWitnesses(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.WitnessList> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().listWitnesses(request, responseObserver));
        }

        public void getAssetIssueById(GrpcAPI.BytesMessage request, StreamObserver<AssetIssueContractOuterClass.AssetIssueContract> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().getAssetIssueById(request, responseObserver));
        }

        public void getAssetIssueByName(GrpcAPI.BytesMessage request, StreamObserver<AssetIssueContractOuterClass.AssetIssueContract> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().getAssetIssueByName(request, responseObserver));
        }

        public void getAssetIssueList(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.AssetIssueList> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().getAssetIssueList(request, responseObserver));
        }

        public void getAssetIssueListByName(GrpcAPI.BytesMessage request, StreamObserver<GrpcAPI.AssetIssueList> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().getAssetIssueListByName(request, responseObserver));
        }

        public void getPaginatedAssetIssueList(GrpcAPI.PaginatedMessage request, StreamObserver<GrpcAPI.AssetIssueList> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().getPaginatedAssetIssueList(request, responseObserver));
        }

        public void getExchangeById(GrpcAPI.BytesMessage request, StreamObserver<Protocol.Exchange> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().getExchangeById(request, responseObserver));
        }

        public void getNowBlock(GrpcAPI.EmptyMessage request, StreamObserver<Protocol.Block> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().getNowBlock(request, responseObserver));
        }

        public void getNowBlock2(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.BlockExtention> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().getNowBlock2(request, responseObserver));
        }

        public void getBlockByNum(GrpcAPI.NumberMessage request, StreamObserver<Protocol.Block> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().getBlockByNum(request, responseObserver));
        }

        public void getBlockByNum2(GrpcAPI.NumberMessage request, StreamObserver<GrpcAPI.BlockExtention> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().getBlockByNum2(request, responseObserver));
        }

        public void getDelegatedResource(GrpcAPI.DelegatedResourceMessage request, StreamObserver<GrpcAPI.DelegatedResourceList> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().getDelegatedResource(request, responseObserver));
        }

        public void getDelegatedResourceV2(GrpcAPI.DelegatedResourceMessage request, StreamObserver<GrpcAPI.DelegatedResourceList> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().getDelegatedResourceV2(request, responseObserver));
        }

        public void getDelegatedResourceAccountIndex(GrpcAPI.BytesMessage request, StreamObserver<Protocol.DelegatedResourceAccountIndex> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().getDelegatedResourceAccountIndex(request, responseObserver));
        }

        public void getDelegatedResourceAccountIndexV2(GrpcAPI.BytesMessage request, StreamObserver<Protocol.DelegatedResourceAccountIndex> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().getDelegatedResourceAccountIndexV2(request, responseObserver));
        }

        public void getCanDelegatedMaxSize(GrpcAPI.CanDelegatedMaxSizeRequestMessage request, StreamObserver<GrpcAPI.CanDelegatedMaxSizeResponseMessage> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().getCanDelegatedMaxSize(request, responseObserver));
        }

        public void getAvailableUnfreezeCount(GrpcAPI.GetAvailableUnfreezeCountRequestMessage request, StreamObserver<GrpcAPI.GetAvailableUnfreezeCountResponseMessage> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().getAvailableUnfreezeCount(request, responseObserver));
        }

        public void getCanWithdrawUnfreezeAmount(GrpcAPI.CanWithdrawUnfreezeAmountRequestMessage request, StreamObserver<GrpcAPI.CanWithdrawUnfreezeAmountResponseMessage> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().getCanWithdrawUnfreezeAmount(request, responseObserver));
        }

        public void getTransactionCountByBlockNum(GrpcAPI.NumberMessage request, StreamObserver<GrpcAPI.NumberMessage> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().getTransactionCountByBlockNum(request, responseObserver));
        }

        public void getTransactionById(GrpcAPI.BytesMessage request, StreamObserver<Protocol.Transaction> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().getTransactionById(request, responseObserver));
        }

        public void getTransactionInfoById(GrpcAPI.BytesMessage request, StreamObserver<Protocol.TransactionInfo> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().getTransactionInfoById(request, responseObserver));
        }

        public void listExchanges(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.ExchangeList> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().listExchanges(request, responseObserver));
        }

        public void triggerConstantContract(SmartContractOuterClass.TriggerSmartContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().triggerConstantContract(request, responseObserver));
        }

        public void estimateEnergy(SmartContractOuterClass.TriggerSmartContract request, StreamObserver<GrpcAPI.EstimateEnergyMessage> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().estimateEnergy(request, responseObserver));
        }

        public void getRewardInfo(GrpcAPI.BytesMessage request, StreamObserver<GrpcAPI.NumberMessage> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().getRewardInfo(request, responseObserver));
        }

        public void getBrokerageInfo(GrpcAPI.BytesMessage request, StreamObserver<GrpcAPI.NumberMessage> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().getBrokerageInfo(request, responseObserver));
        }

        public void getMerkleTreeVoucherInfo(ShieldContract.OutputPointInfo request, StreamObserver<ShieldContract.IncrementalMerkleVoucherInfo> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().getMerkleTreeVoucherInfo(request, responseObserver));
        }

        public void scanNoteByIvk(GrpcAPI.IvkDecryptParameters request, StreamObserver<GrpcAPI.DecryptNotes> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().scanNoteByIvk(request, responseObserver));
        }

        public void scanAndMarkNoteByIvk(GrpcAPI.IvkDecryptAndMarkParameters request, StreamObserver<GrpcAPI.DecryptNotesMarked> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().scanAndMarkNoteByIvk(request, responseObserver));
        }

        public void scanNoteByOvk(GrpcAPI.OvkDecryptParameters request, StreamObserver<GrpcAPI.DecryptNotes> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().scanNoteByOvk(request, responseObserver));
        }

        public void isSpend(GrpcAPI.NoteParameters request, StreamObserver<GrpcAPI.SpendResult> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().isSpend(request, responseObserver));
        }

        public void getMarketOrderByAccount(GrpcAPI.BytesMessage request, StreamObserver<Protocol.MarketOrderList> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().getMarketOrderByAccount(request, responseObserver));
        }

        public void getMarketOrderById(GrpcAPI.BytesMessage request, StreamObserver<Protocol.MarketOrder> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().getMarketOrderById(request, responseObserver));
        }

        public void getMarketPriceByPair(Protocol.MarketOrderPair request, StreamObserver<Protocol.MarketPriceList> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().getMarketPriceByPair(request, responseObserver));
        }

        public void getMarketOrderListByPair(Protocol.MarketOrderPair request, StreamObserver<Protocol.MarketOrderList> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().getMarketOrderListByPair(request, responseObserver));
        }

        public void getMarketPairList(GrpcAPI.EmptyMessage request, StreamObserver<Protocol.MarketOrderPairList> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().getMarketPairList(request, responseObserver));
        }

        public void scanShieldedTRC20NotesByIvk(GrpcAPI.IvkDecryptTRC20Parameters request, StreamObserver<GrpcAPI.DecryptNotesTRC20> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().scanShieldedTRC20NotesByIvk(request, responseObserver));
        }

        public void scanShieldedTRC20NotesByOvk(GrpcAPI.OvkDecryptTRC20Parameters request, StreamObserver<GrpcAPI.DecryptNotesTRC20> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().scanShieldedTRC20NotesByOvk(request, responseObserver));
        }

        public void isShieldedTRC20ContractNoteSpent(GrpcAPI.NfTRC20Parameters request, StreamObserver<GrpcAPI.NullifierResult> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().isShieldedTRC20ContractNoteSpent(request, responseObserver));
        }

        public void getBurnTrx(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.NumberMessage> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().getBurnTrx(request, responseObserver));
        }

        public void getBlock(GrpcAPI.BlockReq request, StreamObserver<GrpcAPI.BlockExtention> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getWalletSolidityApi().getBlock(request, responseObserver));
        }
    }

    private class DatabaseApi
    extends DatabaseGrpc.DatabaseImplBase {
        private DatabaseApi() {
        }

        public void getBlockReference(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.BlockReference> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getDatabaseApi().getBlockReference(request, responseObserver));
        }

        public void getNowBlock(GrpcAPI.EmptyMessage request, StreamObserver<Protocol.Block> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getDatabaseApi().getNowBlock(request, responseObserver));
        }

        public void getBlockByNum(GrpcAPI.NumberMessage request, StreamObserver<Protocol.Block> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getDatabaseApi().getBlockByNum(request, responseObserver));
        }

        public void getDynamicProperties(GrpcAPI.EmptyMessage request, StreamObserver<Protocol.DynamicProperties> responseObserver) {
            RpcApiServiceOnPBFT.this.walletOnPBFT.futureGet(() -> RpcApiServiceOnPBFT.this.rpcApiService.getDatabaseApi().getDynamicProperties(request, responseObserver));
        }
    }
}

