/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.google.protobuf.Message;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.common.utils.ByteArray;
import org.tron.core.Wallet;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.PostParams;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.http.ScanShieldedTRC20NotesByIvkServlet;
import org.tron.core.services.http.Util;

@Component
public class ScanShieldedTRC20NotesByOvkServlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    @Autowired
    private Wallet wallet;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            PostParams params = PostParams.getPostParams(request);
            GrpcAPI.OvkDecryptTRC20Parameters.Builder ovkDecryptTRC20Parameters = GrpcAPI.OvkDecryptTRC20Parameters.newBuilder();
            JsonFormat.merge(params.getParams(), (Message.Builder)ovkDecryptTRC20Parameters, params.isVisible());
            GrpcAPI.DecryptNotesTRC20 notes = this.wallet.scanShieldedTRC20NotesByOvk(ovkDecryptTRC20Parameters.getStartBlockIndex(), ovkDecryptTRC20Parameters.getEndBlockIndex(), ovkDecryptTRC20Parameters.getOvk().toByteArray(), ovkDecryptTRC20Parameters.getShieldedTRC20ContractAddress().toByteArray(), ovkDecryptTRC20Parameters.getEventsList());
            response.getWriter().println(ScanShieldedTRC20NotesByIvkServlet.convertOutput(notes, params.isVisible()));
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean visible = Util.getVisible(request);
            long startBlockIndex = Long.parseLong(request.getParameter("start_block_index"));
            long endBlockIndex = Long.parseLong(request.getParameter("end_block_index"));
            String ovk = request.getParameter("ovk");
            String contractAddress = request.getParameter("shielded_TRC20_contract_address");
            if (visible) {
                contractAddress = Util.getHexAddress(contractAddress);
            }
            GrpcAPI.DecryptNotesTRC20 notes = this.wallet.scanShieldedTRC20NotesByOvk(startBlockIndex, endBlockIndex, ByteArray.fromHexString((String)ovk), ByteArray.fromHexString((String)contractAddress), null);
            response.getWriter().println(ScanShieldedTRC20NotesByIvkServlet.convertOutput(notes, visible));
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }
}

