/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.Message;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.common.utils.ByteArray;
import org.tron.core.Wallet;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.PostParams;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.http.Util;

@Component
public class ScanShieldedTRC20NotesByIvkServlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    @Autowired
    private Wallet wallet;

    public static String convertOutput(GrpcAPI.DecryptNotesTRC20 notes, boolean visible) {
        String resultString = JsonFormat.printToString((Message)notes, visible);
        if (notes.getNoteTxsCount() == 0) {
            return resultString;
        }
        JSONObject jsonNotes = JSONObject.parseObject((String)resultString);
        JSONArray array = jsonNotes.getJSONArray("noteTxs");
        for (int index = 0; index < array.size(); ++index) {
            JSONObject item = array.getJSONObject(index);
            item.put("index", (Object)notes.getNoteTxs(index).getIndex());
        }
        return jsonNotes.toJSONString();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            PostParams params = PostParams.getPostParams(request);
            GrpcAPI.IvkDecryptTRC20Parameters.Builder ivkDecryptTRC20Parameters = GrpcAPI.IvkDecryptTRC20Parameters.newBuilder();
            JsonFormat.merge(params.getParams(), (Message.Builder)ivkDecryptTRC20Parameters, params.isVisible());
            GrpcAPI.DecryptNotesTRC20 notes = this.wallet.scanShieldedTRC20NotesByIvk(ivkDecryptTRC20Parameters.getStartBlockIndex(), ivkDecryptTRC20Parameters.getEndBlockIndex(), ivkDecryptTRC20Parameters.getShieldedTRC20ContractAddress().toByteArray(), ivkDecryptTRC20Parameters.getIvk().toByteArray(), ivkDecryptTRC20Parameters.getAk().toByteArray(), ivkDecryptTRC20Parameters.getNk().toByteArray(), ivkDecryptTRC20Parameters.getEventsList());
            response.getWriter().println(ScanShieldedTRC20NotesByIvkServlet.convertOutput(notes, params.isVisible()));
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean visible = Util.getVisible(request);
            long startNum = Long.parseLong(request.getParameter("start_block_index"));
            long endNum = Long.parseLong(request.getParameter("end_block_index"));
            String ivk = request.getParameter("ivk");
            String contractAddress = request.getParameter("shielded_TRC20_contract_address");
            if (visible) {
                contractAddress = Util.getHexAddress(contractAddress);
            }
            String ak = request.getParameter("ak");
            String nk = request.getParameter("nk");
            GrpcAPI.DecryptNotesTRC20 notes = this.wallet.scanShieldedTRC20NotesByIvk(startNum, endNum, ByteArray.fromHexString((String)contractAddress), ByteArray.fromHexString((String)ivk), ByteArray.fromHexString((String)ak), ByteArray.fromHexString((String)nk), null);
            response.getWriter().println(ScanShieldedTRC20NotesByIvkServlet.convertOutput(notes, visible));
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }
}

