/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.google.protobuf.Message;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.common.utils.ByteArray;
import org.tron.core.Wallet;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.PostParams;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.http.ScanNoteByIvkServlet;
import org.tron.core.services.http.Util;

@Component
public class ScanNoteByOvkServlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    @Autowired
    private Wallet wallet;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            PostParams params = PostParams.getPostParams(request);
            GrpcAPI.OvkDecryptParameters.Builder ovkDecryptParameters = GrpcAPI.OvkDecryptParameters.newBuilder();
            JsonFormat.merge(params.getParams(), (Message.Builder)ovkDecryptParameters);
            GrpcAPI.DecryptNotes notes = this.wallet.scanNoteByOvk(ovkDecryptParameters.getStartBlockIndex(), ovkDecryptParameters.getEndBlockIndex(), ovkDecryptParameters.getOvk().toByteArray());
            response.getWriter().println(ScanNoteByIvkServlet.convertOutput(notes, params.isVisible()));
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean visible = Util.getVisible(request);
            long startBlockIndex = Long.parseLong(request.getParameter("start_block_index"));
            long endBlockIndex = Long.parseLong(request.getParameter("end_block_index"));
            String ovk = request.getParameter("ovk");
            GrpcAPI.DecryptNotes notes = this.wallet.scanNoteByOvk(startBlockIndex, endBlockIndex, ByteArray.fromHexString((String)ovk));
            response.getWriter().println(ScanNoteByIvkServlet.convertOutput(notes, visible));
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }
}

