/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.Message;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.common.utils.ByteArray;
import org.tron.core.Wallet;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.http.Util;
import org.tron.core.zen.address.DiversifierT;
import org.tron.core.zen.address.IncomingViewingKey;

@Component
public class GetZenPaymentAddressServlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    @Autowired
    private Wallet wallet;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            String input = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
            Util.checkBodySize(input);
            JSONObject jsonObject = JSONObject.parseObject((String)input);
            boolean visible = Util.getVisiblePost(input);
            String ivk = jsonObject.getString("ivk");
            String d = jsonObject.getString("d");
            GrpcAPI.PaymentAddressMessage s = this.wallet.getPaymentAddress(new IncomingViewingKey(ByteArray.fromHexString((String)ivk)), new DiversifierT(ByteArray.fromHexString((String)d)));
            response.getWriter().println(JsonFormat.printToString((Message)s, visible));
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean visible = Util.getVisible(request);
            String ivk = request.getParameter("ivk");
            String d = request.getParameter("d");
            GrpcAPI.PaymentAddressMessage s = this.wallet.getPaymentAddress(new IncomingViewingKey(ByteArray.fromHexString((String)ivk)), new DiversifierT(ByteArray.fromHexString((String)d)));
            response.getWriter().println(JsonFormat.printToString((Message)s, visible));
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }
}

