/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.core.services.http.PostParams;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.http.Util;
import org.tron.core.utils.TransactionUtil;
import org.tron.protos.Protocol;

@Component
public class GetTransactionSignWeightServlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    @Autowired
    private TransactionUtil transactionUtil;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            PostParams params = PostParams.getPostParams(request);
            Protocol.Transaction transaction = Util.packTransaction(params.getParams(), params.isVisible());
            GrpcAPI.TransactionSignWeight reply = this.transactionUtil.getTransactionSignWeight(transaction);
            if (reply != null) {
                response.getWriter().println(Util.printTransactionSignWeight(reply, params.isVisible()));
            } else {
                response.getWriter().println("{}");
            }
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }
}

