/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.core.db.Manager;
import org.tron.core.services.http.PostParams;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.http.Util;

@Component
public class GetTransactionListFromPendingServlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    @Autowired
    private Manager manager;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean visible = Util.getVisible(request);
            Collection<String> result = this.manager.getTxListFromPending();
            GrpcAPI.TransactionIdList.Builder builder = GrpcAPI.TransactionIdList.newBuilder();
            builder.addAllTxId(result);
            response.getWriter().println(Util.printTransactionIdList(builder.build(), visible));
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            PostParams params = PostParams.getPostParams(request);
            Collection<String> result = this.manager.getTxListFromPending();
            GrpcAPI.TransactionIdList.Builder builder = GrpcAPI.TransactionIdList.newBuilder();
            builder.addAllTxId(result);
            response.getWriter().println(Util.printTransactionIdList(builder.build(), params.isVisible()));
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }
}

