/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.google.protobuf.Message;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.core.Wallet;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.http.Util;
import org.tron.protos.Protocol;

@Component
public class GetShieldTransactionHashServlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    @Autowired
    private Wallet wallet;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            String input = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
            Util.checkBodySize(input);
            boolean visible = Util.getVisiblePost(input);
            Protocol.Transaction transaction = Util.packTransaction(input, visible);
            GrpcAPI.BytesMessage result = this.wallet.getShieldTransactionHash(transaction);
            response.getWriter().println(JsonFormat.printToString((Message)result, visible));
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }
}

