/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.utils.ByteArray;
import org.tron.core.Wallet;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.PostParams;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.http.Util;
import org.tron.protos.Protocol;

@Component
public class GetProposalByIdServlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    @Autowired
    private Wallet wallet;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean visible = Util.getVisible(request);
            String input = request.getParameter("id");
            long id = new Long(input);
            this.fillResponse(ByteString.copyFrom((byte[])ByteArray.fromLong((long)id)), visible, response);
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            PostParams params = PostParams.getPostParams(request);
            JSONObject jsonObject = JSONObject.parseObject((String)params.getParams());
            long id = Util.getJsonLongValue(jsonObject, "id", true);
            this.fillResponse(ByteString.copyFrom((byte[])ByteArray.fromLong((long)id)), params.isVisible(), response);
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    private void fillResponse(ByteString proposalId, boolean visible, HttpServletResponse response) throws IOException {
        Protocol.Proposal reply = this.wallet.getProposalById(proposalId);
        if (reply != null) {
            response.getWriter().println(JsonFormat.printToString((Message)reply, visible));
        } else {
            response.getWriter().println("{}");
        }
    }
}

