/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.Message;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.common.utils.ByteArray;
import org.tron.core.Wallet;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.PostParams;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.http.Util;

@Component
public class GetIncomingViewingKeyServlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    @Autowired
    private Wallet wallet;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            PostParams params = PostParams.getPostParams(request);
            JSONObject jsonObject = JSONObject.parseObject((String)params.getParams());
            String ak = jsonObject.getString("ak");
            String nk = jsonObject.getString("nk");
            this.fillResponse(params.isVisible(), ak, nk, response);
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean visible = Util.getVisible(request);
            String ak = request.getParameter("ak");
            String nk = request.getParameter("nk");
            this.fillResponse(visible, ak, nk, response);
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    private void fillResponse(boolean visible, String ak, String nk, HttpServletResponse response) throws Exception {
        GrpcAPI.IncomingViewingKeyMessage ivk = this.wallet.getIncomingViewingKey(ByteArray.fromHexString((String)ak), ByteArray.fromHexString((String)nk));
        response.getWriter().println(JsonFormat.printToString((Message)ivk, visible));
    }
}

