/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.common.utils.ByteArray;
import org.tron.core.Wallet;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.PostParams;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.http.Util;
import org.tron.protos.Protocol;

@Component
public class GetDelegatedResourceAccountIndexServlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    @Autowired
    private Wallet wallet;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean visible = Util.getVisible(request);
            String address = request.getParameter("value");
            if (visible) {
                address = Util.getHexAddress(address);
            }
            this.fillResponse(ByteString.copyFrom((byte[])ByteArray.fromHexString((String)address)), visible, response);
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            PostParams params = PostParams.getPostParams(request);
            boolean visible = params.isVisible();
            String input = params.getParams();
            if (visible) {
                JSONObject jsonObject = JSONObject.parseObject((String)input);
                String value = jsonObject.getString("value");
                jsonObject.put("value", (Object)Util.getHexAddress(value));
                input = jsonObject.toJSONString();
            }
            GrpcAPI.BytesMessage.Builder build = GrpcAPI.BytesMessage.newBuilder();
            JsonFormat.merge(input, (Message.Builder)build, visible);
            this.fillResponse(build.getValue(), visible, response);
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    private void fillResponse(ByteString address, boolean visible, HttpServletResponse response) throws IOException {
        Protocol.DelegatedResourceAccountIndex reply = this.wallet.getDelegatedResourceAccountIndex(address);
        if (reply != null) {
            response.getWriter().println(JsonFormat.printToString((Message)reply, visible));
        } else {
            response.getWriter().println("{}");
        }
    }
}

