/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.Message;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.core.Wallet;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.PostParams;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.http.Util;
import org.tron.protos.contract.SmartContractOuterClass;

@Component
public class GetContractInfoServlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    @Autowired
    private Wallet wallet;
    private static final String VALUE = "value";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean visible = Util.getVisible(request);
            String input = request.getParameter(VALUE);
            if (visible) {
                input = Util.getHexAddress(input);
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(VALUE, (Object)input);
            GrpcAPI.BytesMessage.Builder build = GrpcAPI.BytesMessage.newBuilder();
            JsonFormat.merge(jsonObject.toJSONString(), (Message.Builder)build, visible);
            SmartContractOuterClass.SmartContractDataWrapper smartContract = this.wallet.getContractInfo(build.build());
            if (smartContract == null) {
                response.getWriter().println("{}");
            } else {
                JSONObject jsonSmartContract = JSONObject.parseObject((String)JsonFormat.printToString((Message)smartContract, visible));
                response.getWriter().println(jsonSmartContract.toJSONString());
            }
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            PostParams params = PostParams.getPostParams(request);
            String input = params.getParams();
            boolean visible = params.isVisible();
            if (visible) {
                JSONObject jsonObject = JSONObject.parseObject((String)input);
                String value = jsonObject.getString(VALUE);
                jsonObject.put(VALUE, (Object)Util.getHexAddress(value));
                input = jsonObject.toJSONString();
            }
            GrpcAPI.BytesMessage.Builder build = GrpcAPI.BytesMessage.newBuilder();
            JsonFormat.merge(input, (Message.Builder)build, visible);
            SmartContractOuterClass.SmartContractDataWrapper smartContract = this.wallet.getContractInfo(build.build());
            if (smartContract == null) {
                response.getWriter().println("{}");
            } else {
                JSONObject jsonSmartContract = JSONObject.parseObject((String)JsonFormat.printToString((Message)smartContract, visible));
                response.getWriter().println(jsonSmartContract.toJSONString());
            }
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }
}

