/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.common.utils.ByteArray;
import org.tron.core.Wallet;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.PostParams;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.http.Util;

@Component
public class GetAssetIssueListByNameServlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    @Autowired
    private Wallet wallet;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean visible = Util.getVisible(request);
            String value = request.getParameter("value");
            this.fillResponse(visible, value, response);
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            PostParams params = PostParams.getPostParams(request);
            JSONObject jsonObject = JSON.parseObject((String)params.getParams());
            String value = jsonObject.getString("value");
            this.fillResponse(params.isVisible(), value, response);
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    private void fillResponse(boolean visible, String value, HttpServletResponse response) throws IOException {
        GrpcAPI.AssetIssueList reply;
        if (visible) {
            value = Util.getHexString(value);
        }
        if ((reply = this.wallet.getAssetIssueListByName(ByteString.copyFrom((byte[])ByteArray.fromHexString((String)value)))) != null) {
            response.getWriter().println(JsonFormat.printToString((Message)reply, visible));
        } else {
            response.getWriter().println("{}");
        }
    }
}

