/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.Message;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.core.Wallet;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.PostParams;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.http.Util;
import org.tron.protos.contract.AssetIssueContractOuterClass;

@Component
public class GetAssetIssueByIdServlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    @Autowired
    private Wallet wallet;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean visible = Util.getVisible(request);
            String input = request.getParameter("value");
            AssetIssueContractOuterClass.AssetIssueContract reply = this.wallet.getAssetIssueById(input);
            if (reply != null) {
                response.getWriter().println(JsonFormat.printToString((Message)reply, visible));
            } else {
                response.getWriter().println("{}");
            }
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            PostParams params = PostParams.getPostParams(request);
            JSONObject jsonObject = JSONObject.parseObject((String)params.getParams());
            String id = jsonObject.getString("value");
            AssetIssueContractOuterClass.AssetIssueContract reply = this.wallet.getAssetIssueById(id);
            if (reply != null) {
                response.getWriter().println(JsonFormat.printToString((Message)reply, params.isVisible()));
            } else {
                response.getWriter().println("{}");
            }
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }
}

