/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.Message;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.core.Wallet;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.PostParams;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.http.Util;
import org.tron.protos.Protocol;

@Component
public class GetAccountByIdServlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    @Autowired
    private Wallet wallet;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean visible = Util.getVisible(request);
            String accountId = request.getParameter("account_id");
            Protocol.Account.Builder build = Protocol.Account.newBuilder();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("account_id", (Object)accountId);
            JsonFormat.merge(jsonObject.toJSONString(), (Message.Builder)build, visible);
            this.fillResponse(build.build(), visible, response);
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            PostParams params = PostParams.getPostParams(request);
            Protocol.Account.Builder build = Protocol.Account.newBuilder();
            JsonFormat.merge(params.getParams(), (Message.Builder)build, params.isVisible());
            this.fillResponse(build.build(), params.isVisible(), response);
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    private void fillResponse(Protocol.Account account, boolean visible, HttpServletResponse response) throws IOException {
        Protocol.Account reply = this.wallet.getAccountById(account);
        Util.printAccount(reply, response, visible);
    }
}

