/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.common.utils.ByteArray;
import org.tron.core.Wallet;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.http.Util;
import org.tron.protos.Protocol;
import org.tron.protos.contract.SmartContractOuterClass;

@Component
public class EstimateEnergyServlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    @Autowired
    private Wallet wallet;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        SmartContractOuterClass.TriggerSmartContract.Builder build = SmartContractOuterClass.TriggerSmartContract.newBuilder();
        GrpcAPI.TransactionExtention.Builder trxExtBuilder = GrpcAPI.TransactionExtention.newBuilder();
        GrpcAPI.EstimateEnergyMessage.Builder estimateEnergyBuilder = GrpcAPI.EstimateEnergyMessage.newBuilder();
        GrpcAPI.Return.Builder retBuilder = GrpcAPI.Return.newBuilder();
        boolean visible = false;
        try {
            boolean isFunctionSelectorSet;
            String contract = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
            Util.checkBodySize(contract);
            visible = Util.getVisiblePost(contract);
            Util.validateParameter(contract);
            JsonFormat.merge(contract, (Message.Builder)build, visible);
            JSONObject jsonObject = JSONObject.parseObject((String)contract);
            boolean bl = isFunctionSelectorSet = !StringUtil.isNullOrEmpty((String)jsonObject.getString("function_selector"));
            if (isFunctionSelectorSet) {
                String selector = jsonObject.getString("function_selector");
                String parameter = jsonObject.getString("parameter");
                String data = Util.parseMethod(selector, parameter);
                build.setData(ByteString.copyFrom((byte[])ByteArray.fromHexString((String)data)));
            }
            TransactionCapsule trxCap = this.wallet.createTransactionCapsule((Message)build.build(), Protocol.Transaction.Contract.ContractType.TriggerSmartContract);
            this.wallet.estimateEnergy(build.build(), trxCap, trxExtBuilder, retBuilder, estimateEnergyBuilder);
        }
        catch (ContractValidateException e) {
            retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.CONTRACT_VALIDATE_ERROR).setMessage(ByteString.copyFromUtf8((String)e.getMessage()));
        }
        catch (Exception e) {
            String errString = null;
            if (e.getMessage() != null) {
                errString = e.getMessage().replaceAll("[\"]", "'");
            }
            retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.OTHER_ERROR).setMessage(ByteString.copyFromUtf8((String)(e.getClass() + " : " + errString)));
        }
        estimateEnergyBuilder.setResult(retBuilder);
        response.getWriter().println(Util.printEstimateEnergyMessage(estimateEnergyBuilder.build(), visible));
    }
}

