/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Message;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.core.Wallet;
import org.tron.core.actuator.TransactionFactory;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.PostParams;
import org.tron.core.services.http.RateLimiterServlet;
import org.tron.core.services.http.Util;
import org.tron.protos.Protocol;

@Component
public class CreateCommonTransactionServlet
extends RateLimiterServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    @Autowired
    private Wallet wallet;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            PostParams params = PostParams.getPostParams(request);
            String contract = params.getParams();
            boolean visible = params.isVisible();
            Protocol.Transaction.Contract.ContractType type = Protocol.Transaction.Contract.ContractType.valueOf((String)Util.getContractType(contract));
            Message.Builder build = this.getBuilder(type);
            JsonFormat.merge(contract, build, visible);
            Protocol.Transaction tx = this.wallet.createTransactionCapsule(build.build(), type).getInstance();
            JSONObject jsonObject = JSONObject.parseObject((String)contract);
            tx = Util.setTransactionPermissionId(jsonObject, tx);
            response.getWriter().println(Util.printCreateTransaction(tx, visible));
        }
        catch (Exception e) {
            Util.processError(e, response);
        }
    }

    private Message.Builder getBuilder(Protocol.Transaction.Contract.ContractType type) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, ContractValidateException {
        Class clazz = TransactionFactory.getContract((Protocol.Transaction.Contract.ContractType)type);
        if (clazz != null) {
            Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            GeneratedMessageV3 generatedMessageV3 = (GeneratedMessageV3)constructor.newInstance(new Object[0]);
            return generatedMessageV3.toBuilder();
        }
        throw new ContractValidateException("don't have this type: " + type);
    }
}

