/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.filter;

import com.alibaba.fastjson.JSONObject;
import java.net.URI;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.tron.common.parameter.CommonParameter;
import org.tron.core.services.filter.CharResponseWrapper;

@Component
public class HttpApiAccessFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger((String)"httpApiAccessFilter");

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) {
        try {
            if (request instanceof HttpServletRequest) {
                String endpoint = ((HttpServletRequest)request).getRequestURI();
                HttpServletResponse resp = (HttpServletResponse)response;
                if (this.isDisabled(endpoint)) {
                    resp.setStatus(404);
                    resp.setContentType("application/json; charset=utf-8");
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("Error", (Object)"this API is unavailable due to config");
                    resp.getWriter().println(jsonObject.toJSONString());
                    return;
                }
                CharResponseWrapper responseWrapper = new CharResponseWrapper(resp);
                chain.doFilter(request, (ServletResponse)responseWrapper);
            } else {
                chain.doFilter(request, response);
            }
        }
        catch (Exception e) {
            logger.error("http api access filter exception: {}", (Object)e.getMessage());
        }
    }

    public void destroy() {
    }

    private boolean isDisabled(String endpoint) {
        boolean disabled = false;
        try {
            endpoint = URI.create(endpoint).normalize().toString();
            List disabledApiList = CommonParameter.getInstance().getDisabledApiList();
            if (!disabledApiList.isEmpty()) {
                disabled = disabledApiList.contains(endpoint.split("/")[2].toLowerCase());
            }
        }
        catch (Exception e) {
            logger.error("check isDisabled except, endpoint={}, error is {}", (Object)endpoint, (Object)e.getMessage());
        }
        return disabled;
    }
}

