/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services;

import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.tron.core.db.Manager;
import org.tron.core.db2.core.Chainbase;

public abstract class WalletOnCursor {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    protected Chainbase.Cursor cursor = Chainbase.Cursor.HEAD;
    @Autowired
    private Manager dbManager;

    public <T> T futureGet(TronCallable<T> callable) {
        try {
            this.dbManager.setCursor(this.cursor);
            T t = callable.call();
            return t;
        }
        finally {
            this.dbManager.resetCursor();
        }
    }

    public void futureGet(Runnable runnable) {
        try {
            this.dbManager.setCursor(this.cursor);
            runnable.run();
        }
        finally {
            this.dbManager.resetCursor();
        }
    }

    public static interface TronCallable<T>
    extends Callable<T> {
        @Override
        public T call();
    }
}

