/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolStringList;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.DatabaseGrpc;
import org.tron.api.GrpcAPI;
import org.tron.api.MonitorGrpc;
import org.tron.api.WalletExtensionGrpc;
import org.tron.api.WalletGrpc;
import org.tron.api.WalletSolidityGrpc;
import org.tron.common.application.Service;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.Sha256Hash;
import org.tron.common.utils.StringUtil;
import org.tron.core.ChainBaseManager;
import org.tron.core.Wallet;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.capsule.WitnessCapsule;
import org.tron.core.config.args.Args;
import org.tron.core.db.Manager;
import org.tron.core.exception.BadItemException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.exception.ItemNotFoundException;
import org.tron.core.exception.NonUniqueObjectException;
import org.tron.core.exception.StoreException;
import org.tron.core.exception.VMIllegalException;
import org.tron.core.exception.ZksnarkException;
import org.tron.core.metrics.MetricsApiService;
import org.tron.core.services.NodeInfoService;
import org.tron.core.services.filter.LiteFnQueryGrpcInterceptor;
import org.tron.core.services.ratelimiter.RateLimiterInterceptor;
import org.tron.core.services.ratelimiter.RpcApiAccessInterceptor;
import org.tron.core.utils.TransactionUtil;
import org.tron.core.zen.address.DiversifierT;
import org.tron.core.zen.address.IncomingViewingKey;
import org.tron.protos.Protocol;
import org.tron.protos.contract.AccountContract;
import org.tron.protos.contract.AssetIssueContractOuterClass;
import org.tron.protos.contract.BalanceContract;
import org.tron.protos.contract.ExchangeContract;
import org.tron.protos.contract.MarketContract;
import org.tron.protos.contract.ProposalContract;
import org.tron.protos.contract.ShieldContract;
import org.tron.protos.contract.SmartContractOuterClass;
import org.tron.protos.contract.StorageContract;
import org.tron.protos.contract.WitnessContract;

@Component
public class RpcApiService
implements Service {
    private static final Logger logger = LoggerFactory.getLogger((String)"API");
    public static final String CONTRACT_VALIDATE_EXCEPTION = "ContractValidateException: {}";
    private static final String EXCEPTION_CAUGHT = "exception caught";
    private static final String UNKNOWN_EXCEPTION_CAUGHT = "unknown exception caught: ";
    private static final long BLOCK_LIMIT_NUM = 100L;
    private static final long TRANSACTION_LIMIT_NUM = 1000L;
    private int port = Args.getInstance().getRpcPort();
    private Server apiServer;
    @Autowired
    private Manager dbManager;
    @Autowired
    private ChainBaseManager chainBaseManager;
    @Autowired
    private Wallet wallet;
    @Autowired
    private TransactionUtil transactionUtil;
    @Autowired
    private NodeInfoService nodeInfoService;
    @Autowired
    private RateLimiterInterceptor rateLimiterInterceptor;
    @Autowired
    private LiteFnQueryGrpcInterceptor liteFnQueryGrpcInterceptor;
    @Autowired
    private RpcApiAccessInterceptor apiAccessInterceptor;
    @Autowired
    private MetricsApiService metricsApiService;
    private DatabaseApi databaseApi = new DatabaseApi();
    private WalletApi walletApi = new WalletApi();
    private WalletSolidityApi walletSolidityApi = new WalletSolidityApi();
    private MonitorApi monitorApi = new MonitorApi();

    @Override
    public void init() {
    }

    @Override
    public void init(CommonParameter args) {
    }

    @Override
    public void start() {
        try {
            NettyServerBuilder serverBuilder = (NettyServerBuilder)NettyServerBuilder.forPort((int)this.port).addService((BindableService)this.databaseApi);
            CommonParameter parameter = Args.getInstance();
            if (parameter.getRpcThreadNum() > 0) {
                serverBuilder = (NettyServerBuilder)serverBuilder.executor((Executor)Executors.newFixedThreadPool(parameter.getRpcThreadNum()));
            }
            if (parameter.isSolidityNode()) {
                serverBuilder = (NettyServerBuilder)serverBuilder.addService((BindableService)this.walletSolidityApi);
                if (parameter.isWalletExtensionApi()) {
                    serverBuilder = (NettyServerBuilder)serverBuilder.addService((BindableService)new WalletExtensionApi());
                }
            } else {
                serverBuilder = (NettyServerBuilder)serverBuilder.addService((BindableService)this.walletApi);
            }
            if (parameter.isNodeMetricsEnable()) {
                serverBuilder = (NettyServerBuilder)serverBuilder.addService((BindableService)this.monitorApi);
            }
            serverBuilder.maxConcurrentCallsPerConnection(parameter.getMaxConcurrentCallsPerConnection()).flowControlWindow(parameter.getFlowControlWindow()).maxConnectionIdle(parameter.getMaxConnectionIdleInMillis(), TimeUnit.MILLISECONDS).maxConnectionAge(parameter.getMaxConnectionAgeInMillis(), TimeUnit.MILLISECONDS).maxInboundMessageSize(parameter.getMaxMessageSize()).maxHeaderListSize(parameter.getMaxHeaderListSize());
            serverBuilder.intercept((ServerInterceptor)this.rateLimiterInterceptor);
            serverBuilder.intercept((ServerInterceptor)this.apiAccessInterceptor);
            serverBuilder.intercept((ServerInterceptor)this.liteFnQueryGrpcInterceptor);
            this.apiServer = serverBuilder.build();
            this.rateLimiterInterceptor.init(this.apiServer);
            this.apiServer.start();
        }
        catch (IOException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        logger.info("RpcApiService has started, listening on " + this.port);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            System.err.println("*** shutting down gRPC server since JVM is shutting down");
            System.err.println("*** server is shutdown");
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callContract(SmartContractOuterClass.TriggerSmartContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver, boolean isConstant) {
        GrpcAPI.TransactionExtention.Builder trxExtBuilder = GrpcAPI.TransactionExtention.newBuilder();
        GrpcAPI.Return.Builder retBuilder = GrpcAPI.Return.newBuilder();
        try {
            TransactionCapsule trxCap = this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.TriggerSmartContract);
            Protocol.Transaction trx = isConstant ? this.wallet.triggerConstantContract(request, trxCap, trxExtBuilder, retBuilder) : this.wallet.triggerContract(request, trxCap, trxExtBuilder, retBuilder);
            trxExtBuilder.setTransaction(trx);
            trxExtBuilder.setTxid(trxCap.getTransactionId().getByteString());
            retBuilder.setResult(true).setCode(GrpcAPI.Return.response_code.SUCCESS);
            trxExtBuilder.setResult(retBuilder);
        }
        catch (ContractValidateException | VMIllegalException e) {
            retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.CONTRACT_VALIDATE_ERROR).setMessage(ByteString.copyFromUtf8((String)("Contract validate error : " + e.getMessage())));
            trxExtBuilder.setResult(retBuilder);
            logger.warn(CONTRACT_VALIDATE_EXCEPTION, (Object)e.getMessage());
        }
        catch (RuntimeException e) {
            retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.CONTRACT_EXE_ERROR).setMessage(ByteString.copyFromUtf8((String)(e.getClass() + " : " + e.getMessage())));
            trxExtBuilder.setResult(retBuilder);
            logger.warn("When run constant call in VM, have RuntimeException: " + e.getMessage());
        }
        catch (Exception e) {
            retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.OTHER_ERROR).setMessage(ByteString.copyFromUtf8((String)(e.getClass() + " : " + e.getMessage())));
            trxExtBuilder.setResult(retBuilder);
            logger.warn(UNKNOWN_EXCEPTION_CAUGHT + e.getMessage(), (Throwable)e);
        }
        finally {
            responseObserver.onNext((Object)trxExtBuilder.build());
            responseObserver.onCompleted();
        }
    }

    private TransactionCapsule createTransactionCapsule(Message message, Protocol.Transaction.Contract.ContractType contractType) throws ContractValidateException {
        return this.wallet.createTransactionCapsule(message, contractType);
    }

    private GrpcAPI.TransactionExtention transaction2Extention(Protocol.Transaction transaction) {
        if (transaction == null) {
            return null;
        }
        GrpcAPI.TransactionExtention.Builder trxExtBuilder = GrpcAPI.TransactionExtention.newBuilder();
        GrpcAPI.Return.Builder retBuilder = GrpcAPI.Return.newBuilder();
        trxExtBuilder.setTransaction(transaction);
        trxExtBuilder.setTxid(Sha256Hash.of((boolean)CommonParameter.getInstance().isECKeyCryptoEngine(), (byte[])transaction.getRawData().toByteArray()).getByteString());
        retBuilder.setResult(true).setCode(GrpcAPI.Return.response_code.SUCCESS);
        trxExtBuilder.setResult(retBuilder);
        return trxExtBuilder.build();
    }

    private GrpcAPI.BlockExtention block2Extention(Protocol.Block block) {
        if (block == null) {
            return null;
        }
        GrpcAPI.BlockExtention.Builder builder = GrpcAPI.BlockExtention.newBuilder();
        BlockCapsule blockCapsule = new BlockCapsule(block);
        builder.setBlockHeader(block.getBlockHeader());
        builder.setBlockid(ByteString.copyFrom((byte[])blockCapsule.getBlockId().getBytes()));
        for (int i = 0; i < block.getTransactionsCount(); ++i) {
            Protocol.Transaction transaction = block.getTransactions(i);
            builder.addTransactions(this.transaction2Extention(transaction));
        }
        return builder.build();
    }

    private StatusRuntimeException getRunTimeException(Exception e) {
        if (e != null) {
            return Status.INTERNAL.withDescription(e.getMessage()).asRuntimeException();
        }
        return Status.INTERNAL.withDescription("unknown").asRuntimeException();
    }

    private void checkSupportShieldedTransaction() throws ZksnarkException {
        String msg = "Not support Shielded Transaction, need to be opened by the committee";
        if (!this.dbManager.getDynamicPropertiesStore().supportShieldedTransaction()) {
            throw new ZksnarkException(msg);
        }
    }

    private void checkSupportShieldedTRC20Transaction() throws ZksnarkException {
        String msg = "Not support Shielded TRC20 Transaction, need to be opened by the committee";
        if (!this.dbManager.getDynamicPropertiesStore().supportShieldedTRC20Transaction()) {
            throw new ZksnarkException(msg);
        }
    }

    @Override
    public void stop() {
        if (this.apiServer != null) {
            this.apiServer.shutdown();
        }
    }

    public void blockUntilShutdown() {
        if (this.apiServer != null) {
            try {
                this.apiServer.awaitTermination();
            }
            catch (InterruptedException e) {
                logger.warn("{}", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    public void getRewardInfoCommon(GrpcAPI.BytesMessage request, StreamObserver<GrpcAPI.NumberMessage> responseObserver) {
        try {
            long value = this.dbManager.getMortgageService().queryReward(request.getValue().toByteArray());
            GrpcAPI.NumberMessage.Builder builder = GrpcAPI.NumberMessage.newBuilder();
            builder.setNum(value);
            responseObserver.onNext((Object)builder.build());
        }
        catch (Exception e) {
            responseObserver.onError((Throwable)e);
        }
        responseObserver.onCompleted();
    }

    public void getBurnTrxCommon(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.NumberMessage> responseObserver) {
        try {
            long value = this.dbManager.getDynamicPropertiesStore().getBurnTrxAmount();
            GrpcAPI.NumberMessage.Builder builder = GrpcAPI.NumberMessage.newBuilder();
            builder.setNum(value);
            responseObserver.onNext((Object)builder.build());
        }
        catch (Exception e) {
            responseObserver.onError((Throwable)e);
        }
        responseObserver.onCompleted();
    }

    public void getBrokerageInfoCommon(GrpcAPI.BytesMessage request, StreamObserver<GrpcAPI.NumberMessage> responseObserver) {
        try {
            long cycle = this.dbManager.getDynamicPropertiesStore().getCurrentCycleNumber();
            long value = this.dbManager.getDelegationStore().getBrokerage(cycle, request.getValue().toByteArray());
            GrpcAPI.NumberMessage.Builder builder = GrpcAPI.NumberMessage.newBuilder();
            builder.setNum(value);
            responseObserver.onNext((Object)builder.build());
        }
        catch (Exception e) {
            responseObserver.onError((Throwable)e);
        }
        responseObserver.onCompleted();
    }

    public void getTransactionCountByBlockNumCommon(GrpcAPI.NumberMessage request, StreamObserver<GrpcAPI.NumberMessage> responseObserver) {
        GrpcAPI.NumberMessage.Builder builder = GrpcAPI.NumberMessage.newBuilder();
        try {
            Protocol.Block block = this.chainBaseManager.getBlockByNum(request.getNum()).getInstance();
            builder.setNum((long)block.getTransactionsCount());
        }
        catch (StoreException e) {
            logger.error(e.getMessage());
            builder.setNum(-1L);
        }
        responseObserver.onNext((Object)builder.build());
        responseObserver.onCompleted();
    }

    public void getTransactionFromPendingCommon(GrpcAPI.BytesMessage request, StreamObserver<Protocol.Transaction> responseObserver) {
        try {
            String txId = ByteArray.toHexString((byte[])request.getValue().toByteArray());
            TransactionCapsule transactionCapsule = this.dbManager.getTxFromPending(txId);
            responseObserver.onNext((Object)(transactionCapsule == null ? null : transactionCapsule.getInstance()));
        }
        catch (Exception e) {
            responseObserver.onError((Throwable)e);
        }
        responseObserver.onCompleted();
    }

    public void getTransactionListFromPendingCommon(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.TransactionIdList> responseObserver) {
        try {
            GrpcAPI.TransactionIdList.Builder builder = GrpcAPI.TransactionIdList.newBuilder();
            builder.addAllTxId(this.dbManager.getTxListFromPending());
            responseObserver.onNext((Object)builder.build());
        }
        catch (Exception e) {
            responseObserver.onError((Throwable)e);
        }
        responseObserver.onCompleted();
    }

    public void getPendingSizeCommon(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.NumberMessage> responseObserver) {
        try {
            GrpcAPI.NumberMessage.Builder builder = GrpcAPI.NumberMessage.newBuilder();
            builder.setNum(this.dbManager.getPendingSize());
            responseObserver.onNext((Object)builder.build());
        }
        catch (Exception e) {
            responseObserver.onError((Throwable)e);
        }
        responseObserver.onCompleted();
    }

    public void getBlockCommon(GrpcAPI.BlockReq request, StreamObserver<GrpcAPI.BlockExtention> responseObserver) {
        try {
            responseObserver.onNext((Object)this.block2Extention(this.wallet.getBlock(request)));
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException) {
                responseObserver.onError((Throwable)Status.INVALID_ARGUMENT.withDescription(e.getMessage()).withCause((Throwable)e).asRuntimeException());
            }
            responseObserver.onError((Throwable)this.getRunTimeException(e));
        }
        responseObserver.onCompleted();
    }

    public DatabaseApi getDatabaseApi() {
        return this.databaseApi;
    }

    public WalletSolidityApi getWalletSolidityApi() {
        return this.walletSolidityApi;
    }

    public MonitorApi getMonitorApi() {
        return this.monitorApi;
    }

    public class MonitorApi
    extends MonitorGrpc.MonitorImplBase {
        public void getStatsInfo(GrpcAPI.EmptyMessage request, StreamObserver<Protocol.MetricsInfo> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.metricsApiService.getMetricProtoInfo());
            responseObserver.onCompleted();
        }
    }

    public class WalletApi
    extends WalletGrpc.WalletImplBase {
        private GrpcAPI.BlockListExtention blockList2Extention(GrpcAPI.BlockList blockList) {
            if (blockList == null) {
                return null;
            }
            GrpcAPI.BlockListExtention.Builder builder = GrpcAPI.BlockListExtention.newBuilder();
            for (Protocol.Block block : blockList.getBlockList()) {
                builder.addBlock(RpcApiService.this.block2Extention(block));
            }
            return builder.build();
        }

        public void getAccount(Protocol.Account req, StreamObserver<Protocol.Account> responseObserver) {
            ByteString addressBs = req.getAddress();
            if (addressBs != null) {
                Protocol.Account reply = RpcApiService.this.wallet.getAccount(req);
                responseObserver.onNext((Object)reply);
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        public void getAccountById(Protocol.Account req, StreamObserver<Protocol.Account> responseObserver) {
            ByteString accountId = req.getAccountId();
            if (accountId != null) {
                Protocol.Account reply = RpcApiService.this.wallet.getAccountById(req);
                responseObserver.onNext((Object)reply);
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        public void getAccountBalance(BalanceContract.AccountBalanceRequest request, StreamObserver<BalanceContract.AccountBalanceResponse> responseObserver) {
            try {
                BalanceContract.AccountBalanceResponse accountBalanceResponse = RpcApiService.this.wallet.getAccountBalance(request);
                responseObserver.onNext((Object)accountBalanceResponse);
                responseObserver.onCompleted();
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)e);
            }
        }

        public void getBlockBalanceTrace(BalanceContract.BlockBalanceTrace.BlockIdentifier request, StreamObserver<BalanceContract.BlockBalanceTrace> responseObserver) {
            try {
                BalanceContract.BlockBalanceTrace blockBalanceTrace = RpcApiService.this.wallet.getBlockBalance(request);
                responseObserver.onNext((Object)blockBalanceTrace);
                responseObserver.onCompleted();
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)e);
            }
        }

        public void createTransaction(BalanceContract.TransferContract request, StreamObserver<Protocol.Transaction> responseObserver) {
            try {
                responseObserver.onNext((Object)RpcApiService.this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.TransferContract).getInstance());
            }
            catch (ContractValidateException e) {
                responseObserver.onNext(null);
                logger.debug(RpcApiService.CONTRACT_VALIDATE_EXCEPTION, (Object)e.getMessage());
            }
            responseObserver.onCompleted();
        }

        public void createTransaction2(BalanceContract.TransferContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.TransferContract, responseObserver);
        }

        private void createTransactionExtention(Message request, Protocol.Transaction.Contract.ContractType contractType, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            GrpcAPI.TransactionExtention.Builder trxExtBuilder = GrpcAPI.TransactionExtention.newBuilder();
            GrpcAPI.Return.Builder retBuilder = GrpcAPI.Return.newBuilder();
            try {
                TransactionCapsule trx = RpcApiService.this.createTransactionCapsule(request, contractType);
                trxExtBuilder.setTransaction(trx.getInstance());
                trxExtBuilder.setTxid(trx.getTransactionId().getByteString());
                retBuilder.setResult(true).setCode(GrpcAPI.Return.response_code.SUCCESS);
            }
            catch (ContractValidateException e) {
                retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.CONTRACT_VALIDATE_ERROR).setMessage(ByteString.copyFromUtf8((String)("Contract validate error : " + e.getMessage())));
                logger.debug(RpcApiService.CONTRACT_VALIDATE_EXCEPTION, (Object)e.getMessage());
            }
            catch (Exception e) {
                retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.OTHER_ERROR).setMessage(ByteString.copyFromUtf8((String)(e.getClass() + " : " + e.getMessage())));
                logger.info(RpcApiService.EXCEPTION_CAUGHT + e.getMessage());
            }
            trxExtBuilder.setResult(retBuilder);
            responseObserver.onNext((Object)trxExtBuilder.build());
            responseObserver.onCompleted();
        }

        public void getTransactionSignWeight(Protocol.Transaction req, StreamObserver<GrpcAPI.TransactionSignWeight> responseObserver) {
            GrpcAPI.TransactionSignWeight tsw = RpcApiService.this.transactionUtil.getTransactionSignWeight(req);
            responseObserver.onNext((Object)tsw);
            responseObserver.onCompleted();
        }

        public void getTransactionApprovedList(Protocol.Transaction req, StreamObserver<GrpcAPI.TransactionApprovedList> responseObserver) {
            GrpcAPI.TransactionApprovedList tal = RpcApiService.this.wallet.getTransactionApprovedList(req);
            responseObserver.onNext((Object)tal);
            responseObserver.onCompleted();
        }

        public void broadcastTransaction(Protocol.Transaction req, StreamObserver<GrpcAPI.Return> responseObserver) {
            GrpcAPI.Return result = RpcApiService.this.wallet.broadcastTransaction(req);
            responseObserver.onNext((Object)result);
            responseObserver.onCompleted();
        }

        public void createAssetIssue(AssetIssueContractOuterClass.AssetIssueContract request, StreamObserver<Protocol.Transaction> responseObserver) {
            try {
                responseObserver.onNext((Object)RpcApiService.this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.AssetIssueContract).getInstance());
            }
            catch (ContractValidateException e) {
                responseObserver.onNext(null);
                logger.debug(RpcApiService.CONTRACT_VALIDATE_EXCEPTION, (Object)e.getMessage());
            }
            responseObserver.onCompleted();
        }

        public void createAssetIssue2(AssetIssueContractOuterClass.AssetIssueContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.AssetIssueContract, responseObserver);
        }

        public void unfreezeAsset(AssetIssueContractOuterClass.UnfreezeAssetContract request, StreamObserver<Protocol.Transaction> responseObserver) {
            try {
                responseObserver.onNext((Object)RpcApiService.this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.UnfreezeAssetContract).getInstance());
            }
            catch (ContractValidateException e) {
                responseObserver.onNext(null);
                logger.debug(RpcApiService.CONTRACT_VALIDATE_EXCEPTION, (Object)e.getMessage());
            }
            responseObserver.onCompleted();
        }

        public void unfreezeAsset2(AssetIssueContractOuterClass.UnfreezeAssetContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.UnfreezeAssetContract, responseObserver);
        }

        private void checkVoteWitnessAccount(WitnessContract.VoteWitnessContract req) {
            ByteString ownerAddress = req.getOwnerAddress();
            Preconditions.checkNotNull((Object)ownerAddress, (Object)"OwnerAddress is null");
            AccountCapsule account = RpcApiService.this.dbManager.getAccountStore().get(ownerAddress.toByteArray());
            Preconditions.checkNotNull((Object)account, (Object)("OwnerAddress[" + StringUtil.createReadableString((ByteString)ownerAddress) + "] not exists"));
            int votesCount = req.getVotesCount();
            Preconditions.checkArgument((votesCount <= 0 ? 1 : 0) != 0, (Object)("VotesCount[" + votesCount + "] <= 0"));
            if (RpcApiService.this.dbManager.getDynamicPropertiesStore().supportAllowNewResourceModel()) {
                Preconditions.checkArgument((account.getAllTronPower() < (long)votesCount ? 1 : 0) != 0, (Object)("tron power[" + account.getAllTronPower() + "] <  VotesCount[" + votesCount + "]"));
            } else {
                Preconditions.checkArgument((account.getTronPower() < (long)votesCount ? 1 : 0) != 0, (Object)("tron power[" + account.getTronPower() + "] <  VotesCount[" + votesCount + "]"));
            }
            req.getVotesList().forEach(vote -> {
                ByteString voteAddress = vote.getVoteAddress();
                WitnessCapsule witness = RpcApiService.this.dbManager.getWitnessStore().get(voteAddress.toByteArray());
                String readableWitnessAddress = StringUtil.createReadableString((ByteString)voteAddress);
                Preconditions.checkNotNull((Object)witness, (Object)("witness[" + readableWitnessAddress + "] not exists"));
                Preconditions.checkArgument((vote.getVoteCount() <= 0L ? 1 : 0) != 0, (Object)("VoteAddress[" + readableWitnessAddress + "], VotesCount[" + vote.getVoteCount() + "] <= 0"));
            });
        }

        public void voteWitnessAccount(WitnessContract.VoteWitnessContract request, StreamObserver<Protocol.Transaction> responseObserver) {
            try {
                responseObserver.onNext((Object)RpcApiService.this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.VoteWitnessContract).getInstance());
            }
            catch (ContractValidateException e) {
                responseObserver.onNext(null);
                logger.debug(RpcApiService.CONTRACT_VALIDATE_EXCEPTION, (Object)e.getMessage());
            }
            responseObserver.onCompleted();
        }

        public void voteWitnessAccount2(WitnessContract.VoteWitnessContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.VoteWitnessContract, responseObserver);
        }

        public void updateSetting(SmartContractOuterClass.UpdateSettingContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.UpdateSettingContract, responseObserver);
        }

        public void updateEnergyLimit(SmartContractOuterClass.UpdateEnergyLimitContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.UpdateEnergyLimitContract, responseObserver);
        }

        public void clearContractABI(SmartContractOuterClass.ClearABIContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.ClearABIContract, responseObserver);
        }

        public void createWitness(WitnessContract.WitnessCreateContract request, StreamObserver<Protocol.Transaction> responseObserver) {
            try {
                responseObserver.onNext((Object)RpcApiService.this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.WitnessCreateContract).getInstance());
            }
            catch (ContractValidateException e) {
                responseObserver.onNext(null);
                logger.debug(RpcApiService.CONTRACT_VALIDATE_EXCEPTION, (Object)e.getMessage());
            }
            responseObserver.onCompleted();
        }

        public void createWitness2(WitnessContract.WitnessCreateContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.WitnessCreateContract, responseObserver);
        }

        public void createAccount(AccountContract.AccountCreateContract request, StreamObserver<Protocol.Transaction> responseObserver) {
            try {
                responseObserver.onNext((Object)RpcApiService.this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.AccountCreateContract).getInstance());
            }
            catch (ContractValidateException e) {
                responseObserver.onNext(null);
                logger.debug(RpcApiService.CONTRACT_VALIDATE_EXCEPTION, (Object)e.getMessage());
            }
            responseObserver.onCompleted();
        }

        public void createAccount2(AccountContract.AccountCreateContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.AccountCreateContract, responseObserver);
        }

        public void updateWitness(WitnessContract.WitnessUpdateContract request, StreamObserver<Protocol.Transaction> responseObserver) {
            try {
                responseObserver.onNext((Object)RpcApiService.this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.WitnessUpdateContract).getInstance());
            }
            catch (ContractValidateException e) {
                responseObserver.onNext(null);
                logger.debug(RpcApiService.CONTRACT_VALIDATE_EXCEPTION, (Object)e.getMessage());
            }
            responseObserver.onCompleted();
        }

        public void updateWitness2(WitnessContract.WitnessUpdateContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.WitnessUpdateContract, responseObserver);
        }

        public void updateAccount(AccountContract.AccountUpdateContract request, StreamObserver<Protocol.Transaction> responseObserver) {
            try {
                responseObserver.onNext((Object)RpcApiService.this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.AccountUpdateContract).getInstance());
            }
            catch (ContractValidateException e) {
                responseObserver.onNext(null);
                logger.debug(RpcApiService.CONTRACT_VALIDATE_EXCEPTION, (Object)e.getMessage());
            }
            responseObserver.onCompleted();
        }

        public void setAccountId(AccountContract.SetAccountIdContract request, StreamObserver<Protocol.Transaction> responseObserver) {
            try {
                responseObserver.onNext((Object)RpcApiService.this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.SetAccountIdContract).getInstance());
            }
            catch (ContractValidateException e) {
                responseObserver.onNext(null);
                logger.debug(RpcApiService.CONTRACT_VALIDATE_EXCEPTION, (Object)e.getMessage());
            }
            responseObserver.onCompleted();
        }

        public void updateAccount2(AccountContract.AccountUpdateContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.AccountUpdateContract, responseObserver);
        }

        public void updateAsset(AssetIssueContractOuterClass.UpdateAssetContract request, StreamObserver<Protocol.Transaction> responseObserver) {
            try {
                responseObserver.onNext((Object)RpcApiService.this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.UpdateAssetContract).getInstance());
            }
            catch (ContractValidateException e) {
                responseObserver.onNext(null);
                logger.debug("ContractValidateException", (Object)e.getMessage());
            }
            responseObserver.onCompleted();
        }

        public void updateAsset2(AssetIssueContractOuterClass.UpdateAssetContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.UpdateAssetContract, responseObserver);
        }

        public void freezeBalance(BalanceContract.FreezeBalanceContract request, StreamObserver<Protocol.Transaction> responseObserver) {
            try {
                responseObserver.onNext((Object)RpcApiService.this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.FreezeBalanceContract).getInstance());
            }
            catch (ContractValidateException e) {
                responseObserver.onNext(null);
                logger.debug(RpcApiService.CONTRACT_VALIDATE_EXCEPTION, (Object)e.getMessage());
            }
            responseObserver.onCompleted();
        }

        public void freezeBalance2(BalanceContract.FreezeBalanceContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.FreezeBalanceContract, responseObserver);
        }

        public void freezeBalanceV2(BalanceContract.FreezeBalanceV2Contract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.FreezeBalanceV2Contract, responseObserver);
        }

        public void unfreezeBalance(BalanceContract.UnfreezeBalanceContract request, StreamObserver<Protocol.Transaction> responseObserver) {
            try {
                responseObserver.onNext((Object)RpcApiService.this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.UnfreezeBalanceContract).getInstance());
            }
            catch (ContractValidateException e) {
                responseObserver.onNext(null);
                logger.debug(RpcApiService.CONTRACT_VALIDATE_EXCEPTION, (Object)e.getMessage());
            }
            responseObserver.onCompleted();
        }

        public void unfreezeBalance2(BalanceContract.UnfreezeBalanceContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.UnfreezeBalanceContract, responseObserver);
        }

        public void unfreezeBalanceV2(BalanceContract.UnfreezeBalanceV2Contract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.UnfreezeBalanceV2Contract, responseObserver);
        }

        public void withdrawBalance(BalanceContract.WithdrawBalanceContract request, StreamObserver<Protocol.Transaction> responseObserver) {
            try {
                responseObserver.onNext((Object)RpcApiService.this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.WithdrawBalanceContract).getInstance());
            }
            catch (ContractValidateException e) {
                responseObserver.onNext(null);
                logger.debug(RpcApiService.CONTRACT_VALIDATE_EXCEPTION, (Object)e.getMessage());
            }
            responseObserver.onCompleted();
        }

        public void withdrawBalance2(BalanceContract.WithdrawBalanceContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.WithdrawBalanceContract, responseObserver);
        }

        public void withdrawExpireUnfreeze(BalanceContract.WithdrawExpireUnfreezeContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.WithdrawExpireUnfreezeContract, responseObserver);
        }

        public void delegateResource(BalanceContract.DelegateResourceContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.DelegateResourceContract, responseObserver);
        }

        public void unDelegateResource(BalanceContract.UnDelegateResourceContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.UnDelegateResourceContract, responseObserver);
        }

        public void cancelAllUnfreezeV2(BalanceContract.CancelAllUnfreezeV2Contract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.CancelAllUnfreezeV2Contract, responseObserver);
        }

        public void proposalCreate(ProposalContract.ProposalCreateContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.ProposalCreateContract, responseObserver);
        }

        public void proposalApprove(ProposalContract.ProposalApproveContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.ProposalApproveContract, responseObserver);
        }

        public void proposalDelete(ProposalContract.ProposalDeleteContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.ProposalDeleteContract, responseObserver);
        }

        public void exchangeCreate(ExchangeContract.ExchangeCreateContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.ExchangeCreateContract, responseObserver);
        }

        public void exchangeInject(ExchangeContract.ExchangeInjectContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.ExchangeInjectContract, responseObserver);
        }

        public void exchangeWithdraw(ExchangeContract.ExchangeWithdrawContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.ExchangeWithdrawContract, responseObserver);
        }

        public void exchangeTransaction(ExchangeContract.ExchangeTransactionContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.ExchangeTransactionContract, responseObserver);
        }

        public void getNowBlock(GrpcAPI.EmptyMessage request, StreamObserver<Protocol.Block> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getNowBlock());
            responseObserver.onCompleted();
        }

        public void getNowBlock2(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.BlockExtention> responseObserver) {
            Protocol.Block block = RpcApiService.this.wallet.getNowBlock();
            responseObserver.onNext((Object)RpcApiService.this.block2Extention(block));
            responseObserver.onCompleted();
        }

        public void getBlockByNum(GrpcAPI.NumberMessage request, StreamObserver<Protocol.Block> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getBlockByNum(request.getNum()));
            responseObserver.onCompleted();
        }

        public void getBlockByNum2(GrpcAPI.NumberMessage request, StreamObserver<GrpcAPI.BlockExtention> responseObserver) {
            Protocol.Block block = RpcApiService.this.wallet.getBlockByNum(request.getNum());
            responseObserver.onNext((Object)RpcApiService.this.block2Extention(block));
            responseObserver.onCompleted();
        }

        public void getTransactionCountByBlockNum(GrpcAPI.NumberMessage request, StreamObserver<GrpcAPI.NumberMessage> responseObserver) {
            RpcApiService.this.getTransactionCountByBlockNumCommon(request, responseObserver);
        }

        public void listNodes(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.NodeList> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.listNodes());
            responseObserver.onCompleted();
        }

        public void transferAsset(AssetIssueContractOuterClass.TransferAssetContract request, StreamObserver<Protocol.Transaction> responseObserver) {
            try {
                responseObserver.onNext((Object)RpcApiService.this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.TransferAssetContract).getInstance());
            }
            catch (ContractValidateException e) {
                responseObserver.onNext(null);
                logger.debug(RpcApiService.CONTRACT_VALIDATE_EXCEPTION, (Object)e.getMessage());
            }
            responseObserver.onCompleted();
        }

        public void transferAsset2(AssetIssueContractOuterClass.TransferAssetContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.TransferAssetContract, responseObserver);
        }

        public void participateAssetIssue(AssetIssueContractOuterClass.ParticipateAssetIssueContract request, StreamObserver<Protocol.Transaction> responseObserver) {
            try {
                responseObserver.onNext((Object)RpcApiService.this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.ParticipateAssetIssueContract).getInstance());
            }
            catch (ContractValidateException e) {
                responseObserver.onNext(null);
                logger.debug(RpcApiService.CONTRACT_VALIDATE_EXCEPTION, (Object)e.getMessage());
            }
            responseObserver.onCompleted();
        }

        public void participateAssetIssue2(AssetIssueContractOuterClass.ParticipateAssetIssueContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.ParticipateAssetIssueContract, responseObserver);
        }

        public void getAssetIssueByAccount(Protocol.Account request, StreamObserver<GrpcAPI.AssetIssueList> responseObserver) {
            ByteString fromBs = request.getAddress();
            if (fromBs != null) {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getAssetIssueByAccount(fromBs));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        public void getAccountNet(Protocol.Account request, StreamObserver<GrpcAPI.AccountNetMessage> responseObserver) {
            ByteString fromBs = request.getAddress();
            if (fromBs != null) {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getAccountNet(fromBs));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        public void getAccountResource(Protocol.Account request, StreamObserver<GrpcAPI.AccountResourceMessage> responseObserver) {
            ByteString fromBs = request.getAddress();
            if (fromBs != null) {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getAccountResource(fromBs));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        public void getAssetIssueByName(GrpcAPI.BytesMessage request, StreamObserver<AssetIssueContractOuterClass.AssetIssueContract> responseObserver) {
            ByteString assetName = request.getValue();
            if (assetName != null) {
                try {
                    responseObserver.onNext((Object)RpcApiService.this.wallet.getAssetIssueByName(assetName));
                }
                catch (NonUniqueObjectException e) {
                    responseObserver.onNext(null);
                    logger.debug("FullNode NonUniqueObjectException: {}", (Object)e.getMessage());
                }
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        public void getAssetIssueListByName(GrpcAPI.BytesMessage request, StreamObserver<GrpcAPI.AssetIssueList> responseObserver) {
            ByteString assetName = request.getValue();
            if (assetName != null) {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getAssetIssueListByName(assetName));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        public void getAssetIssueById(GrpcAPI.BytesMessage request, StreamObserver<AssetIssueContractOuterClass.AssetIssueContract> responseObserver) {
            ByteString assetId = request.getValue();
            if (assetId != null) {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getAssetIssueById(assetId.toStringUtf8()));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        public void getBlockById(GrpcAPI.BytesMessage request, StreamObserver<Protocol.Block> responseObserver) {
            ByteString blockId = request.getValue();
            if (Objects.nonNull(blockId)) {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getBlockById(blockId));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        public void getProposalById(GrpcAPI.BytesMessage request, StreamObserver<Protocol.Proposal> responseObserver) {
            ByteString proposalId = request.getValue();
            if (Objects.nonNull(proposalId)) {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getProposalById(proposalId));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        public void getExchangeById(GrpcAPI.BytesMessage request, StreamObserver<Protocol.Exchange> responseObserver) {
            ByteString exchangeId = request.getValue();
            if (Objects.nonNull(exchangeId)) {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getExchangeById(exchangeId));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        public void getBlockByLimitNext(GrpcAPI.BlockLimit request, StreamObserver<GrpcAPI.BlockList> responseObserver) {
            long startNum = request.getStartNum();
            long endNum = request.getEndNum();
            if (endNum > 0L && endNum > startNum && endNum - startNum <= 100L) {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getBlocksByLimitNext(startNum, endNum - startNum));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        public void getBlockByLimitNext2(GrpcAPI.BlockLimit request, StreamObserver<GrpcAPI.BlockListExtention> responseObserver) {
            long startNum = request.getStartNum();
            long endNum = request.getEndNum();
            if (endNum > 0L && endNum > startNum && endNum - startNum <= 100L) {
                responseObserver.onNext((Object)this.blockList2Extention(RpcApiService.this.wallet.getBlocksByLimitNext(startNum, endNum - startNum)));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        public void getBlockByLatestNum(GrpcAPI.NumberMessage request, StreamObserver<GrpcAPI.BlockList> responseObserver) {
            long getNum = request.getNum();
            if (getNum > 0L && getNum < 100L) {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getBlockByLatestNum(getNum));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        public void getBlockByLatestNum2(GrpcAPI.NumberMessage request, StreamObserver<GrpcAPI.BlockListExtention> responseObserver) {
            long getNum = request.getNum();
            if (getNum > 0L && getNum < 100L) {
                responseObserver.onNext((Object)this.blockList2Extention(RpcApiService.this.wallet.getBlockByLatestNum(getNum)));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        public void getTransactionById(GrpcAPI.BytesMessage request, StreamObserver<Protocol.Transaction> responseObserver) {
            ByteString transactionId = request.getValue();
            if (Objects.nonNull(transactionId)) {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getTransactionById(transactionId));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        public void deployContract(SmartContractOuterClass.CreateSmartContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.CreateSmartContract, responseObserver);
        }

        public void totalTransaction(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.NumberMessage> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.totalTransaction());
            responseObserver.onCompleted();
        }

        public void getNextMaintenanceTime(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.NumberMessage> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getNextMaintenanceTime());
            responseObserver.onCompleted();
        }

        public void getAssetIssueList(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.AssetIssueList> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getAssetIssueList());
            responseObserver.onCompleted();
        }

        public void triggerContract(SmartContractOuterClass.TriggerSmartContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.callContract(request, responseObserver, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void estimateEnergy(SmartContractOuterClass.TriggerSmartContract request, StreamObserver<GrpcAPI.EstimateEnergyMessage> responseObserver) {
            GrpcAPI.TransactionExtention.Builder trxExtBuilder = GrpcAPI.TransactionExtention.newBuilder();
            GrpcAPI.Return.Builder retBuilder = GrpcAPI.Return.newBuilder();
            GrpcAPI.EstimateEnergyMessage.Builder estimateBuilder = GrpcAPI.EstimateEnergyMessage.newBuilder();
            try {
                TransactionCapsule trxCap = RpcApiService.this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.TriggerSmartContract);
                RpcApiService.this.wallet.estimateEnergy(request, trxCap, trxExtBuilder, retBuilder, estimateBuilder);
            }
            catch (ContractValidateException | VMIllegalException e) {
                retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.CONTRACT_VALIDATE_ERROR).setMessage(ByteString.copyFromUtf8((String)("Contract validate error : " + e.getMessage())));
                logger.warn(RpcApiService.CONTRACT_VALIDATE_EXCEPTION, (Object)e.getMessage());
            }
            catch (RuntimeException e) {
                retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.CONTRACT_EXE_ERROR).setMessage(ByteString.copyFromUtf8((String)(e.getClass() + " : " + e.getMessage())));
                logger.warn("When run estimate energy in VM, have Runtime Exception: " + e.getMessage());
            }
            catch (Exception e) {
                retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.OTHER_ERROR).setMessage(ByteString.copyFromUtf8((String)(e.getClass() + " : " + e.getMessage())));
                logger.warn(RpcApiService.UNKNOWN_EXCEPTION_CAUGHT + e.getMessage(), (Throwable)e);
            }
            finally {
                estimateBuilder.setResult(retBuilder);
                responseObserver.onNext((Object)estimateBuilder.build());
                responseObserver.onCompleted();
            }
        }

        public void triggerConstantContract(SmartContractOuterClass.TriggerSmartContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.callContract(request, responseObserver, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void callContract(SmartContractOuterClass.TriggerSmartContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver, boolean isConstant) {
            GrpcAPI.TransactionExtention.Builder trxExtBuilder = GrpcAPI.TransactionExtention.newBuilder();
            GrpcAPI.Return.Builder retBuilder = GrpcAPI.Return.newBuilder();
            try {
                TransactionCapsule trxCap = RpcApiService.this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.TriggerSmartContract);
                Protocol.Transaction trx = isConstant ? RpcApiService.this.wallet.triggerConstantContract(request, trxCap, trxExtBuilder, retBuilder) : RpcApiService.this.wallet.triggerContract(request, trxCap, trxExtBuilder, retBuilder);
                trxExtBuilder.setTransaction(trx);
                trxExtBuilder.setTxid(trxCap.getTransactionId().getByteString());
                retBuilder.setResult(true).setCode(GrpcAPI.Return.response_code.SUCCESS);
                trxExtBuilder.setResult(retBuilder);
            }
            catch (ContractValidateException | VMIllegalException e) {
                retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.CONTRACT_VALIDATE_ERROR).setMessage(ByteString.copyFromUtf8((String)("Contract validate error : " + e.getMessage())));
                trxExtBuilder.setResult(retBuilder);
                logger.warn(RpcApiService.CONTRACT_VALIDATE_EXCEPTION, (Object)e.getMessage());
            }
            catch (RuntimeException e) {
                retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.CONTRACT_EXE_ERROR).setMessage(ByteString.copyFromUtf8((String)(e.getClass() + " : " + e.getMessage())));
                trxExtBuilder.setResult(retBuilder);
                logger.warn("When run constant call in VM, have Runtime Exception: " + e.getMessage());
            }
            catch (Exception e) {
                retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.OTHER_ERROR).setMessage(ByteString.copyFromUtf8((String)(e.getClass() + " : " + e.getMessage())));
                trxExtBuilder.setResult(retBuilder);
                logger.warn(RpcApiService.UNKNOWN_EXCEPTION_CAUGHT + e.getMessage(), (Throwable)e);
            }
            finally {
                responseObserver.onNext((Object)trxExtBuilder.build());
                responseObserver.onCompleted();
            }
        }

        public void getPaginatedAssetIssueList(GrpcAPI.PaginatedMessage request, StreamObserver<GrpcAPI.AssetIssueList> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getAssetIssueList(request.getOffset(), request.getLimit()));
            responseObserver.onCompleted();
        }

        public void getContract(GrpcAPI.BytesMessage request, StreamObserver<SmartContractOuterClass.SmartContract> responseObserver) {
            SmartContractOuterClass.SmartContract contract = RpcApiService.this.wallet.getContract(request);
            responseObserver.onNext((Object)contract);
            responseObserver.onCompleted();
        }

        public void getContractInfo(GrpcAPI.BytesMessage request, StreamObserver<SmartContractOuterClass.SmartContractDataWrapper> responseObserver) {
            SmartContractOuterClass.SmartContractDataWrapper contract = RpcApiService.this.wallet.getContractInfo(request);
            responseObserver.onNext((Object)contract);
            responseObserver.onCompleted();
        }

        public void listWitnesses(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.WitnessList> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getWitnessList());
            responseObserver.onCompleted();
        }

        public void listProposals(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.ProposalList> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getProposalList());
            responseObserver.onCompleted();
        }

        public void getDelegatedResource(GrpcAPI.DelegatedResourceMessage request, StreamObserver<GrpcAPI.DelegatedResourceList> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getDelegatedResource(request.getFromAddress(), request.getToAddress()));
            responseObserver.onCompleted();
        }

        public void getDelegatedResourceV2(GrpcAPI.DelegatedResourceMessage request, StreamObserver<GrpcAPI.DelegatedResourceList> responseObserver) {
            try {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getDelegatedResourceV2(request.getFromAddress(), request.getToAddress()));
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
            }
            responseObserver.onCompleted();
        }

        public void getDelegatedResourceAccountIndex(GrpcAPI.BytesMessage request, StreamObserver<Protocol.DelegatedResourceAccountIndex> responseObserver) {
            try {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getDelegatedResourceAccountIndex(request.getValue()));
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
            }
            responseObserver.onCompleted();
        }

        public void getDelegatedResourceAccountIndexV2(GrpcAPI.BytesMessage request, StreamObserver<Protocol.DelegatedResourceAccountIndex> responseObserver) {
            try {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getDelegatedResourceAccountIndexV2(request.getValue()));
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
            }
            responseObserver.onCompleted();
        }

        public void getCanDelegatedMaxSize(GrpcAPI.CanDelegatedMaxSizeRequestMessage request, StreamObserver<GrpcAPI.CanDelegatedMaxSizeResponseMessage> responseObserver) {
            try {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getCanDelegatedMaxSize(request.getOwnerAddress(), request.getType()));
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
            }
            responseObserver.onCompleted();
        }

        public void getAvailableUnfreezeCount(GrpcAPI.GetAvailableUnfreezeCountRequestMessage request, StreamObserver<GrpcAPI.GetAvailableUnfreezeCountResponseMessage> responseObserver) {
            try {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getAvailableUnfreezeCount(request.getOwnerAddress()));
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
            }
            responseObserver.onCompleted();
        }

        public void getCanWithdrawUnfreezeAmount(GrpcAPI.CanWithdrawUnfreezeAmountRequestMessage request, StreamObserver<GrpcAPI.CanWithdrawUnfreezeAmountResponseMessage> responseObserver) {
            try {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getCanWithdrawUnfreezeAmount(request.getOwnerAddress(), request.getTimestamp()));
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
            }
            responseObserver.onCompleted();
        }

        public void getPaginatedProposalList(GrpcAPI.PaginatedMessage request, StreamObserver<GrpcAPI.ProposalList> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getPaginatedProposalList(request.getOffset(), request.getLimit()));
            responseObserver.onCompleted();
        }

        public void getPaginatedExchangeList(GrpcAPI.PaginatedMessage request, StreamObserver<GrpcAPI.ExchangeList> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getPaginatedExchangeList(request.getOffset(), request.getLimit()));
            responseObserver.onCompleted();
        }

        public void listExchanges(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.ExchangeList> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getExchangeList());
            responseObserver.onCompleted();
        }

        public void getChainParameters(GrpcAPI.EmptyMessage request, StreamObserver<Protocol.ChainParameters> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getChainParameters());
            responseObserver.onCompleted();
        }

        public void getTransactionInfoById(GrpcAPI.BytesMessage request, StreamObserver<Protocol.TransactionInfo> responseObserver) {
            ByteString id = request.getValue();
            if (null != id) {
                Protocol.TransactionInfo reply = RpcApiService.this.wallet.getTransactionInfoById(id);
                responseObserver.onNext((Object)reply);
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        public void getNodeInfo(GrpcAPI.EmptyMessage request, StreamObserver<Protocol.NodeInfo> responseObserver) {
            try {
                responseObserver.onNext((Object)RpcApiService.this.nodeInfoService.getNodeInfo().transferToProtoEntity());
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
            }
            responseObserver.onCompleted();
        }

        public void accountPermissionUpdate(AccountContract.AccountPermissionUpdateContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.AccountPermissionUpdateContract, responseObserver);
        }

        public void getMerkleTreeVoucherInfo(ShieldContract.OutputPointInfo request, StreamObserver<ShieldContract.IncrementalMerkleVoucherInfo> responseObserver) {
            try {
                RpcApiService.this.checkSupportShieldedTransaction();
                ShieldContract.IncrementalMerkleVoucherInfo witnessInfo = RpcApiService.this.wallet.getMerkleTreeVoucherInfo(request);
                responseObserver.onNext((Object)witnessInfo);
            }
            catch (Exception ex) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(ex));
                return;
            }
            responseObserver.onCompleted();
        }

        public void createShieldedTransaction(GrpcAPI.PrivateParameters request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            GrpcAPI.TransactionExtention.Builder trxExtBuilder = GrpcAPI.TransactionExtention.newBuilder();
            GrpcAPI.Return.Builder retBuilder = GrpcAPI.Return.newBuilder();
            try {
                RpcApiService.this.checkSupportShieldedTransaction();
                TransactionCapsule trx = RpcApiService.this.wallet.createShieldedTransaction(request);
                trxExtBuilder.setTransaction(trx.getInstance());
                trxExtBuilder.setTxid(trx.getTransactionId().getByteString());
                retBuilder.setResult(true).setCode(GrpcAPI.Return.response_code.SUCCESS);
            }
            catch (ContractValidateException | ZksnarkException e) {
                retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.CONTRACT_VALIDATE_ERROR).setMessage(ByteString.copyFromUtf8((String)("Contract validate error : " + e.getMessage())));
                logger.debug(RpcApiService.CONTRACT_VALIDATE_EXCEPTION, (Object)e.getMessage());
            }
            catch (Exception e) {
                retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.OTHER_ERROR).setMessage(ByteString.copyFromUtf8((String)(e.getClass() + " : " + e.getMessage())));
                logger.info("createShieldedTransaction exception caught: " + e.getMessage());
            }
            trxExtBuilder.setResult(retBuilder);
            responseObserver.onNext((Object)trxExtBuilder.build());
            responseObserver.onCompleted();
        }

        public void createShieldedTransactionWithoutSpendAuthSig(GrpcAPI.PrivateParametersWithoutAsk request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            GrpcAPI.TransactionExtention.Builder trxExtBuilder = GrpcAPI.TransactionExtention.newBuilder();
            GrpcAPI.Return.Builder retBuilder = GrpcAPI.Return.newBuilder();
            try {
                RpcApiService.this.checkSupportShieldedTransaction();
                TransactionCapsule trx = RpcApiService.this.wallet.createShieldedTransactionWithoutSpendAuthSig(request);
                trxExtBuilder.setTransaction(trx.getInstance());
                trxExtBuilder.setTxid(trx.getTransactionId().getByteString());
                retBuilder.setResult(true).setCode(GrpcAPI.Return.response_code.SUCCESS);
            }
            catch (ContractValidateException | ZksnarkException e) {
                retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.CONTRACT_VALIDATE_ERROR).setMessage(ByteString.copyFromUtf8((String)("Contract validate error : " + e.getMessage())));
                logger.debug(RpcApiService.CONTRACT_VALIDATE_EXCEPTION, (Object)e.getMessage());
            }
            catch (Exception e) {
                retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.OTHER_ERROR).setMessage(ByteString.copyFromUtf8((String)(e.getClass() + " : " + e.getMessage())));
                logger.info("createShieldedTransactionWithoutSpendAuthSig exception caught: " + e.getMessage());
            }
            trxExtBuilder.setResult(retBuilder);
            responseObserver.onNext((Object)trxExtBuilder.build());
            responseObserver.onCompleted();
        }

        public void getNewShieldedAddress(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.ShieldedAddressInfo> responseObserver) {
            try {
                RpcApiService.this.checkSupportShieldedTRC20Transaction();
                responseObserver.onNext((Object)RpcApiService.this.wallet.getNewShieldedAddress());
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
                return;
            }
            responseObserver.onCompleted();
        }

        public void getSpendingKey(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.BytesMessage> responseObserver) {
            try {
                RpcApiService.this.checkSupportShieldedTRC20Transaction();
                responseObserver.onNext((Object)RpcApiService.this.wallet.getSpendingKey());
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
                return;
            }
            responseObserver.onCompleted();
        }

        public void getRcm(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.BytesMessage> responseObserver) {
            try {
                RpcApiService.this.checkSupportShieldedTRC20Transaction();
                responseObserver.onNext((Object)RpcApiService.this.wallet.getRcm());
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
                return;
            }
            responseObserver.onCompleted();
        }

        public void getExpandedSpendingKey(GrpcAPI.BytesMessage request, StreamObserver<GrpcAPI.ExpandedSpendingKeyMessage> responseObserver) {
            ByteString spendingKey = request.getValue();
            try {
                RpcApiService.this.checkSupportShieldedTRC20Transaction();
                GrpcAPI.ExpandedSpendingKeyMessage response = RpcApiService.this.wallet.getExpandedSpendingKey(spendingKey);
                responseObserver.onNext((Object)response);
            }
            catch (BadItemException | ZksnarkException e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException((Exception)e));
                return;
            }
            responseObserver.onCompleted();
        }

        public void getAkFromAsk(GrpcAPI.BytesMessage request, StreamObserver<GrpcAPI.BytesMessage> responseObserver) {
            ByteString ak = request.getValue();
            try {
                RpcApiService.this.checkSupportShieldedTRC20Transaction();
                responseObserver.onNext((Object)RpcApiService.this.wallet.getAkFromAsk(ak));
            }
            catch (BadItemException | ZksnarkException e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException((Exception)e));
                return;
            }
            responseObserver.onCompleted();
        }

        public void getNkFromNsk(GrpcAPI.BytesMessage request, StreamObserver<GrpcAPI.BytesMessage> responseObserver) {
            ByteString nk = request.getValue();
            try {
                RpcApiService.this.checkSupportShieldedTRC20Transaction();
                responseObserver.onNext((Object)RpcApiService.this.wallet.getNkFromNsk(nk));
            }
            catch (BadItemException | ZksnarkException e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException((Exception)e));
                return;
            }
            responseObserver.onCompleted();
        }

        public void getIncomingViewingKey(GrpcAPI.ViewingKeyMessage request, StreamObserver<GrpcAPI.IncomingViewingKeyMessage> responseObserver) {
            ByteString ak = request.getAk();
            ByteString nk = request.getNk();
            try {
                RpcApiService.this.checkSupportShieldedTRC20Transaction();
                responseObserver.onNext((Object)RpcApiService.this.wallet.getIncomingViewingKey(ak.toByteArray(), nk.toByteArray()));
            }
            catch (ZksnarkException e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException((Exception)((Object)e)));
                return;
            }
            responseObserver.onCompleted();
        }

        public void getDiversifier(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.DiversifierMessage> responseObserver) {
            try {
                RpcApiService.this.checkSupportShieldedTRC20Transaction();
                GrpcAPI.DiversifierMessage d = RpcApiService.this.wallet.getDiversifier();
                responseObserver.onNext((Object)d);
            }
            catch (ZksnarkException e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException((Exception)((Object)e)));
                return;
            }
            responseObserver.onCompleted();
        }

        public void getZenPaymentAddress(GrpcAPI.IncomingViewingKeyDiversifierMessage request, StreamObserver<GrpcAPI.PaymentAddressMessage> responseObserver) {
            GrpcAPI.IncomingViewingKeyMessage ivk = request.getIvk();
            GrpcAPI.DiversifierMessage d = request.getD();
            try {
                RpcApiService.this.checkSupportShieldedTRC20Transaction();
                GrpcAPI.PaymentAddressMessage saplingPaymentAddressMessage = RpcApiService.this.wallet.getPaymentAddress(new IncomingViewingKey(ivk.getIvk().toByteArray()), new DiversifierT(d.getD().toByteArray()));
                responseObserver.onNext((Object)saplingPaymentAddressMessage);
            }
            catch (BadItemException | ZksnarkException e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException((Exception)e));
                return;
            }
            responseObserver.onCompleted();
        }

        public void scanNoteByIvk(GrpcAPI.IvkDecryptParameters request, StreamObserver<GrpcAPI.DecryptNotes> responseObserver) {
            long startNum = request.getStartBlockIndex();
            long endNum = request.getEndBlockIndex();
            try {
                RpcApiService.this.checkSupportShieldedTransaction();
                GrpcAPI.DecryptNotes decryptNotes = RpcApiService.this.wallet.scanNoteByIvk(startNum, endNum, request.getIvk().toByteArray());
                responseObserver.onNext((Object)decryptNotes);
            }
            catch (BadItemException | ZksnarkException e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException((Exception)e));
                return;
            }
            responseObserver.onCompleted();
        }

        public void scanAndMarkNoteByIvk(GrpcAPI.IvkDecryptAndMarkParameters request, StreamObserver<GrpcAPI.DecryptNotesMarked> responseObserver) {
            long startNum = request.getStartBlockIndex();
            long endNum = request.getEndBlockIndex();
            try {
                RpcApiService.this.checkSupportShieldedTransaction();
                GrpcAPI.DecryptNotesMarked decryptNotes = RpcApiService.this.wallet.scanAndMarkNoteByIvk(startNum, endNum, request.getIvk().toByteArray(), request.getAk().toByteArray(), request.getNk().toByteArray());
                responseObserver.onNext((Object)decryptNotes);
            }
            catch (InvalidProtocolBufferException | BadItemException | ItemNotFoundException | ZksnarkException e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException((Exception)e));
                return;
            }
            responseObserver.onCompleted();
        }

        public void scanNoteByOvk(GrpcAPI.OvkDecryptParameters request, StreamObserver<GrpcAPI.DecryptNotes> responseObserver) {
            long startNum = request.getStartBlockIndex();
            long endNum = request.getEndBlockIndex();
            try {
                RpcApiService.this.checkSupportShieldedTransaction();
                GrpcAPI.DecryptNotes decryptNotes = RpcApiService.this.wallet.scanNoteByOvk(startNum, endNum, request.getOvk().toByteArray());
                responseObserver.onNext((Object)decryptNotes);
            }
            catch (BadItemException | ZksnarkException e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException((Exception)e));
                return;
            }
            responseObserver.onCompleted();
        }

        public void isSpend(GrpcAPI.NoteParameters request, StreamObserver<GrpcAPI.SpendResult> responseObserver) {
            try {
                RpcApiService.this.checkSupportShieldedTransaction();
                responseObserver.onNext((Object)RpcApiService.this.wallet.isSpend(request));
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
                return;
            }
            responseObserver.onCompleted();
        }

        public void createShieldNullifier(GrpcAPI.NfParameters request, StreamObserver<GrpcAPI.BytesMessage> responseObserver) {
            try {
                RpcApiService.this.checkSupportShieldedTransaction();
                GrpcAPI.BytesMessage nf = RpcApiService.this.wallet.createShieldNullifier(request);
                responseObserver.onNext((Object)nf);
            }
            catch (ZksnarkException e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException((Exception)((Object)e)));
                return;
            }
            responseObserver.onCompleted();
        }

        public void createSpendAuthSig(GrpcAPI.SpendAuthSigParameters request, StreamObserver<GrpcAPI.BytesMessage> responseObserver) {
            try {
                RpcApiService.this.checkSupportShieldedTRC20Transaction();
                GrpcAPI.BytesMessage spendAuthSig = RpcApiService.this.wallet.createSpendAuthSig(request);
                responseObserver.onNext((Object)spendAuthSig);
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
                return;
            }
            responseObserver.onCompleted();
        }

        public void getShieldTransactionHash(Protocol.Transaction request, StreamObserver<GrpcAPI.BytesMessage> responseObserver) {
            try {
                RpcApiService.this.checkSupportShieldedTransaction();
                GrpcAPI.BytesMessage transactionHash = RpcApiService.this.wallet.getShieldTransactionHash(request);
                responseObserver.onNext((Object)transactionHash);
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
                return;
            }
            responseObserver.onCompleted();
        }

        public void createShieldedContractParameters(GrpcAPI.PrivateShieldedTRC20Parameters request, StreamObserver<GrpcAPI.ShieldedTRC20Parameters> responseObserver) {
            try {
                RpcApiService.this.checkSupportShieldedTRC20Transaction();
                GrpcAPI.ShieldedTRC20Parameters shieldedTRC20Parameters = RpcApiService.this.wallet.createShieldedContractParameters(request);
                responseObserver.onNext((Object)shieldedTRC20Parameters);
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
                logger.info("createShieldedContractParameters exception caught: " + e.getMessage());
                return;
            }
            responseObserver.onCompleted();
        }

        public void createShieldedContractParametersWithoutAsk(GrpcAPI.PrivateShieldedTRC20ParametersWithoutAsk request, StreamObserver<GrpcAPI.ShieldedTRC20Parameters> responseObserver) {
            try {
                RpcApiService.this.checkSupportShieldedTRC20Transaction();
                GrpcAPI.ShieldedTRC20Parameters shieldedTRC20Parameters = RpcApiService.this.wallet.createShieldedContractParametersWithoutAsk(request);
                responseObserver.onNext((Object)shieldedTRC20Parameters);
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
                logger.info("createShieldedContractParametersWithoutAsk exception caught: " + e.getMessage());
                return;
            }
            responseObserver.onCompleted();
        }

        public void scanShieldedTRC20NotesByIvk(GrpcAPI.IvkDecryptTRC20Parameters request, StreamObserver<GrpcAPI.DecryptNotesTRC20> responseObserver) {
            long startNum = request.getStartBlockIndex();
            long endNum = request.getEndBlockIndex();
            try {
                RpcApiService.this.checkSupportShieldedTRC20Transaction();
                GrpcAPI.DecryptNotesTRC20 decryptNotes = RpcApiService.this.wallet.scanShieldedTRC20NotesByIvk(startNum, endNum, request.getShieldedTRC20ContractAddress().toByteArray(), request.getIvk().toByteArray(), request.getAk().toByteArray(), request.getNk().toByteArray(), request.getEventsList());
                responseObserver.onNext((Object)decryptNotes);
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
                logger.info("scanShieldedTRC20NotesByIvk exception caught: " + e.getMessage());
                return;
            }
            responseObserver.onCompleted();
        }

        public void scanShieldedTRC20NotesByOvk(GrpcAPI.OvkDecryptTRC20Parameters request, StreamObserver<GrpcAPI.DecryptNotesTRC20> responseObserver) {
            long startNum = request.getStartBlockIndex();
            long endNum = request.getEndBlockIndex();
            try {
                RpcApiService.this.checkSupportShieldedTRC20Transaction();
                GrpcAPI.DecryptNotesTRC20 decryptNotes = RpcApiService.this.wallet.scanShieldedTRC20NotesByOvk(startNum, endNum, request.getOvk().toByteArray(), request.getShieldedTRC20ContractAddress().toByteArray(), request.getEventsList());
                responseObserver.onNext((Object)decryptNotes);
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
                logger.info("scanShieldedTRC20NotesByOvk exception caught: " + e.getMessage());
                return;
            }
            responseObserver.onCompleted();
        }

        public void isShieldedTRC20ContractNoteSpent(GrpcAPI.NfTRC20Parameters request, StreamObserver<GrpcAPI.NullifierResult> responseObserver) {
            try {
                RpcApiService.this.checkSupportShieldedTRC20Transaction();
                GrpcAPI.NullifierResult nf = RpcApiService.this.wallet.isShieldedTRC20ContractNoteSpent(request);
                responseObserver.onNext((Object)nf);
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
                return;
            }
            responseObserver.onCompleted();
        }

        public void getTriggerInputForShieldedTRC20Contract(GrpcAPI.ShieldedTRC20TriggerContractParameters request, StreamObserver<GrpcAPI.BytesMessage> responseObserver) {
            try {
                RpcApiService.this.checkSupportShieldedTRC20Transaction();
                responseObserver.onNext((Object)RpcApiService.this.wallet.getTriggerInputForShieldedTRC20Contract(request));
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)e);
                return;
            }
            responseObserver.onCompleted();
        }

        public void getRewardInfo(GrpcAPI.BytesMessage request, StreamObserver<GrpcAPI.NumberMessage> responseObserver) {
            RpcApiService.this.getRewardInfoCommon(request, responseObserver);
        }

        public void getBrokerageInfo(GrpcAPI.BytesMessage request, StreamObserver<GrpcAPI.NumberMessage> responseObserver) {
            RpcApiService.this.getBrokerageInfoCommon(request, responseObserver);
        }

        public void getBurnTrx(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.NumberMessage> responseObserver) {
            RpcApiService.this.getBurnTrxCommon(request, responseObserver);
        }

        public void updateBrokerage(StorageContract.UpdateBrokerageContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.UpdateBrokerageContract, responseObserver);
        }

        public void createCommonTransaction(Protocol.Transaction request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            Protocol.Transaction.Contract contract = request.getRawData().getContract(0);
            this.createTransactionExtention((Message)contract.getParameter(), contract.getType(), responseObserver);
        }

        public void getTransactionInfoByBlockNum(GrpcAPI.NumberMessage request, StreamObserver<GrpcAPI.TransactionInfoList> responseObserver) {
            try {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getTransactionInfoByBlockNum(request.getNum()));
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
            }
            responseObserver.onCompleted();
        }

        public void marketSellAsset(MarketContract.MarketSellAssetContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.MarketSellAssetContract, responseObserver);
        }

        public void marketCancelOrder(MarketContract.MarketCancelOrderContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            this.createTransactionExtention((Message)request, Protocol.Transaction.Contract.ContractType.MarketCancelOrderContract, responseObserver);
        }

        public void getMarketOrderByAccount(GrpcAPI.BytesMessage request, StreamObserver<Protocol.MarketOrderList> responseObserver) {
            try {
                ByteString address = request.getValue();
                Protocol.MarketOrderList marketOrderList = RpcApiService.this.wallet.getMarketOrderByAccount(address);
                responseObserver.onNext((Object)marketOrderList);
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
            }
            responseObserver.onCompleted();
        }

        public void getMarketOrderById(GrpcAPI.BytesMessage request, StreamObserver<Protocol.MarketOrder> responseObserver) {
            try {
                ByteString address = request.getValue();
                Protocol.MarketOrder marketOrder = RpcApiService.this.wallet.getMarketOrderById(address);
                responseObserver.onNext((Object)marketOrder);
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
            }
            responseObserver.onCompleted();
        }

        public void getMarketPriceByPair(Protocol.MarketOrderPair request, StreamObserver<Protocol.MarketPriceList> responseObserver) {
            try {
                Protocol.MarketPriceList marketPriceList = RpcApiService.this.wallet.getMarketPriceByPair(request.getSellTokenId().toByteArray(), request.getBuyTokenId().toByteArray());
                responseObserver.onNext((Object)marketPriceList);
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
            }
            responseObserver.onCompleted();
        }

        public void getMarketOrderListByPair(Protocol.MarketOrderPair request, StreamObserver<Protocol.MarketOrderList> responseObserver) {
            try {
                Protocol.MarketOrderList orderPairList = RpcApiService.this.wallet.getMarketOrderListByPair(request.getSellTokenId().toByteArray(), request.getBuyTokenId().toByteArray());
                responseObserver.onNext((Object)orderPairList);
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
            }
            responseObserver.onCompleted();
        }

        public void getMarketPairList(GrpcAPI.EmptyMessage request, StreamObserver<Protocol.MarketOrderPairList> responseObserver) {
            try {
                Protocol.MarketOrderPairList pairList = RpcApiService.this.wallet.getMarketPairList();
                responseObserver.onNext((Object)pairList);
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
            }
            responseObserver.onCompleted();
        }

        public void getTransactionFromPending(GrpcAPI.BytesMessage request, StreamObserver<Protocol.Transaction> responseObserver) {
            RpcApiService.this.getTransactionFromPendingCommon(request, responseObserver);
        }

        public void getTransactionListFromPending(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.TransactionIdList> responseObserver) {
            RpcApiService.this.getTransactionListFromPendingCommon(request, responseObserver);
        }

        public void getPendingSize(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.NumberMessage> responseObserver) {
            RpcApiService.this.getPendingSizeCommon(request, responseObserver);
        }

        public void getBlock(GrpcAPI.BlockReq request, StreamObserver<GrpcAPI.BlockExtention> responseObserver) {
            RpcApiService.this.getBlockCommon(request, responseObserver);
        }
    }

    public class WalletExtensionApi
    extends WalletExtensionGrpc.WalletExtensionImplBase {
        private GrpcAPI.TransactionListExtention transactionList2Extention(GrpcAPI.TransactionList transactionList) {
            if (transactionList == null) {
                return null;
            }
            GrpcAPI.TransactionListExtention.Builder builder = GrpcAPI.TransactionListExtention.newBuilder();
            for (Protocol.Transaction transaction : transactionList.getTransactionList()) {
                builder.addTransaction(RpcApiService.this.transaction2Extention(transaction));
            }
            return builder.build();
        }
    }

    public class WalletSolidityApi
    extends WalletSolidityGrpc.WalletSolidityImplBase {
        public void getAccount(Protocol.Account request, StreamObserver<Protocol.Account> responseObserver) {
            ByteString addressBs = request.getAddress();
            if (addressBs != null) {
                Protocol.Account reply = RpcApiService.this.wallet.getAccount(request);
                responseObserver.onNext((Object)reply);
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        public void getAccountById(Protocol.Account request, StreamObserver<Protocol.Account> responseObserver) {
            ByteString id = request.getAccountId();
            if (id != null) {
                Protocol.Account reply = RpcApiService.this.wallet.getAccountById(request);
                responseObserver.onNext((Object)reply);
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        public void listWitnesses(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.WitnessList> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getWitnessList());
            responseObserver.onCompleted();
        }

        public void getAssetIssueList(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.AssetIssueList> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getAssetIssueList());
            responseObserver.onCompleted();
        }

        public void getPaginatedAssetIssueList(GrpcAPI.PaginatedMessage request, StreamObserver<GrpcAPI.AssetIssueList> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getAssetIssueList(request.getOffset(), request.getLimit()));
            responseObserver.onCompleted();
        }

        public void getAssetIssueByName(GrpcAPI.BytesMessage request, StreamObserver<AssetIssueContractOuterClass.AssetIssueContract> responseObserver) {
            ByteString assetName = request.getValue();
            if (assetName != null) {
                try {
                    responseObserver.onNext((Object)RpcApiService.this.wallet.getAssetIssueByName(assetName));
                }
                catch (NonUniqueObjectException e) {
                    responseObserver.onNext(null);
                    logger.error("Solidity NonUniqueObjectException: {}", (Object)e.getMessage());
                }
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        public void getAssetIssueListByName(GrpcAPI.BytesMessage request, StreamObserver<GrpcAPI.AssetIssueList> responseObserver) {
            ByteString assetName = request.getValue();
            if (assetName != null) {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getAssetIssueListByName(assetName));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        public void getAssetIssueById(GrpcAPI.BytesMessage request, StreamObserver<AssetIssueContractOuterClass.AssetIssueContract> responseObserver) {
            ByteString assetId = request.getValue();
            if (assetId != null) {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getAssetIssueById(assetId.toStringUtf8()));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        public void getNowBlock(GrpcAPI.EmptyMessage request, StreamObserver<Protocol.Block> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getNowBlock());
            responseObserver.onCompleted();
        }

        public void getNowBlock2(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.BlockExtention> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.block2Extention(RpcApiService.this.wallet.getNowBlock()));
            responseObserver.onCompleted();
        }

        public void getBlockByNum(GrpcAPI.NumberMessage request, StreamObserver<Protocol.Block> responseObserver) {
            long num = request.getNum();
            if (num >= 0L) {
                Protocol.Block reply = RpcApiService.this.wallet.getBlockByNum(num);
                responseObserver.onNext((Object)reply);
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        public void getBlockByNum2(GrpcAPI.NumberMessage request, StreamObserver<GrpcAPI.BlockExtention> responseObserver) {
            long num = request.getNum();
            if (num >= 0L) {
                Protocol.Block reply = RpcApiService.this.wallet.getBlockByNum(num);
                responseObserver.onNext((Object)RpcApiService.this.block2Extention(reply));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        public void getDelegatedResource(GrpcAPI.DelegatedResourceMessage request, StreamObserver<GrpcAPI.DelegatedResourceList> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getDelegatedResource(request.getFromAddress(), request.getToAddress()));
            responseObserver.onCompleted();
        }

        public void getDelegatedResourceV2(GrpcAPI.DelegatedResourceMessage request, StreamObserver<GrpcAPI.DelegatedResourceList> responseObserver) {
            try {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getDelegatedResourceV2(request.getFromAddress(), request.getToAddress()));
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
            }
            responseObserver.onCompleted();
        }

        public void getDelegatedResourceAccountIndex(GrpcAPI.BytesMessage request, StreamObserver<Protocol.DelegatedResourceAccountIndex> responseObserver) {
            try {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getDelegatedResourceAccountIndex(request.getValue()));
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
            }
            responseObserver.onCompleted();
        }

        public void getDelegatedResourceAccountIndexV2(GrpcAPI.BytesMessage request, StreamObserver<Protocol.DelegatedResourceAccountIndex> responseObserver) {
            try {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getDelegatedResourceAccountIndexV2(request.getValue()));
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
            }
            responseObserver.onCompleted();
        }

        public void getCanDelegatedMaxSize(GrpcAPI.CanDelegatedMaxSizeRequestMessage request, StreamObserver<GrpcAPI.CanDelegatedMaxSizeResponseMessage> responseObserver) {
            try {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getCanDelegatedMaxSize(request.getOwnerAddress(), request.getType()));
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
            }
            responseObserver.onCompleted();
        }

        public void getAvailableUnfreezeCount(GrpcAPI.GetAvailableUnfreezeCountRequestMessage request, StreamObserver<GrpcAPI.GetAvailableUnfreezeCountResponseMessage> responseObserver) {
            try {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getAvailableUnfreezeCount(request.getOwnerAddress()));
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
            }
            responseObserver.onCompleted();
        }

        public void getCanWithdrawUnfreezeAmount(GrpcAPI.CanWithdrawUnfreezeAmountRequestMessage request, StreamObserver<GrpcAPI.CanWithdrawUnfreezeAmountResponseMessage> responseObserver) {
            try {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getCanWithdrawUnfreezeAmount(request.getOwnerAddress(), request.getTimestamp()));
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
            }
            responseObserver.onCompleted();
        }

        public void getExchangeById(GrpcAPI.BytesMessage request, StreamObserver<Protocol.Exchange> responseObserver) {
            ByteString exchangeId = request.getValue();
            if (Objects.nonNull(exchangeId)) {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getExchangeById(exchangeId));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        public void listExchanges(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.ExchangeList> responseObserver) {
            responseObserver.onNext((Object)RpcApiService.this.wallet.getExchangeList());
            responseObserver.onCompleted();
        }

        public void getTransactionCountByBlockNum(GrpcAPI.NumberMessage request, StreamObserver<GrpcAPI.NumberMessage> responseObserver) {
            RpcApiService.this.getTransactionCountByBlockNumCommon(request, responseObserver);
        }

        public void getTransactionById(GrpcAPI.BytesMessage request, StreamObserver<Protocol.Transaction> responseObserver) {
            ByteString id = request.getValue();
            if (null != id) {
                Protocol.Transaction reply = RpcApiService.this.wallet.getTransactionById(id);
                responseObserver.onNext((Object)reply);
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        public void getTransactionInfoById(GrpcAPI.BytesMessage request, StreamObserver<Protocol.TransactionInfo> responseObserver) {
            ByteString id = request.getValue();
            if (null != id) {
                Protocol.TransactionInfo reply = RpcApiService.this.wallet.getTransactionInfoById(id);
                responseObserver.onNext((Object)reply);
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        public void getRewardInfo(GrpcAPI.BytesMessage request, StreamObserver<GrpcAPI.NumberMessage> responseObserver) {
            RpcApiService.this.getRewardInfoCommon(request, responseObserver);
        }

        public void getBrokerageInfo(GrpcAPI.BytesMessage request, StreamObserver<GrpcAPI.NumberMessage> responseObserver) {
            RpcApiService.this.getBrokerageInfoCommon(request, responseObserver);
        }

        public void getBurnTrx(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.NumberMessage> responseObserver) {
            RpcApiService.this.getBurnTrxCommon(request, responseObserver);
        }

        public void getMerkleTreeVoucherInfo(ShieldContract.OutputPointInfo request, StreamObserver<ShieldContract.IncrementalMerkleVoucherInfo> responseObserver) {
            try {
                RpcApiService.this.checkSupportShieldedTransaction();
                ShieldContract.IncrementalMerkleVoucherInfo witnessInfo = RpcApiService.this.wallet.getMerkleTreeVoucherInfo(request);
                responseObserver.onNext((Object)witnessInfo);
            }
            catch (Exception ex) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(ex));
            }
            responseObserver.onCompleted();
        }

        public void scanNoteByIvk(GrpcAPI.IvkDecryptParameters request, StreamObserver<GrpcAPI.DecryptNotes> responseObserver) {
            long startNum = request.getStartBlockIndex();
            long endNum = request.getEndBlockIndex();
            try {
                RpcApiService.this.checkSupportShieldedTransaction();
                GrpcAPI.DecryptNotes decryptNotes = RpcApiService.this.wallet.scanNoteByIvk(startNum, endNum, request.getIvk().toByteArray());
                responseObserver.onNext((Object)decryptNotes);
            }
            catch (BadItemException | ZksnarkException e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException((Exception)e));
            }
            responseObserver.onCompleted();
        }

        public void scanAndMarkNoteByIvk(GrpcAPI.IvkDecryptAndMarkParameters request, StreamObserver<GrpcAPI.DecryptNotesMarked> responseObserver) {
            long startNum = request.getStartBlockIndex();
            long endNum = request.getEndBlockIndex();
            try {
                RpcApiService.this.checkSupportShieldedTransaction();
                GrpcAPI.DecryptNotesMarked decryptNotes = RpcApiService.this.wallet.scanAndMarkNoteByIvk(startNum, endNum, request.getIvk().toByteArray(), request.getAk().toByteArray(), request.getNk().toByteArray());
                responseObserver.onNext((Object)decryptNotes);
            }
            catch (InvalidProtocolBufferException | BadItemException | ItemNotFoundException | ZksnarkException e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException((Exception)e));
            }
            responseObserver.onCompleted();
        }

        public void scanNoteByOvk(GrpcAPI.OvkDecryptParameters request, StreamObserver<GrpcAPI.DecryptNotes> responseObserver) {
            long startNum = request.getStartBlockIndex();
            long endNum = request.getEndBlockIndex();
            try {
                RpcApiService.this.checkSupportShieldedTransaction();
                GrpcAPI.DecryptNotes decryptNotes = RpcApiService.this.wallet.scanNoteByOvk(startNum, endNum, request.getOvk().toByteArray());
                responseObserver.onNext((Object)decryptNotes);
            }
            catch (BadItemException | ZksnarkException e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException((Exception)e));
            }
            responseObserver.onCompleted();
        }

        public void isSpend(GrpcAPI.NoteParameters request, StreamObserver<GrpcAPI.SpendResult> responseObserver) {
            try {
                RpcApiService.this.checkSupportShieldedTransaction();
                responseObserver.onNext((Object)RpcApiService.this.wallet.isSpend(request));
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
            }
            responseObserver.onCompleted();
        }

        public void scanShieldedTRC20NotesByIvk(GrpcAPI.IvkDecryptTRC20Parameters request, StreamObserver<GrpcAPI.DecryptNotesTRC20> responseObserver) {
            long startNum = request.getStartBlockIndex();
            long endNum = request.getEndBlockIndex();
            byte[] contractAddress = request.getShieldedTRC20ContractAddress().toByteArray();
            byte[] ivk = request.getIvk().toByteArray();
            byte[] ak = request.getAk().toByteArray();
            byte[] nk = request.getNk().toByteArray();
            ProtocolStringList topicsList = request.getEventsList();
            try {
                RpcApiService.this.checkSupportShieldedTRC20Transaction();
                responseObserver.onNext((Object)RpcApiService.this.wallet.scanShieldedTRC20NotesByIvk(startNum, endNum, contractAddress, ivk, ak, nk, topicsList));
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
            }
            responseObserver.onCompleted();
        }

        public void scanShieldedTRC20NotesByOvk(GrpcAPI.OvkDecryptTRC20Parameters request, StreamObserver<GrpcAPI.DecryptNotesTRC20> responseObserver) {
            long startNum = request.getStartBlockIndex();
            long endNum = request.getEndBlockIndex();
            byte[] contractAddress = request.getShieldedTRC20ContractAddress().toByteArray();
            byte[] ovk = request.getOvk().toByteArray();
            ProtocolStringList topicList = request.getEventsList();
            try {
                RpcApiService.this.checkSupportShieldedTRC20Transaction();
                responseObserver.onNext((Object)RpcApiService.this.wallet.scanShieldedTRC20NotesByOvk(startNum, endNum, ovk, contractAddress, topicList));
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
            }
            responseObserver.onCompleted();
        }

        public void isShieldedTRC20ContractNoteSpent(GrpcAPI.NfTRC20Parameters request, StreamObserver<GrpcAPI.NullifierResult> responseObserver) {
            try {
                RpcApiService.this.checkSupportShieldedTRC20Transaction();
                responseObserver.onNext((Object)RpcApiService.this.wallet.isShieldedTRC20ContractNoteSpent(request));
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
            }
            responseObserver.onCompleted();
        }

        public void getMarketOrderByAccount(GrpcAPI.BytesMessage request, StreamObserver<Protocol.MarketOrderList> responseObserver) {
            try {
                ByteString address = request.getValue();
                Protocol.MarketOrderList marketOrderList = RpcApiService.this.wallet.getMarketOrderByAccount(address);
                responseObserver.onNext((Object)marketOrderList);
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
            }
            responseObserver.onCompleted();
        }

        public void getMarketOrderById(GrpcAPI.BytesMessage request, StreamObserver<Protocol.MarketOrder> responseObserver) {
            try {
                ByteString address = request.getValue();
                Protocol.MarketOrder marketOrder = RpcApiService.this.wallet.getMarketOrderById(address);
                responseObserver.onNext((Object)marketOrder);
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
            }
            responseObserver.onCompleted();
        }

        public void getMarketPriceByPair(Protocol.MarketOrderPair request, StreamObserver<Protocol.MarketPriceList> responseObserver) {
            try {
                Protocol.MarketPriceList marketPriceList = RpcApiService.this.wallet.getMarketPriceByPair(request.getSellTokenId().toByteArray(), request.getBuyTokenId().toByteArray());
                responseObserver.onNext((Object)marketPriceList);
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
            }
            responseObserver.onCompleted();
        }

        public void getMarketOrderListByPair(Protocol.MarketOrderPair request, StreamObserver<Protocol.MarketOrderList> responseObserver) {
            try {
                Protocol.MarketOrderList orderPairList = RpcApiService.this.wallet.getMarketOrderListByPair(request.getSellTokenId().toByteArray(), request.getBuyTokenId().toByteArray());
                responseObserver.onNext((Object)orderPairList);
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
            }
            responseObserver.onCompleted();
        }

        public void getMarketPairList(GrpcAPI.EmptyMessage request, StreamObserver<Protocol.MarketOrderPairList> responseObserver) {
            try {
                Protocol.MarketOrderPairList pairList = RpcApiService.this.wallet.getMarketPairList();
                responseObserver.onNext((Object)pairList);
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
            }
            responseObserver.onCompleted();
        }

        public void triggerConstantContract(SmartContractOuterClass.TriggerSmartContract request, StreamObserver<GrpcAPI.TransactionExtention> responseObserver) {
            RpcApiService.this.callContract(request, (StreamObserver<GrpcAPI.TransactionExtention>)responseObserver, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void estimateEnergy(SmartContractOuterClass.TriggerSmartContract request, StreamObserver<GrpcAPI.EstimateEnergyMessage> responseObserver) {
            GrpcAPI.TransactionExtention.Builder trxExtBuilder = GrpcAPI.TransactionExtention.newBuilder();
            GrpcAPI.Return.Builder retBuilder = GrpcAPI.Return.newBuilder();
            GrpcAPI.EstimateEnergyMessage.Builder estimateBuilder = GrpcAPI.EstimateEnergyMessage.newBuilder();
            try {
                TransactionCapsule trxCap = RpcApiService.this.createTransactionCapsule((Message)request, Protocol.Transaction.Contract.ContractType.TriggerSmartContract);
                RpcApiService.this.wallet.estimateEnergy(request, trxCap, trxExtBuilder, retBuilder, estimateBuilder);
            }
            catch (ContractValidateException | VMIllegalException e) {
                retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.CONTRACT_VALIDATE_ERROR).setMessage(ByteString.copyFromUtf8((String)("Contract validate error : " + e.getMessage())));
                logger.warn(RpcApiService.CONTRACT_VALIDATE_EXCEPTION, (Object)e.getMessage());
            }
            catch (RuntimeException e) {
                retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.CONTRACT_EXE_ERROR).setMessage(ByteString.copyFromUtf8((String)(e.getClass() + " : " + e.getMessage())));
                logger.warn("When run estimate energy in VM, have Runtime Exception: " + e.getMessage());
            }
            catch (Exception e) {
                retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.OTHER_ERROR).setMessage(ByteString.copyFromUtf8((String)(e.getClass() + " : " + e.getMessage())));
                logger.warn(RpcApiService.UNKNOWN_EXCEPTION_CAUGHT + e.getMessage(), (Throwable)e);
            }
            finally {
                estimateBuilder.setResult(retBuilder);
                responseObserver.onNext((Object)estimateBuilder.build());
                responseObserver.onCompleted();
            }
        }

        public void getTransactionInfoByBlockNum(GrpcAPI.NumberMessage request, StreamObserver<GrpcAPI.TransactionInfoList> responseObserver) {
            try {
                responseObserver.onNext((Object)RpcApiService.this.wallet.getTransactionInfoByBlockNum(request.getNum()));
            }
            catch (Exception e) {
                responseObserver.onError((Throwable)RpcApiService.this.getRunTimeException(e));
            }
            responseObserver.onCompleted();
        }

        public void getBlock(GrpcAPI.BlockReq request, StreamObserver<GrpcAPI.BlockExtention> responseObserver) {
            RpcApiService.this.getBlockCommon(request, responseObserver);
        }
    }

    public class DatabaseApi
    extends DatabaseGrpc.DatabaseImplBase {
        public void getBlockReference(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.BlockReference> responseObserver) {
            long headBlockNum = RpcApiService.this.dbManager.getDynamicPropertiesStore().getLatestBlockHeaderNumber();
            byte[] blockHeaderHash = RpcApiService.this.dbManager.getDynamicPropertiesStore().getLatestBlockHeaderHash().getBytes();
            GrpcAPI.BlockReference ref = GrpcAPI.BlockReference.newBuilder().setBlockHash(ByteString.copyFrom((byte[])blockHeaderHash)).setBlockNum(headBlockNum).build();
            responseObserver.onNext((Object)ref);
            responseObserver.onCompleted();
        }

        public void getNowBlock(GrpcAPI.EmptyMessage request, StreamObserver<Protocol.Block> responseObserver) {
            Protocol.Block block = null;
            try {
                block = RpcApiService.this.chainBaseManager.getHead().getInstance();
            }
            catch (StoreException e) {
                logger.error(e.getMessage());
            }
            responseObserver.onNext((Object)block);
            responseObserver.onCompleted();
        }

        public void getBlockByNum(GrpcAPI.NumberMessage request, StreamObserver<Protocol.Block> responseObserver) {
            Protocol.Block block = null;
            try {
                block = RpcApiService.this.chainBaseManager.getBlockByNum(request.getNum()).getInstance();
            }
            catch (StoreException e) {
                logger.error(e.getMessage());
            }
            responseObserver.onNext((Object)block);
            responseObserver.onCompleted();
        }

        public void getDynamicProperties(GrpcAPI.EmptyMessage request, StreamObserver<Protocol.DynamicProperties> responseObserver) {
            Protocol.DynamicProperties.Builder builder = Protocol.DynamicProperties.newBuilder();
            builder.setLastSolidityBlockNum(RpcApiService.this.dbManager.getDynamicPropertiesStore().getLatestSolidifiedBlockNum());
            Protocol.DynamicProperties dynamicProperties = builder.build();
            responseObserver.onNext((Object)dynamicProperties);
            responseObserver.onCompleted();
        }
    }
}

