/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.service.sync;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.utils.Pair;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.config.args.Args;
import org.tron.core.exception.P2pException;
import org.tron.core.net.TronNetDelegate;
import org.tron.core.net.message.adv.BlockMessage;
import org.tron.core.net.message.adv.FetchInvDataMessage;
import org.tron.core.net.message.sync.SyncBlockChainMessage;
import org.tron.core.net.messagehandler.PbftDataSyncHandler;
import org.tron.core.net.peer.PeerConnection;
import org.tron.core.net.peer.TronState;
import org.tron.protos.Protocol;

@Component
public class SyncService {
    private static final Logger logger = LoggerFactory.getLogger((String)"net");
    @Autowired
    private TronNetDelegate tronNetDelegate;
    @Autowired
    private PbftDataSyncHandler pbftDataSyncHandler;
    private Map<BlockMessage, PeerConnection> blockWaitToProcess = new ConcurrentHashMap<BlockMessage, PeerConnection>();
    private Map<BlockMessage, PeerConnection> blockJustReceived = new ConcurrentHashMap<BlockMessage, PeerConnection>();
    private long blockCacheTimeout = Args.getInstance().getBlockCacheTimeout();
    private Cache<BlockCapsule.BlockId, PeerConnection> requestBlockIds = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(this.blockCacheTimeout, TimeUnit.MINUTES).initialCapacity(10000).recordStats().build();
    private ScheduledExecutorService fetchExecutor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledExecutorService blockHandleExecutor = Executors.newSingleThreadScheduledExecutor();
    private volatile boolean handleFlag = false;
    private volatile boolean fetchFlag = false;
    private final long syncFetchBatchNum = Args.getInstance().getSyncFetchBatchNum();

    public void init() {
        this.fetchExecutor.scheduleWithFixedDelay(() -> {
            try {
                if (this.fetchFlag) {
                    this.fetchFlag = false;
                    this.startFetchSyncBlock();
                }
            }
            catch (Exception e) {
                logger.error("Fetch sync block error", (Throwable)e);
            }
        }, 10L, 1L, TimeUnit.SECONDS);
        this.blockHandleExecutor.scheduleWithFixedDelay(() -> {
            try {
                if (this.handleFlag) {
                    this.handleFlag = false;
                    this.handleSyncBlock();
                }
            }
            catch (Exception e) {
                logger.error("Handle sync block error", (Throwable)e);
            }
        }, 10L, 1L, TimeUnit.SECONDS);
    }

    public void close() {
        this.fetchExecutor.shutdown();
        this.blockHandleExecutor.shutdown();
    }

    public void startSync(PeerConnection peer) {
        if (peer.getTronState().equals((Object)TronState.SYNCING)) {
            logger.warn("Start sync failed, peer {} is in sync", (Object)peer.getInetSocketAddress());
            return;
        }
        peer.setTronState(TronState.SYNCING);
        peer.setNeedSyncFromPeer(true);
        peer.getSyncBlockToFetch().clear();
        peer.setRemainNum(0L);
        peer.setBlockBothHave(this.tronNetDelegate.getGenesisBlockId());
        this.syncNext(peer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncNext(PeerConnection peer) {
        try {
            LinkedList<BlockCapsule.BlockId> chainSummary;
            if (peer.getSyncChainRequested() != null) {
                logger.warn("Peer {} is in sync", (Object)peer.getInetSocketAddress());
                return;
            }
            Object object = this.tronNetDelegate.getForkLock();
            synchronized (object) {
                chainSummary = this.getBlockChainSummary(peer);
            }
            peer.setSyncChainRequested((Pair<Deque<BlockCapsule.BlockId>, Long>)new Pair(chainSummary, (Object)System.currentTimeMillis()));
            peer.sendMessage(new SyncBlockChainMessage(chainSummary));
        }
        catch (Exception e) {
            logger.error("Peer {} sync failed, reason: {}", (Object)peer.getInetAddress(), (Object)e);
            peer.disconnect(Protocol.ReasonCode.SYNC_FAIL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processBlock(PeerConnection peer, BlockMessage blockMessage) {
        Map<BlockMessage, PeerConnection> map = this.blockJustReceived;
        synchronized (map) {
            this.blockJustReceived.put(blockMessage, peer);
        }
        this.handleFlag = true;
        if (peer.isIdle()) {
            if (peer.getRemainNum() > 0L && (long)peer.getSyncBlockToFetch().size() <= this.syncFetchBatchNum) {
                this.syncNext(peer);
            } else {
                this.fetchFlag = true;
            }
        }
    }

    public void onDisconnect(PeerConnection peer) {
        if (!peer.getSyncBlockRequested().isEmpty()) {
            peer.getSyncBlockRequested().keySet().forEach(blockId -> this.invalid((BlockCapsule.BlockId)blockId, peer));
        }
    }

    private void invalid(BlockCapsule.BlockId blockId, PeerConnection peerConnection) {
        PeerConnection p = (PeerConnection)this.requestBlockIds.getIfPresent((Object)blockId);
        if (peerConnection.equals(p)) {
            this.requestBlockIds.invalidate((Object)blockId);
            this.fetchFlag = true;
        }
    }

    private LinkedList<BlockCapsule.BlockId> getBlockChainSummary(PeerConnection peer) throws P2pException {
        long highNoFork;
        long high;
        long low;
        BlockCapsule.BlockId beginBlockId = peer.getBlockBothHave();
        ArrayList<BlockCapsule.BlockId> blockIds = new ArrayList<BlockCapsule.BlockId>(peer.getSyncBlockToFetch());
        List<Object> forkList = new LinkedList();
        LinkedList<BlockCapsule.BlockId> summary = new LinkedList<BlockCapsule.BlockId>();
        long syncBeginNumber = this.tronNetDelegate.getSyncBeginNumber();
        long l = low = syncBeginNumber < 0L ? 0L : syncBeginNumber;
        if (beginBlockId.getNum() == 0L) {
            highNoFork = high = this.tronNetDelegate.getHeadBlockId().getNum();
        } else if (this.tronNetDelegate.getKhaosDbHeadBlockId().equals((Object)beginBlockId) || this.tronNetDelegate.containBlockInMainChain(beginBlockId)) {
            highNoFork = high = beginBlockId.getNum();
        } else {
            forkList = this.tronNetDelegate.getBlockChainHashesOnFork(beginBlockId);
            if (forkList.isEmpty()) {
                throw new P2pException(P2pException.TypeEnum.SYNC_FAILED, "can't find blockId: " + beginBlockId.getString());
            }
            highNoFork = ((BlockCapsule.BlockId)((LinkedList)forkList).peekLast()).getNum();
            ((LinkedList)forkList).pollLast();
            Collections.reverse(forkList);
            high = highNoFork + (long)forkList.size();
        }
        if (low > highNoFork) {
            throw new P2pException(P2pException.TypeEnum.SYNC_FAILED, "low: " + low + " gt highNoFork: " + highNoFork);
        }
        long realHigh = high + (long)blockIds.size();
        logger.info("Get block chain summary, low: {}, highNoFork: {}, high: {}, realHigh: {}", new Object[]{low, highNoFork, high, realHigh});
        while (low <= realHigh) {
            if (low <= highNoFork) {
                summary.offer(this.getBlockIdByNum(low));
            } else if (low <= high) {
                summary.offer((BlockCapsule.BlockId)forkList.get((int)(low - highNoFork - 1L)));
            } else {
                summary.offer((BlockCapsule.BlockId)blockIds.get((int)(low - high - 1L)));
            }
            low += (realHigh - low + 2L) / 2L;
        }
        return summary;
    }

    private BlockCapsule.BlockId getBlockIdByNum(long num) throws P2pException {
        BlockCapsule.BlockId head = this.tronNetDelegate.getKhaosDbHeadBlockId();
        if (num == head.getNum()) {
            return head;
        }
        head = this.tronNetDelegate.getHeadBlockId();
        if (num == head.getNum()) {
            return head;
        }
        return this.tronNetDelegate.getBlockIdByNum(num);
    }

    private void startFetchSyncBlock() {
        HashMap<PeerConnection, List> send = new HashMap<PeerConnection, List>();
        this.tronNetDelegate.getActivePeer().stream().filter(peer -> peer.isNeedSyncFromPeer() && peer.isIdle()).filter(peer -> peer.isFetchAble()).forEach(peer -> {
            if (!send.containsKey(peer)) {
                send.put((PeerConnection)peer, new LinkedList());
            }
            for (BlockCapsule.BlockId blockId : peer.getSyncBlockToFetch()) {
                if (this.requestBlockIds.getIfPresent((Object)blockId) != null || peer.getSyncBlockInProcess().contains(blockId)) continue;
                this.requestBlockIds.put((Object)blockId, peer);
                peer.getSyncBlockRequested().put(blockId, System.currentTimeMillis());
                ((List)send.get(peer)).add(blockId);
                if (((List)send.get(peer)).size() < 100) continue;
                break;
            }
        });
        send.forEach((peer, blockIds) -> {
            if (!blockIds.isEmpty()) {
                peer.sendMessage(new FetchInvDataMessage(new LinkedList<Sha256Hash>((Collection<Sha256Hash>)blockIds), Protocol.Inventory.InventoryType.BLOCK));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void handleSyncBlock() {
        Map<BlockMessage, PeerConnection> map = this.blockJustReceived;
        synchronized (map) {
            this.blockWaitToProcess.putAll(this.blockJustReceived);
            this.blockJustReceived.clear();
        }
        boolean[] isProcessed = new boolean[]{true};
        long solidNum = this.tronNetDelegate.getSolidBlockId().getNum();
        while (isProcessed[0]) {
            isProcessed[0] = false;
            this.blockWaitToProcess.forEach((msg, peerConnection) -> {
                Object object = this.tronNetDelegate.getBlockLock();
                synchronized (object) {
                    if (peerConnection.isDisconnect()) {
                        this.blockWaitToProcess.remove(msg);
                        this.invalid(msg.getBlockId(), (PeerConnection)peerConnection);
                        return;
                    }
                    if (msg.getBlockId().getNum() <= solidNum) {
                        this.blockWaitToProcess.remove(msg);
                        peerConnection.getSyncBlockInProcess().remove(msg.getBlockId());
                        return;
                    }
                    boolean[] isFound = new boolean[]{false};
                    this.tronNetDelegate.getActivePeer().stream().filter(peer -> msg.getBlockId().equals((Object)peer.getSyncBlockToFetch().peek())).forEach(peer -> {
                        isFound[0] = true;
                    });
                    if (isFound[0]) {
                        this.blockWaitToProcess.remove(msg);
                        isProcessed[0] = true;
                        this.processSyncBlock(msg.getBlockCapsule(), (PeerConnection)peerConnection);
                        peerConnection.getSyncBlockInProcess().remove(msg.getBlockId());
                    }
                }
            });
        }
    }

    private void processSyncBlock(BlockCapsule block, PeerConnection peerConnection) {
        boolean flag = true;
        boolean attackFlag = false;
        BlockCapsule.BlockId blockId = block.getBlockId();
        try {
            this.tronNetDelegate.validSignature(block);
            this.tronNetDelegate.processBlock(block, true);
            this.pbftDataSyncHandler.processPBFTCommitData(block);
        }
        catch (P2pException p2pException) {
            logger.error("Process sync block {} failed, type: {}", (Object)blockId.getString(), (Object)p2pException.getType());
            attackFlag = p2pException.getType().equals((Object)P2pException.TypeEnum.BLOCK_SIGN_ERROR) || p2pException.getType().equals((Object)P2pException.TypeEnum.BLOCK_MERKLE_ERROR);
            flag = false;
        }
        catch (Exception e) {
            logger.error("Process sync block {} failed", (Object)blockId.getString(), (Object)e);
            flag = false;
        }
        if (attackFlag) {
            this.invalid(blockId, peerConnection);
            peerConnection.disconnect(Protocol.ReasonCode.BAD_BLOCK);
            return;
        }
        for (PeerConnection peer : this.tronNetDelegate.getActivePeer()) {
            if (!blockId.equals((Object)peer.getSyncBlockToFetch().peek())) continue;
            peer.getSyncBlockToFetch().pop();
            if (flag) {
                peer.setBlockBothHave(blockId);
                if (!peer.getSyncBlockToFetch().isEmpty() || !peer.isFetchAble()) continue;
                this.syncNext(peer);
                continue;
            }
            peer.disconnect(Protocol.ReasonCode.BAD_BLOCK);
        }
    }

    public void setFetchFlag(boolean fetchFlag) {
        this.fetchFlag = fetchFlag;
    }
}

