/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.service.statistics;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.net.InetAddress;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.tron.common.prometheus.Metrics;
import org.tron.core.metrics.MetricsUtil;
import org.tron.core.net.TronNetService;
import org.tron.core.net.service.statistics.NodeStatistics;
import org.tron.p2p.stats.P2pStats;

@Component
public class TronStatsManager {
    private static final Logger logger = LoggerFactory.getLogger((String)"net");
    private volatile long TCP_TRAFFIC_IN = 0L;
    private volatile long TCP_TRAFFIC_OUT = 0L;
    private volatile long UDP_TRAFFIC_IN = 0L;
    private volatile long UDP_TRAFFIC_OUT = 0L;
    private static Cache<InetAddress, NodeStatistics> cache = CacheBuilder.newBuilder().maximumSize(3000L).recordStats().build();
    private ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

    public static NodeStatistics getNodeStatistics(InetAddress inetAddress) {
        NodeStatistics nodeStatistics = (NodeStatistics)cache.getIfPresent((Object)inetAddress);
        if (nodeStatistics == null) {
            nodeStatistics = new NodeStatistics();
            cache.put((Object)inetAddress, (Object)nodeStatistics);
        }
        return nodeStatistics;
    }

    public void init() {
        this.executor.scheduleWithFixedDelay(() -> {
            try {
                this.work();
            }
            catch (Throwable t) {
                logger.error("Exception in traffic stats worker, {}", (Object)t.getMessage());
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    public void close() {
        try {
            this.executor.shutdownNow();
        }
        catch (Exception e) {
            logger.error("Exception in shutdown traffic stats worker, {}", (Object)e.getMessage());
        }
    }

    private void work() {
        P2pStats stats = TronNetService.getP2pService().getP2pStats();
        MetricsUtil.meterMark("net.tcpInTraffic", stats.getTcpInSize() - this.TCP_TRAFFIC_IN);
        Metrics.histogramObserve((String)"tron:tcp_bytes", (double)(stats.getTcpInSize() - this.TCP_TRAFFIC_IN), (String[])new String[]{"in"});
        MetricsUtil.meterMark("net.tcpOutTraffic", stats.getTcpOutSize() - this.TCP_TRAFFIC_OUT);
        Metrics.histogramObserve((String)"tron:udp_bytes", (double)(stats.getUdpInSize() - this.UDP_TRAFFIC_IN), (String[])new String[]{"in"});
        MetricsUtil.meterMark("net.udpOutTraffic", stats.getUdpOutSize() - this.UDP_TRAFFIC_OUT);
        Metrics.histogramObserve((String)"tron:udp_bytes", (double)(stats.getUdpOutSize() - this.UDP_TRAFFIC_OUT), (String[])new String[]{"out"});
        this.TCP_TRAFFIC_IN = stats.getTcpInSize();
        this.TCP_TRAFFIC_OUT = stats.getTcpOutSize();
        this.UDP_TRAFFIC_IN = stats.getUdpInSize();
        this.UDP_TRAFFIC_OUT = stats.getUdpOutSize();
    }
}

