/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.service.statistics;

import org.tron.common.overlay.message.Message;
import org.tron.core.net.message.MessageTypes;
import org.tron.core.net.message.adv.FetchInvDataMessage;
import org.tron.core.net.message.adv.InventoryMessage;
import org.tron.core.net.message.adv.TransactionsMessage;
import org.tron.core.net.service.statistics.MessageCount;

public class MessageStatistics {
    public final MessageCount p2pInHello = new MessageCount();
    public final MessageCount p2pOutHello = new MessageCount();
    public final MessageCount p2pInPing = new MessageCount();
    public final MessageCount p2pOutPing = new MessageCount();
    public final MessageCount p2pInPong = new MessageCount();
    public final MessageCount p2pOutPong = new MessageCount();
    public final MessageCount p2pInDisconnect = new MessageCount();
    public final MessageCount p2pOutDisconnect = new MessageCount();
    public final MessageCount tronInMessage = new MessageCount();
    public final MessageCount tronOutMessage = new MessageCount();
    public final MessageCount tronInSyncBlockChain = new MessageCount();
    public final MessageCount tronOutSyncBlockChain = new MessageCount();
    public final MessageCount tronInBlockChainInventory = new MessageCount();
    public final MessageCount tronOutBlockChainInventory = new MessageCount();
    public final MessageCount tronInTrxInventory = new MessageCount();
    public final MessageCount tronOutTrxInventory = new MessageCount();
    public final MessageCount tronInTrxInventoryElement = new MessageCount();
    public final MessageCount tronOutTrxInventoryElement = new MessageCount();
    public final MessageCount tronInBlockInventory = new MessageCount();
    public final MessageCount tronOutBlockInventory = new MessageCount();
    public final MessageCount tronInBlockInventoryElement = new MessageCount();
    public final MessageCount tronOutBlockInventoryElement = new MessageCount();
    public final MessageCount tronInTrxFetchInvData = new MessageCount();
    public final MessageCount tronOutTrxFetchInvData = new MessageCount();
    public final MessageCount tronInTrxFetchInvDataElement = new MessageCount();
    public final MessageCount tronOutTrxFetchInvDataElement = new MessageCount();
    public final MessageCount tronInBlockFetchInvData = new MessageCount();
    public final MessageCount tronOutBlockFetchInvData = new MessageCount();
    public final MessageCount tronInBlockFetchInvDataElement = new MessageCount();
    public final MessageCount tronOutBlockFetchInvDataElement = new MessageCount();
    public final MessageCount tronInTrx = new MessageCount();
    public final MessageCount tronOutTrx = new MessageCount();
    public final MessageCount tronInTrxs = new MessageCount();
    public final MessageCount tronOutTrxs = new MessageCount();
    public final MessageCount tronInBlock = new MessageCount();
    public final MessageCount tronOutBlock = new MessageCount();
    public final MessageCount tronOutAdvBlock = new MessageCount();

    public void addTcpInMessage(Message msg) {
        this.addTcpMessage(msg, true);
    }

    public void addTcpOutMessage(Message msg) {
        this.addTcpMessage(msg, false);
    }

    private void addTcpMessage(Message msg, boolean flag) {
        if (flag) {
            this.tronInMessage.add();
        } else {
            this.tronOutMessage.add();
        }
        switch (msg.getType()) {
            case P2P_HELLO: {
                if (flag) {
                    this.p2pInHello.add();
                    break;
                }
                this.p2pOutHello.add();
                break;
            }
            case P2P_PING: {
                if (flag) {
                    this.p2pInPing.add();
                    break;
                }
                this.p2pOutPing.add();
                break;
            }
            case P2P_PONG: {
                if (flag) {
                    this.p2pInPong.add();
                    break;
                }
                this.p2pOutPong.add();
                break;
            }
            case P2P_DISCONNECT: {
                if (flag) {
                    this.p2pInDisconnect.add();
                    break;
                }
                this.p2pOutDisconnect.add();
                break;
            }
            case SYNC_BLOCK_CHAIN: {
                if (flag) {
                    this.tronInSyncBlockChain.add();
                    break;
                }
                this.tronOutSyncBlockChain.add();
                break;
            }
            case BLOCK_CHAIN_INVENTORY: {
                if (flag) {
                    this.tronInBlockChainInventory.add();
                    break;
                }
                this.tronOutBlockChainInventory.add();
                break;
            }
            case INVENTORY: {
                InventoryMessage inventoryMessage = (InventoryMessage)msg;
                int inventorySize = inventoryMessage.getInventory().getIdsCount();
                this.messageProcess(inventoryMessage.getInvMessageType(), this.tronInTrxInventory, this.tronInTrxInventoryElement, this.tronInBlockInventory, this.tronInBlockInventoryElement, this.tronOutTrxInventory, this.tronOutTrxInventoryElement, this.tronOutBlockInventory, this.tronOutBlockInventoryElement, flag, inventorySize);
                break;
            }
            case FETCH_INV_DATA: {
                FetchInvDataMessage fetchInvDataMessage = (FetchInvDataMessage)msg;
                int fetchSize = fetchInvDataMessage.getInventory().getIdsCount();
                this.messageProcess(fetchInvDataMessage.getInvMessageType(), this.tronInTrxFetchInvData, this.tronInTrxFetchInvDataElement, this.tronInBlockFetchInvData, this.tronInBlockFetchInvDataElement, this.tronOutTrxFetchInvData, this.tronOutTrxFetchInvDataElement, this.tronOutBlockFetchInvData, this.tronOutBlockFetchInvDataElement, flag, fetchSize);
                break;
            }
            case TRXS: {
                TransactionsMessage transactionsMessage = (TransactionsMessage)msg;
                if (flag) {
                    this.tronInTrxs.add();
                    this.tronInTrx.add(transactionsMessage.getTransactions().getTransactionsCount());
                    break;
                }
                this.tronOutTrxs.add();
                this.tronOutTrx.add(transactionsMessage.getTransactions().getTransactionsCount());
                break;
            }
            case TRX: {
                if (flag) {
                    this.tronInTrx.add();
                    break;
                }
                this.tronOutTrx.add();
                break;
            }
            case BLOCK: {
                if (flag) {
                    this.tronInBlock.add();
                    break;
                }
                this.tronOutBlock.add();
                break;
            }
        }
    }

    private void messageProcess(MessageTypes messageType, MessageCount inTrx, MessageCount inTrxEle, MessageCount inBlock, MessageCount inBlockEle, MessageCount outTrx, MessageCount outTrxEle, MessageCount outBlock, MessageCount outBlockEle, boolean flag, int size) {
        if (flag) {
            if (messageType == MessageTypes.TRX) {
                inTrx.add();
                inTrxEle.add(size);
            } else {
                inBlock.add();
                inBlockEle.add(size);
            }
        } else if (messageType == MessageTypes.TRX) {
            outTrx.add();
            outTrxEle.add(size);
        } else {
            outBlock.add();
            outBlockEle.add(size);
        }
    }
}

