/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.service.nodepersist;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.JsonUtil;
import org.tron.core.capsule.BytesCapsule;
import org.tron.core.db.CommonStore;
import org.tron.core.net.TronNetService;
import org.tron.core.net.service.nodepersist.DBNode;
import org.tron.core.net.service.nodepersist.DBNodes;
import org.tron.p2p.discover.Node;

@Component
public class NodePersistService {
    private static final Logger logger = LoggerFactory.getLogger((String)"net");
    private static final byte[] DB_KEY_PEERS = "peers".getBytes();
    private static final long DB_COMMIT_RATE = 60000L;
    private static final int MAX_NODES_WRITE_TO_DB = 30;
    private final boolean isNodePersist = CommonParameter.getInstance().isNodeDiscoveryPersist();
    @Autowired
    private CommonStore commonStore;
    private Timer nodePersistTaskTimer;

    public void init() {
        if (this.isNodePersist) {
            this.nodePersistTaskTimer = new Timer("NodePersistTaskTimer");
            this.nodePersistTaskTimer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    NodePersistService.this.dbWrite();
                }
            }, 60000L, 60000L);
        }
    }

    public void close() {
        if (Objects.isNull(this.nodePersistTaskTimer)) {
            return;
        }
        try {
            this.nodePersistTaskTimer.cancel();
        }
        catch (Exception e) {
            logger.error("Close nodePersistTaskTimer failed", (Throwable)e);
        }
    }

    public List<InetSocketAddress> dbRead() {
        ArrayList<InetSocketAddress> nodes = new ArrayList<InetSocketAddress>();
        try {
            byte[] nodeBytes = this.commonStore.get(DB_KEY_PEERS).getData();
            if (ByteArray.isEmpty((byte[])nodeBytes)) {
                return nodes;
            }
            DBNodes dbNodes = (DBNodes)JsonUtil.json2Obj((String)new String(nodeBytes), DBNodes.class);
            logger.info("Read node from store: {} nodes", (Object)dbNodes.getNodes().size());
            dbNodes.getNodes().forEach(n -> nodes.add(new InetSocketAddress(n.getHost(), n.getPort())));
        }
        catch (Exception e) {
            logger.warn("DB read nodes failed, {}", (Object)e.getMessage());
        }
        return nodes;
    }

    private void dbWrite() {
        try {
            ArrayList<DBNode> batch = new ArrayList<DBNode>();
            List tableNodes = TronNetService.getP2pService().getTableNodes();
            tableNodes.sort(Comparator.comparingLong(value -> -value.getUpdateTime()));
            for (Node n : tableNodes) {
                batch.add(new DBNode(n.getPreferInetSocketAddress().getAddress().getHostAddress(), n.getPort()));
            }
            if (batch.size() > 30) {
                batch = batch.subList(0, 30);
            }
            DBNodes dbNodes = new DBNodes();
            dbNodes.setNodes(batch);
            logger.info("Write nodes to store: {}/{} nodes", (Object)batch.size(), (Object)tableNodes.size());
            this.commonStore.put(DB_KEY_PEERS, new BytesCapsule(JsonUtil.obj2Json((Object)dbNodes).getBytes()));
        }
        catch (Exception e) {
            logger.warn("DB write nodes failed, {}", (Object)e.getMessage());
        }
    }
}

