/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.service.fetchblock;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.ChainBaseManager;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.metrics.MetricsUtil;
import org.tron.core.net.TronNetDelegate;
import org.tron.core.net.message.adv.FetchInvDataMessage;
import org.tron.core.net.peer.Item;
import org.tron.core.net.peer.PeerConnection;
import org.tron.protos.Protocol;

@Component
public class FetchBlockService {
    private static final Logger logger = LoggerFactory.getLogger((String)"net");
    @Autowired
    private TronNetDelegate tronNetDelegate;
    @Autowired
    private ChainBaseManager chainBaseManager;
    private FetchBlockInfo fetchBlockInfo = null;
    private final long fetchTimeOut;
    private static final double BLOCK_FETCH_LEFT_TIME_PERCENT = 0.5;
    private final ScheduledExecutorService fetchBlockWorkerExecutor;

    public FetchBlockService() {
        this.fetchTimeOut = CommonParameter.getInstance().fetchBlockTimeout;
        this.fetchBlockWorkerExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("FetchBlockWorkerSchedule-").build());
    }

    public void init() {
        this.fetchBlockWorkerExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.fetchBlockProcess(this.fetchBlockInfo);
            }
            catch (Exception e) {
                logger.error("FetchBlockWorkerSchedule thread error", (Throwable)e);
            }
        }, 0L, 50L, TimeUnit.MILLISECONDS);
    }

    public void close() {
        this.fetchBlockWorkerExecutor.shutdown();
    }

    public void fetchBlock(List<Sha256Hash> sha256HashList, PeerConnection peer) {
        if (sha256HashList.size() > 0) {
            logger.info("Begin fetch block {} from {}", (Object)new BlockCapsule.BlockId(sha256HashList.get(0)).getString(), (Object)peer.getInetAddress());
        }
        if (null != this.fetchBlockInfo) {
            return;
        }
        sha256HashList.stream().filter(sha256Hash -> new BlockCapsule.BlockId(sha256Hash).getNum() == this.chainBaseManager.getHeadBlockNum() + 1L).findFirst().ifPresent(sha256Hash -> {
            this.fetchBlockInfo = new FetchBlockInfo((Sha256Hash)sha256Hash, peer, System.currentTimeMillis());
            logger.info("Set fetchBlockInfo, block: {}, peer: {}, time: {}", new Object[]{sha256Hash, this.fetchBlockInfo.getPeer().getInetAddress(), this.fetchBlockInfo.getTime()});
        });
    }

    public void blockFetchSuccess(Sha256Hash sha256Hash) {
        logger.info("Fetch block success, {}", (Object)new BlockCapsule.BlockId(sha256Hash).getString());
        FetchBlockInfo fetchBlockInfoTemp = this.fetchBlockInfo;
        if (null == fetchBlockInfoTemp || !fetchBlockInfoTemp.getHash().equals((Object)sha256Hash)) {
            return;
        }
        this.fetchBlockInfo = null;
    }

    private void fetchBlockProcess(FetchBlockInfo fetchBlock) {
        if (null == fetchBlock) {
            return;
        }
        Item item = new Item(fetchBlock.getHash(), Protocol.Inventory.InventoryType.BLOCK);
        Optional<PeerConnection> optionalPeerConnection = this.tronNetDelegate.getActivePeer().stream().filter(PeerConnection::isIdle).filter(filterPeer -> !filterPeer.equals(fetchBlock.getPeer())).filter(filterPeer -> filterPeer.getAdvInvReceive().getIfPresent((Object)item) != null).filter(filterPeer -> this.getPeerTop75((PeerConnection)filterPeer) <= (double)CommonParameter.getInstance().fetchBlockTimeout).min(Comparator.comparingDouble(this::getPeerTop75));
        if (optionalPeerConnection.isPresent()) {
            optionalPeerConnection.ifPresent(firstPeer -> {
                if (this.shouldFetchBlock((PeerConnection)firstPeer, fetchBlock) && firstPeer.checkAndPutAdvInvRequest(item, System.currentTimeMillis())) {
                    firstPeer.sendMessage(new FetchInvDataMessage(Collections.singletonList(item.getHash()), item.getType()));
                    this.fetchBlockInfo = null;
                }
            });
        } else if (System.currentTimeMillis() - fetchBlock.getTime() >= this.fetchTimeOut) {
            logger.info("Clear fetchBlockInfo due to fetch block {} timeout {}ms", (Object)fetchBlock.getHash(), (Object)this.fetchTimeOut);
            this.fetchBlockInfo = null;
        }
    }

    private boolean shouldFetchBlock(PeerConnection newPeer, FetchBlockInfo fetchBlock) {
        double newPeerTop75 = this.getPeerTop75(newPeer);
        double oldPeerTop75 = this.getPeerTop75(fetchBlock.getPeer());
        long oldPeerSpendTime = System.currentTimeMillis() - fetchBlock.getTime();
        if (oldPeerTop75 > (double)this.fetchTimeOut || oldPeerSpendTime >= this.fetchTimeOut) {
            return true;
        }
        double oldPeerLeftTime = oldPeerTop75 - (double)oldPeerSpendTime;
        return newPeerTop75 < oldPeerLeftTime * 0.5 && (double)oldPeerSpendTime + newPeerTop75 < (double)this.fetchTimeOut;
    }

    private double getPeerTop75(PeerConnection peerConnection) {
        return MetricsUtil.getHistogram("net.latency.fetch.block." + peerConnection.getInetAddress()).getSnapshot().get75thPercentile();
    }

    private static class FetchBlockInfo {
        private PeerConnection peer;
        private Sha256Hash hash;
        private long time;

        public FetchBlockInfo(Sha256Hash hash, PeerConnection peer, long time) {
            this.peer = peer;
            this.hash = hash;
            this.time = time;
        }

        public PeerConnection getPeer() {
            return this.peer;
        }

        public void setPeer(PeerConnection peer) {
            this.peer = peer;
        }

        public Sha256Hash getHash() {
            return this.hash;
        }

        public void setHash(Sha256Hash hash) {
            this.hash = hash;
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }
    }
}

