/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.peer;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.core.net.TronNetDelegate;
import org.tron.protos.Protocol;

@Component
public class PeerStatusCheck {
    private static final Logger logger = LoggerFactory.getLogger((String)"net");
    @Autowired
    private TronNetDelegate tronNetDelegate;
    private ScheduledExecutorService peerStatusCheckExecutor = Executors.newSingleThreadScheduledExecutor();
    private int blockUpdateTimeout = 30000;

    public void init() {
        this.peerStatusCheckExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.statusCheck();
            }
            catch (Exception e) {
                logger.error("Check peers status processing failed", (Throwable)e);
            }
        }, 5L, 2L, TimeUnit.SECONDS);
    }

    public void close() {
        this.peerStatusCheckExecutor.shutdown();
    }

    public void statusCheck() {
        long now = System.currentTimeMillis();
        this.tronNetDelegate.getActivePeer().forEach(peer -> {
            boolean isDisconnected = false;
            if (peer.isNeedSyncFromPeer() && peer.getBlockBothHaveUpdateTime() < now - (long)this.blockUpdateTimeout) {
                logger.warn("Peer {} not sync for a long time", (Object)peer.getInetAddress());
                isDisconnected = true;
            }
            if (!isDisconnected && (isDisconnected = peer.getAdvInvRequest().values().stream().anyMatch(time -> time < now - 20000L))) {
                logger.warn("Peer {} get avd message timeout", (Object)peer.getInetAddress());
            }
            if (!isDisconnected && (isDisconnected = peer.getSyncBlockRequested().values().stream().anyMatch(time -> time < now - 5000L))) {
                logger.warn("Peer {} get sync message timeout", (Object)peer.getInetAddress());
            }
            if (isDisconnected) {
                peer.disconnect(Protocol.ReasonCode.TIME_OUT);
            }
        });
    }
}

