/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.peer;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.protobuf.ByteString;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.tron.common.overlay.message.Message;
import org.tron.common.prometheus.Metrics;
import org.tron.common.utils.Pair;
import org.tron.common.utils.Sha256Hash;
import org.tron.consensus.pbft.message.PbftBaseMessage;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.config.args.Args;
import org.tron.core.metrics.MetricsUtil;
import org.tron.core.net.TronNetDelegate;
import org.tron.core.net.message.adv.InventoryMessage;
import org.tron.core.net.message.adv.TransactionsMessage;
import org.tron.core.net.message.base.DisconnectMessage;
import org.tron.core.net.message.handshake.HelloMessage;
import org.tron.core.net.message.keepalive.PingMessage;
import org.tron.core.net.message.keepalive.PongMessage;
import org.tron.core.net.peer.Item;
import org.tron.core.net.peer.TronState;
import org.tron.core.net.service.adv.AdvService;
import org.tron.core.net.service.statistics.NodeStatistics;
import org.tron.core.net.service.statistics.PeerStatistics;
import org.tron.core.net.service.statistics.TronStatsManager;
import org.tron.core.net.service.sync.SyncService;
import org.tron.p2p.connection.Channel;
import org.tron.protos.Protocol;

@Component
@Scope(value="prototype")
public class PeerConnection {
    private static final Logger logger = LoggerFactory.getLogger((String)"net");
    private static List<InetSocketAddress> relayNodes = Args.getInstance().getFastForwardNodes();
    private PeerStatistics peerStatistics = new PeerStatistics();
    private NodeStatistics nodeStatistics;
    private Channel channel;
    private volatile boolean isRelayPeer;
    private volatile boolean fetchAble;
    private ByteString address;
    private TronState tronState = TronState.INIT;
    @Autowired
    private TronNetDelegate tronNetDelegate;
    @Autowired
    private SyncService syncService;
    @Autowired
    private AdvService advService;
    private HelloMessage helloMessageReceive;
    private HelloMessage helloMessageSend;
    private int invCacheSize = 20000;
    private long BAD_PEER_BAN_TIME = 3600000L;
    private Cache<Item, Long> advInvReceive = CacheBuilder.newBuilder().maximumSize((long)this.invCacheSize).expireAfterWrite(1L, TimeUnit.HOURS).recordStats().build();
    private Cache<Item, Long> advInvSpread = CacheBuilder.newBuilder().maximumSize((long)this.invCacheSize).expireAfterWrite(1L, TimeUnit.HOURS).recordStats().build();
    private Map<Item, Long> advInvRequest = new ConcurrentHashMap<Item, Long>();
    private BlockCapsule.BlockId fastForwardBlock;
    private BlockCapsule.BlockId blockBothHave = new BlockCapsule.BlockId();
    private volatile long blockBothHaveUpdateTime = System.currentTimeMillis();
    private BlockCapsule.BlockId lastSyncBlockId;
    private volatile long remainNum;
    private Cache<Sha256Hash, Long> syncBlockIdCache = CacheBuilder.newBuilder().maximumSize(4000L).recordStats().build();
    private Deque<BlockCapsule.BlockId> syncBlockToFetch = new ConcurrentLinkedDeque<BlockCapsule.BlockId>();
    private Map<BlockCapsule.BlockId, Long> syncBlockRequested = new ConcurrentHashMap<BlockCapsule.BlockId, Long>();
    private Pair<Deque<BlockCapsule.BlockId>, Long> syncChainRequested = null;
    private Set<BlockCapsule.BlockId> syncBlockInProcess = new HashSet<BlockCapsule.BlockId>();
    private volatile boolean needSyncFromPeer = true;
    private volatile boolean needSyncFromUs = true;

    public void setChannel(Channel channel) {
        this.channel = channel;
        if (relayNodes.stream().anyMatch(n -> n.getAddress().equals(channel.getInetAddress()))) {
            this.isRelayPeer = true;
        }
        this.nodeStatistics = TronStatsManager.getNodeStatistics(channel.getInetAddress());
    }

    public void setBlockBothHave(BlockCapsule.BlockId blockId) {
        this.blockBothHave = blockId;
        this.blockBothHaveUpdateTime = System.currentTimeMillis();
    }

    public boolean isIdle() {
        return this.advInvRequest.isEmpty() && this.syncBlockRequested.isEmpty() && this.syncChainRequested == null;
    }

    public void sendMessage(Message message) {
        if (PeerConnection.needToLog(message)) {
            logger.info("Send peer {} message {}", (Object)this.channel.getInetSocketAddress(), (Object)message);
        }
        this.channel.send(message.getSendBytes());
        this.peerStatistics.messageStatistics.addTcpOutMessage(message);
    }

    public void onConnect() {
        long headBlockNum = this.helloMessageSend.getHeadBlockId().getNum();
        long peerHeadBlockNum = this.helloMessageReceive.getHeadBlockId().getNum();
        if (peerHeadBlockNum > headBlockNum) {
            this.needSyncFromUs = false;
            this.syncService.startSync(this);
        } else {
            this.needSyncFromPeer = false;
            if (peerHeadBlockNum == headBlockNum) {
                this.needSyncFromUs = false;
            }
            this.setTronState(TronState.SYNC_COMPLETED);
        }
    }

    public void onDisconnect() {
        this.syncService.onDisconnect(this);
        this.advService.onDisconnect(this);
        this.advInvReceive.cleanUp();
        this.advInvSpread.cleanUp();
        this.advInvRequest.clear();
        this.syncBlockIdCache.cleanUp();
        this.syncBlockToFetch.clear();
        this.syncBlockRequested.clear();
        this.syncBlockInProcess.clear();
        this.syncBlockInProcess.clear();
    }

    public String log() {
        long now = System.currentTimeMillis();
        BlockCapsule.BlockId syncBlockId = this.syncBlockToFetch.peek();
        Pair<Deque<BlockCapsule.BlockId>, Long> requested = this.syncChainRequested;
        return String.format("Peer %s\nconnect time: %ds [%sms]\nlast know block num: %s\nneedSyncFromPeer:%b\nneedSyncFromUs:%b\nsyncToFetchSize:%d\nsyncToFetchSizePeekNum:%d\nsyncBlockRequestedSize:%d\nremainNum:%d\nsyncChainRequested:%d\nblockInProcess:%d\n", this.channel.getInetSocketAddress(), (now - this.channel.getStartTime()) / 1000L, this.channel.getAvgLatency(), this.fastForwardBlock != null ? this.fastForwardBlock.getNum() : this.blockBothHave.getNum(), this.isNeedSyncFromPeer(), this.isNeedSyncFromUs(), this.syncBlockToFetch.size(), syncBlockId != null ? syncBlockId.getNum() : -1L, this.syncBlockRequested.size(), this.remainNum, requested == null ? 0L : (now - (Long)requested.getValue()) / 1000L, this.syncBlockInProcess.size());
    }

    public boolean isSyncFinish() {
        return !this.needSyncFromPeer && !this.needSyncFromUs;
    }

    public void disconnect(Protocol.ReasonCode code2) {
        this.sendMessage(new DisconnectMessage(code2));
        this.processDisconnect(code2);
        this.nodeStatistics.nodeDisconnectedLocal(code2);
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.channel.getInetSocketAddress();
    }

    public InetAddress getInetAddress() {
        return this.channel.getInetAddress();
    }

    public boolean isDisconnect() {
        return this.channel.isDisconnect();
    }

    private void processDisconnect(Protocol.ReasonCode reason) {
        InetAddress inetAddress = this.channel.getInetAddress();
        if (inetAddress == null) {
            return;
        }
        switch (reason) {
            case BAD_PROTOCOL: 
            case BAD_BLOCK: 
            case BAD_TX: {
                this.channel.close(this.BAD_PEER_BAN_TIME);
                break;
            }
            default: {
                this.channel.close();
            }
        }
        MetricsUtil.counterInc("net.disconnectionCount");
        MetricsUtil.counterInc("net.disconnectionDetail." + reason);
        Metrics.counterInc((String)"tron:p2p_disconnect", (double)1.0, (String[])new String[]{reason.name().toLowerCase(Locale.ROOT)});
    }

    public static boolean needToLog(Message msg) {
        if (msg instanceof PingMessage || msg instanceof PongMessage || msg instanceof TransactionsMessage || msg instanceof PbftBaseMessage) {
            return false;
        }
        return !(msg instanceof InventoryMessage) || !((InventoryMessage)msg).getInventoryType().equals((Object)Protocol.Inventory.InventoryType.TRX);
    }

    public synchronized boolean checkAndPutAdvInvRequest(Item key, Long value) {
        if (this.advInvRequest.containsKey(key)) {
            return false;
        }
        this.advInvRequest.put(key, value);
        return true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PeerConnection)) {
            return false;
        }
        return this.channel.equals((Object)((PeerConnection)o).getChannel());
    }

    public int hashCode() {
        return this.channel.hashCode();
    }

    public PeerStatistics getPeerStatistics() {
        return this.peerStatistics;
    }

    public NodeStatistics getNodeStatistics() {
        return this.nodeStatistics;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public boolean isRelayPeer() {
        return this.isRelayPeer;
    }

    public void setRelayPeer(boolean isRelayPeer) {
        this.isRelayPeer = isRelayPeer;
    }

    public void setFetchAble(boolean fetchAble) {
        this.fetchAble = fetchAble;
    }

    public boolean isFetchAble() {
        return this.fetchAble;
    }

    public ByteString getAddress() {
        return this.address;
    }

    public void setAddress(ByteString address) {
        this.address = address;
    }

    public TronState getTronState() {
        return this.tronState;
    }

    public void setTronState(TronState tronState) {
        this.tronState = tronState;
    }

    public void setHelloMessageReceive(HelloMessage helloMessageReceive) {
        this.helloMessageReceive = helloMessageReceive;
    }

    public HelloMessage getHelloMessageReceive() {
        return this.helloMessageReceive;
    }

    public void setHelloMessageSend(HelloMessage helloMessageSend) {
        this.helloMessageSend = helloMessageSend;
    }

    public HelloMessage getHelloMessageSend() {
        return this.helloMessageSend;
    }

    public void setAdvInvReceive(Cache<Item, Long> advInvReceive) {
        this.advInvReceive = advInvReceive;
    }

    public Cache<Item, Long> getAdvInvReceive() {
        return this.advInvReceive;
    }

    public void setAdvInvSpread(Cache<Item, Long> advInvSpread) {
        this.advInvSpread = advInvSpread;
    }

    public Cache<Item, Long> getAdvInvSpread() {
        return this.advInvSpread;
    }

    public void setAdvInvRequest(Map<Item, Long> advInvRequest) {
        this.advInvRequest = advInvRequest;
    }

    public Map<Item, Long> getAdvInvRequest() {
        return this.advInvRequest;
    }

    public void setFastForwardBlock(BlockCapsule.BlockId fastForwardBlock) {
        this.fastForwardBlock = fastForwardBlock;
    }

    public BlockCapsule.BlockId getBlockBothHave() {
        return this.blockBothHave;
    }

    public long getBlockBothHaveUpdateTime() {
        return this.blockBothHaveUpdateTime;
    }

    public void setLastSyncBlockId(BlockCapsule.BlockId lastSyncBlockId) {
        this.lastSyncBlockId = lastSyncBlockId;
    }

    public BlockCapsule.BlockId getLastSyncBlockId() {
        return this.lastSyncBlockId;
    }

    public void setRemainNum(long remainNum) {
        this.remainNum = remainNum;
    }

    public long getRemainNum() {
        return this.remainNum;
    }

    public Cache<Sha256Hash, Long> getSyncBlockIdCache() {
        return this.syncBlockIdCache;
    }

    public void setSyncBlockToFetch(Deque<BlockCapsule.BlockId> syncBlockToFetch) {
        this.syncBlockToFetch = syncBlockToFetch;
    }

    public Deque<BlockCapsule.BlockId> getSyncBlockToFetch() {
        return this.syncBlockToFetch;
    }

    public void setSyncBlockRequested(Map<BlockCapsule.BlockId, Long> syncBlockRequested) {
        this.syncBlockRequested = syncBlockRequested;
    }

    public Map<BlockCapsule.BlockId, Long> getSyncBlockRequested() {
        return this.syncBlockRequested;
    }

    public void setSyncChainRequested(Pair<Deque<BlockCapsule.BlockId>, Long> syncChainRequested) {
        this.syncChainRequested = syncChainRequested;
    }

    public Pair<Deque<BlockCapsule.BlockId>, Long> getSyncChainRequested() {
        return this.syncChainRequested;
    }

    public void setSyncBlockInProcess(Set<BlockCapsule.BlockId> syncBlockInProcess) {
        this.syncBlockInProcess = syncBlockInProcess;
    }

    public Set<BlockCapsule.BlockId> getSyncBlockInProcess() {
        return this.syncBlockInProcess;
    }

    public void setNeedSyncFromPeer(boolean needSyncFromPeer) {
        this.needSyncFromPeer = needSyncFromPeer;
    }

    public boolean isNeedSyncFromPeer() {
        return this.needSyncFromPeer;
    }

    public void setNeedSyncFromUs(boolean needSyncFromUs) {
        this.needSyncFromUs = needSyncFromUs;
    }

    public boolean isNeedSyncFromUs() {
        return this.needSyncFromUs;
    }
}

