/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.messagehandler;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.exception.P2pException;
import org.tron.core.net.TronNetDelegate;
import org.tron.core.net.message.TronMessage;
import org.tron.core.net.message.sync.ChainInventoryMessage;
import org.tron.core.net.message.sync.SyncBlockChainMessage;
import org.tron.core.net.messagehandler.TronMsgHandler;
import org.tron.core.net.peer.PeerConnection;
import org.tron.protos.Protocol;

@Component
public class SyncBlockChainMsgHandler
implements TronMsgHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"net");
    @Autowired
    private TronNetDelegate tronNetDelegate;

    @Override
    public void processMessage(PeerConnection peer, TronMessage msg) throws P2pException {
        SyncBlockChainMessage syncBlockChainMessage = (SyncBlockChainMessage)msg;
        if (!this.check(peer, syncBlockChainMessage)) {
            peer.disconnect(Protocol.ReasonCode.BAD_PROTOCOL);
            return;
        }
        long remainNum = 0L;
        List<BlockCapsule.BlockId> summaryChainIds = syncBlockChainMessage.getBlockIds();
        LinkedList<BlockCapsule.BlockId> blockIds = this.getLostBlockIds(summaryChainIds);
        if (blockIds.size() == 0) {
            logger.warn("Can't get lost block Ids");
            peer.disconnect(Protocol.ReasonCode.INCOMPATIBLE_CHAIN);
            return;
        }
        if (blockIds.size() == 1) {
            peer.setNeedSyncFromUs(false);
        } else {
            peer.setNeedSyncFromUs(true);
            remainNum = this.tronNetDelegate.getHeadBlockId().getNum() - blockIds.peekLast().getNum();
        }
        peer.setLastSyncBlockId(blockIds.peekLast());
        peer.setRemainNum(remainNum);
        peer.sendMessage(new ChainInventoryMessage(blockIds, remainNum));
    }

    private boolean check(PeerConnection peer, SyncBlockChainMessage msg) throws P2pException {
        List<BlockCapsule.BlockId> blockIds = msg.getBlockIds();
        if (CollectionUtils.isEmpty(blockIds)) {
            throw new P2pException(P2pException.TypeEnum.BAD_MESSAGE, "SyncBlockChain blockIds is empty");
        }
        BlockCapsule.BlockId firstId = blockIds.get(0);
        if (!this.tronNetDelegate.containBlockInMainChain(firstId)) {
            logger.warn("Sync message from peer {} without the first block: {}", (Object)peer.getInetSocketAddress(), (Object)firstId.getString());
            return false;
        }
        long headNum = this.tronNetDelegate.getHeadBlockId().getNum();
        if (firstId.getNum() > headNum) {
            throw new P2pException(P2pException.TypeEnum.BAD_MESSAGE, "First blockNum:" + firstId.getNum() + " gt my head BlockNum:" + headNum);
        }
        BlockCapsule.BlockId lastSyncBlockId = peer.getLastSyncBlockId();
        long lastNum = blockIds.get(blockIds.size() - 1).getNum();
        if (lastSyncBlockId != null && lastSyncBlockId.getNum() > lastNum) {
            throw new P2pException(P2pException.TypeEnum.BAD_MESSAGE, "lastSyncNum:" + lastSyncBlockId.getNum() + " gt lastNum:" + lastNum);
        }
        return true;
    }

    private LinkedList<BlockCapsule.BlockId> getLostBlockIds(List<BlockCapsule.BlockId> blockIds) throws P2pException {
        BlockCapsule.BlockId unForkId = null;
        for (int i = blockIds.size() - 1; i >= 0; --i) {
            if (!this.tronNetDelegate.containBlockInMainChain(blockIds.get(i))) continue;
            unForkId = blockIds.get(i);
            break;
        }
        if (unForkId == null) {
            throw new P2pException(P2pException.TypeEnum.SYNC_FAILED, "unForkId is null");
        }
        BlockCapsule.BlockId headID = this.tronNetDelegate.getHeadBlockId();
        long headNum = headID.getNum();
        long len = Math.min(headNum, unForkId.getNum() + 2000L);
        LinkedList<BlockCapsule.BlockId> ids = new LinkedList<BlockCapsule.BlockId>();
        for (long i = unForkId.getNum(); i <= len; ++i) {
            if (i == headNum) {
                ids.add(headID);
                continue;
            }
            BlockCapsule.BlockId id = this.tronNetDelegate.getBlockIdByNum(i);
            ids.add(id);
        }
        return ids;
    }
}

