/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.messagehandler;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.Striped;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.overlay.message.Message;
import org.tron.consensus.base.Param;
import org.tron.consensus.pbft.PbftManager;
import org.tron.consensus.pbft.message.PbftBaseMessage;
import org.tron.consensus.pbft.message.PbftMessage;
import org.tron.core.exception.P2pException;
import org.tron.core.net.TronNetService;
import org.tron.core.net.peer.PeerConnection;

@Component
public class PbftMsgHandler {
    private static final Striped<Lock> striped = Striped.lazyWeakLock((int)1024);
    private static final Cache<String, Boolean> msgCache = CacheBuilder.newBuilder().initialCapacity(3000).maximumSize(10000L).expireAfterWrite(10L, TimeUnit.MINUTES).build();
    @Autowired
    private PbftManager pbftManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessage(PeerConnection peer, PbftMessage msg) throws Exception {
        if (Param.getInstance().getPbftInterface().isSyncing()) {
            return;
        }
        msg.analyzeSignature();
        String key = this.buildKey((PbftBaseMessage)msg);
        Lock lock = (Lock)striped.get((Object)key);
        try {
            lock.lock();
            if (msgCache.getIfPresent((Object)key) != null) {
                return;
            }
            if (!this.pbftManager.verifyMsg((PbftBaseMessage)msg)) {
                throw new P2pException(P2pException.TypeEnum.BAD_MESSAGE, msg.toString());
            }
            msgCache.put((Object)key, (Object)true);
            this.forwardMessage(peer, (PbftBaseMessage)msg);
            this.pbftManager.doAction(msg);
        }
        finally {
            lock.unlock();
        }
    }

    public void forwardMessage(PeerConnection peer, PbftBaseMessage message) {
        TronNetService.getPeers().stream().filter(peerConnection -> !peerConnection.equals(peer)).forEach(peerConnection -> peerConnection.sendMessage((Message)message));
    }

    private String buildKey(PbftBaseMessage msg) {
        return msg.getKey() + msg.getPbftMessage().getRawData().getMsgType().toString();
    }
}

