/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.messagehandler;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.config.args.Args;
import org.tron.core.net.TronNetDelegate;
import org.tron.core.net.message.TronMessage;
import org.tron.core.net.message.adv.InventoryMessage;
import org.tron.core.net.messagehandler.TransactionsMsgHandler;
import org.tron.core.net.messagehandler.TronMsgHandler;
import org.tron.core.net.peer.Item;
import org.tron.core.net.peer.PeerConnection;
import org.tron.core.net.service.adv.AdvService;
import org.tron.protos.Protocol;

@Component
public class InventoryMsgHandler
implements TronMsgHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"net");
    @Autowired
    private TronNetDelegate tronNetDelegate;
    @Autowired
    private AdvService advService;
    @Autowired
    private TransactionsMsgHandler transactionsMsgHandler;

    @Override
    public void processMessage(PeerConnection peer, TronMessage msg) {
        InventoryMessage inventoryMessage = (InventoryMessage)msg;
        Protocol.Inventory.InventoryType type = inventoryMessage.getInventoryType();
        if (!this.check(peer, inventoryMessage)) {
            return;
        }
        for (Sha256Hash id : inventoryMessage.getHashList()) {
            Item item = new Item(id, type);
            peer.getAdvInvReceive().put((Object)item, (Object)System.currentTimeMillis());
            this.advService.addInv(item);
        }
    }

    private boolean check(PeerConnection peer, InventoryMessage inventoryMessage) {
        Protocol.Inventory.InventoryType type = inventoryMessage.getInventoryType();
        int size = inventoryMessage.getHashList().size();
        if (peer.isNeedSyncFromPeer() || peer.isNeedSyncFromUs()) {
            logger.warn("Drop inv: {} size: {} from Peer {}, syncFromUs: {}, syncFromPeer: {}", new Object[]{type, size, peer.getInetAddress(), peer.isNeedSyncFromUs(), peer.isNeedSyncFromPeer()});
            return false;
        }
        if (type.equals((Object)Protocol.Inventory.InventoryType.TRX) && this.transactionsMsgHandler.isBusy()) {
            logger.warn("Drop inv: {} size: {} from Peer {}, transactionsMsgHandler is busy", new Object[]{type, size, peer.getInetAddress()});
            if (Args.getInstance().isOpenPrintLog()) {
                logger.warn("[isBusy]Drop tx list is: {}", inventoryMessage.getHashList());
            }
            return false;
        }
        return true;
    }
}

