/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.messagehandler;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.overlay.message.Message;
import org.tron.common.utils.Sha256Hash;
import org.tron.consensus.ConsensusDelegate;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.PbftSignCapsule;
import org.tron.core.exception.P2pException;
import org.tron.core.net.TronNetDelegate;
import org.tron.core.net.message.MessageTypes;
import org.tron.core.net.message.TronMessage;
import org.tron.core.net.message.adv.BlockMessage;
import org.tron.core.net.message.adv.FetchInvDataMessage;
import org.tron.core.net.message.adv.TransactionMessage;
import org.tron.core.net.message.adv.TransactionsMessage;
import org.tron.core.net.message.pbft.PbftCommitMessage;
import org.tron.core.net.messagehandler.TronMsgHandler;
import org.tron.core.net.peer.Item;
import org.tron.core.net.peer.PeerConnection;
import org.tron.core.net.service.adv.AdvService;
import org.tron.core.net.service.sync.SyncService;
import org.tron.protos.Protocol;

@Component
public class FetchInvDataMsgHandler
implements TronMsgHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"net");
    private volatile Cache<Long, Boolean> epochCache = CacheBuilder.newBuilder().initialCapacity(100).maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS).build();
    private static final int MAX_SIZE = 1000000;
    @Autowired
    private TronNetDelegate tronNetDelegate;
    @Autowired
    private SyncService syncService;
    @Autowired
    private AdvService advService;
    @Autowired
    private ConsensusDelegate consensusDelegate;

    @Override
    public void processMessage(PeerConnection peer, TronMessage msg) throws P2pException {
        FetchInvDataMessage fetchInvDataMsg = (FetchInvDataMessage)msg;
        this.check(peer, fetchInvDataMsg);
        Protocol.Inventory.InventoryType type = fetchInvDataMsg.getInventoryType();
        ArrayList transactions = Lists.newArrayList();
        int size = 0;
        for (Sha256Hash hash : fetchInvDataMsg.getHashList()) {
            Item item = new Item(hash, type);
            Message message = this.advService.getMessage(item);
            if (message == null) {
                try {
                    message = this.tronNetDelegate.getData(hash, type);
                }
                catch (Exception e) {
                    throw new P2pException(P2pException.TypeEnum.DB_ITEM_NOT_FOUND, "Fetch item " + item + " failed. reason: " + e.getMessage());
                }
            }
            if (type == Protocol.Inventory.InventoryType.BLOCK) {
                BlockCapsule.BlockId blockId = ((BlockMessage)message).getBlockCapsule().getBlockId();
                if (peer.getBlockBothHave().getNum() < blockId.getNum()) {
                    peer.setBlockBothHave(blockId);
                }
                this.sendPbftCommitMessage(peer, ((BlockMessage)message).getBlockCapsule());
                peer.sendMessage(message);
                continue;
            }
            transactions.add(((TransactionMessage)message).getTransactionCapsule().getInstance());
            if ((size += ((TransactionMessage)message).getTransactionCapsule().getInstance().getSerializedSize()) <= 1000000) continue;
            peer.sendMessage(new TransactionsMessage(transactions));
            transactions = Lists.newArrayList();
            size = 0;
        }
        if (!transactions.isEmpty()) {
            peer.sendMessage(new TransactionsMessage(transactions));
        }
    }

    private void sendPbftCommitMessage(PeerConnection peer, BlockCapsule blockCapsule) {
        try {
            PbftSignCapsule srl;
            if (!this.tronNetDelegate.allowPBFT() || peer.isSyncFinish()) {
                return;
            }
            long epoch = 0L;
            PbftSignCapsule pbftSignCapsule = this.tronNetDelegate.getBlockPbftCommitData(blockCapsule.getNum());
            long maintenanceTimeInterval = this.consensusDelegate.getDynamicPropertiesStore().getMaintenanceTimeInterval();
            if (pbftSignCapsule != null) {
                Protocol.PBFTMessage.Raw raw2 = Protocol.PBFTMessage.Raw.parseFrom((ByteString)pbftSignCapsule.getPbftCommitResult().getData());
                epoch = raw2.getEpoch();
                peer.sendMessage(new PbftCommitMessage(pbftSignCapsule));
            } else {
                epoch = (blockCapsule.getTimeStamp() / maintenanceTimeInterval + 1L) * maintenanceTimeInterval;
            }
            if (this.epochCache.getIfPresent((Object)epoch) == null && (srl = this.tronNetDelegate.getSRLPbftCommitData(epoch)) != null) {
                this.epochCache.put((Object)epoch, (Object)true);
                peer.sendMessage(new PbftCommitMessage(srl));
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    private void check(PeerConnection peer, FetchInvDataMessage fetchInvDataMsg) throws P2pException {
        MessageTypes type = fetchInvDataMsg.getInvMessageType();
        if (type == MessageTypes.TRX) {
            int maxCount;
            for (Sha256Hash hash : fetchInvDataMsg.getHashList()) {
                if (peer.getAdvInvSpread().getIfPresent((Object)new Item(hash, Protocol.Inventory.InventoryType.TRX)) != null) continue;
                throw new P2pException(P2pException.TypeEnum.BAD_MESSAGE, "not spread inv: " + hash);
            }
            int fetchCount = peer.getPeerStatistics().messageStatistics.tronInTrxFetchInvDataElement.getCount(10);
            if (fetchCount > (maxCount = this.advService.getTrxCount().getCount(60))) {
                logger.warn("Peer fetch too more transactions in 10 seconds, maxCount: {}, fetchCount: {}, peer: {}", new Object[]{maxCount, fetchCount, peer.getInetAddress()});
            }
        } else {
            boolean isAdv = true;
            for (Sha256Hash hash : fetchInvDataMsg.getHashList()) {
                if (peer.getAdvInvSpread().getIfPresent((Object)new Item(hash, Protocol.Inventory.InventoryType.BLOCK)) != null) continue;
                isAdv = false;
                break;
            }
            if (!isAdv) {
                if (!peer.isNeedSyncFromUs()) {
                    throw new P2pException(P2pException.TypeEnum.BAD_MESSAGE, "no need sync");
                }
                for (Sha256Hash hash : fetchInvDataMsg.getHashList()) {
                    long minBlockNum;
                    long blockNum = new BlockCapsule.BlockId(hash).getNum();
                    if (blockNum < (minBlockNum = peer.getLastSyncBlockId().getNum() - 4000L)) {
                        throw new P2pException(P2pException.TypeEnum.BAD_MESSAGE, "minBlockNum: " + minBlockNum + ", blockNum: " + blockNum);
                    }
                    if (peer.getSyncBlockIdCache().getIfPresent((Object)hash) != null) {
                        throw new P2pException(P2pException.TypeEnum.BAD_MESSAGE, new BlockCapsule.BlockId(hash).getString() + " is exist");
                    }
                    peer.getSyncBlockIdCache().put((Object)hash, (Object)System.currentTimeMillis());
                }
            }
        }
    }
}

