/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.messagehandler;

import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.config.args.Args;
import org.tron.core.exception.P2pException;
import org.tron.core.net.TronNetDelegate;
import org.tron.core.net.message.TronMessage;
import org.tron.core.net.message.sync.ChainInventoryMessage;
import org.tron.core.net.messagehandler.TronMsgHandler;
import org.tron.core.net.peer.PeerConnection;
import org.tron.core.net.peer.TronState;
import org.tron.core.net.service.sync.SyncService;

@Component
public class ChainInventoryMsgHandler
implements TronMsgHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"net");
    @Autowired
    private TronNetDelegate tronNetDelegate;
    @Autowired
    private SyncService syncService;
    private final long syncFetchBatchNum = Args.getInstance().getSyncFetchBatchNum();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processMessage(PeerConnection peer, TronMessage msg) throws P2pException {
        ChainInventoryMessage chainInventoryMessage = (ChainInventoryMessage)msg;
        this.check(peer, chainInventoryMessage);
        peer.setFetchAble(false);
        peer.setNeedSyncFromPeer(true);
        peer.setSyncChainRequested(null);
        LinkedList<BlockCapsule.BlockId> blockIdWeGet = new LinkedList<BlockCapsule.BlockId>(chainInventoryMessage.getBlockIds());
        if (blockIdWeGet.size() == 1 && this.tronNetDelegate.containBlock((BlockCapsule.BlockId)blockIdWeGet.peek())) {
            peer.setTronState(TronState.SYNC_COMPLETED);
            peer.setNeedSyncFromPeer(false);
            return;
        }
        while (!peer.getSyncBlockToFetch().isEmpty() && !peer.getSyncBlockToFetch().peekLast().equals(blockIdWeGet.peekFirst())) {
            peer.getSyncBlockToFetch().pollLast();
        }
        blockIdWeGet.poll();
        peer.setRemainNum(chainInventoryMessage.getRemainNum());
        peer.getSyncBlockToFetch().addAll(blockIdWeGet);
        Object object = this.tronNetDelegate.getBlockLock();
        synchronized (object) {
            try {
                BlockCapsule.BlockId blockId = null;
                while (!peer.getSyncBlockToFetch().isEmpty() && this.tronNetDelegate.containBlock(peer.getSyncBlockToFetch().peek())) {
                    blockId = peer.getSyncBlockToFetch().pop();
                    peer.setBlockBothHave(blockId);
                }
                if (blockId != null) {
                    logger.info("Block {} from {} is processed", (Object)blockId.getString(), (Object)peer.getInetAddress());
                }
            }
            catch (NoSuchElementException e) {
                logger.warn("Process ChainInventoryMessage failed, peer {}, isDisconnect:{}", (Object)peer.getInetAddress(), (Object)peer.isDisconnect());
                peer.setFetchAble(true);
                return;
            }
        }
        peer.setFetchAble(true);
        if (chainInventoryMessage.getRemainNum() == 0L && !peer.getSyncBlockToFetch().isEmpty() || chainInventoryMessage.getRemainNum() != 0L && (long)peer.getSyncBlockToFetch().size() > this.syncFetchBatchNum) {
            this.syncService.setFetchFlag(true);
        } else {
            this.syncService.syncNext(peer);
        }
    }

    private void check(PeerConnection peer, ChainInventoryMessage msg) throws P2pException {
        if (peer.getSyncChainRequested() == null) {
            throw new P2pException(P2pException.TypeEnum.BAD_MESSAGE, "not send syncBlockChainMsg");
        }
        List<BlockCapsule.BlockId> blockIds = msg.getBlockIds();
        if (CollectionUtils.isEmpty(blockIds)) {
            throw new P2pException(P2pException.TypeEnum.BAD_MESSAGE, "blockIds is empty");
        }
        if ((long)blockIds.size() > 2001L) {
            throw new P2pException(P2pException.TypeEnum.BAD_MESSAGE, "big blockIds size: " + blockIds.size());
        }
        if (msg.getRemainNum() != 0L && (long)blockIds.size() < 2000L) {
            throw new P2pException(P2pException.TypeEnum.BAD_MESSAGE, "remain: " + msg.getRemainNum() + ", blockIds size: " + blockIds.size());
        }
        long num = blockIds.get(0).getNum();
        for (BlockCapsule.BlockId id : msg.getBlockIds()) {
            if (id.getNum() == num++) continue;
            throw new P2pException(P2pException.TypeEnum.BAD_MESSAGE, "not continuous block");
        }
        if (!((Deque)peer.getSyncChainRequested().getKey()).contains(blockIds.get(0))) {
            throw new P2pException(P2pException.TypeEnum.BAD_MESSAGE, "unlinked block, my head: " + ((BlockCapsule.BlockId)((Deque)peer.getSyncChainRequested().getKey()).getLast()).getString() + ", peer: " + blockIds.get(0).getString());
        }
        if (this.tronNetDelegate.getHeadBlockId().getNum() > 0L) {
            long maxRemainTime = 3600000L + System.currentTimeMillis() - this.tronNetDelegate.getBlockTime(this.tronNetDelegate.getSolidBlockId());
            long maxFutureNum = maxRemainTime / 3000L + this.tronNetDelegate.getSolidBlockId().getNum();
            long lastNum = blockIds.get(blockIds.size() - 1).getNum();
            if (lastNum + msg.getRemainNum() > maxFutureNum) {
                throw new P2pException(P2pException.TypeEnum.BAD_MESSAGE, "lastNum: " + lastNum + " + remainNum: " + msg.getRemainNum() + " > futureMaxNum: " + maxFutureNum);
            }
        }
    }
}

