/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.messagehandler;

import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.prometheus.Metrics;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.config.args.Args;
import org.tron.core.exception.P2pException;
import org.tron.core.metrics.MetricsUtil;
import org.tron.core.net.TronNetDelegate;
import org.tron.core.net.message.TronMessage;
import org.tron.core.net.message.adv.BlockMessage;
import org.tron.core.net.messagehandler.TronMsgHandler;
import org.tron.core.net.peer.Item;
import org.tron.core.net.peer.PeerConnection;
import org.tron.core.net.service.adv.AdvService;
import org.tron.core.net.service.fetchblock.FetchBlockService;
import org.tron.core.net.service.relay.RelayService;
import org.tron.core.net.service.sync.SyncService;
import org.tron.core.services.WitnessProductBlockService;
import org.tron.protos.Protocol;

@Component
public class BlockMsgHandler
implements TronMsgHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"net");
    @Autowired
    private RelayService relayService;
    @Autowired
    private TronNetDelegate tronNetDelegate;
    @Autowired
    private AdvService advService;
    @Autowired
    private SyncService syncService;
    @Autowired
    private FetchBlockService fetchBlockService;
    @Autowired
    private WitnessProductBlockService witnessProductBlockService;
    private int maxBlockSize = 2001000;
    private boolean fastForward = Args.getInstance().isFastForward();

    @Override
    public void processMessage(PeerConnection peer, TronMessage msg) throws P2pException {
        BlockMessage blockMessage = (BlockMessage)msg;
        BlockCapsule.BlockId blockId = blockMessage.getBlockId();
        if (!this.fastForward && !peer.isRelayPeer()) {
            this.check(peer, blockMessage);
        }
        if (peer.getSyncBlockRequested().containsKey(blockId)) {
            peer.getSyncBlockRequested().remove(blockId);
            peer.getSyncBlockInProcess().add(blockId);
            this.syncService.processBlock(peer, blockMessage);
        } else {
            Long time;
            Item item = new Item((Sha256Hash)blockId, Protocol.Inventory.InventoryType.BLOCK);
            long now = System.currentTimeMillis();
            if (peer.isRelayPeer()) {
                peer.getAdvInvSpread().put((Object)item, (Object)now);
            }
            if (null != (time = peer.getAdvInvRequest().remove(item))) {
                MetricsUtil.histogramUpdateUnCheck("net.latency.fetch.block." + peer.getInetAddress(), now - time);
                Metrics.histogramObserve((String)"tron:block_fetch_latency_seconds", (double)((double)(now - time) / 1000.0), (String[])new String[0]);
            }
            Metrics.histogramObserve((String)"tron:block_receive_delay_seconds", (double)((double)(now - blockMessage.getBlockCapsule().getTimeStamp()) / 1000.0), (String[])new String[0]);
            this.fetchBlockService.blockFetchSuccess((Sha256Hash)blockId);
            long interval = blockId.getNum() - this.tronNetDelegate.getHeadBlockId().getNum();
            this.processBlock(peer, blockMessage.getBlockCapsule());
            logger.info("Receive block/interval {}/{} from {} fetch/delay {}/{}ms, txs/process {}/{}ms, witness: {}", new Object[]{blockId.getNum(), interval, peer.getInetSocketAddress(), time == null ? 0L : now - time, now - blockMessage.getBlockCapsule().getTimeStamp(), ((BlockMessage)msg).getBlockCapsule().getTransactions().size(), System.currentTimeMillis() - now, Hex.toHexString((byte[])blockMessage.getBlockCapsule().getWitnessAddress().toByteArray())});
        }
    }

    private void check(PeerConnection peer, BlockMessage msg) throws P2pException {
        Item item = new Item((Sha256Hash)msg.getBlockId(), Protocol.Inventory.InventoryType.BLOCK);
        if (!peer.getSyncBlockRequested().containsKey(msg.getBlockId()) && !peer.getAdvInvRequest().containsKey(item)) {
            logger.error("Receive bad block {} from peer {}, with no request", (Object)msg.getBlockId(), (Object)peer.getInetSocketAddress());
            throw new P2pException(P2pException.TypeEnum.BAD_MESSAGE, "no request");
        }
        BlockCapsule blockCapsule = msg.getBlockCapsule();
        if (blockCapsule.getInstance().getSerializedSize() > this.maxBlockSize) {
            logger.error("Receive bad block {} from peer {}, block size over limit", (Object)msg.getBlockId(), (Object)peer.getInetSocketAddress());
            throw new P2pException(P2pException.TypeEnum.BAD_MESSAGE, "block size over limit");
        }
        long gap = blockCapsule.getTimeStamp() - System.currentTimeMillis();
        if (gap >= 3000L) {
            logger.error("Receive bad block {} from peer {}, block time error", (Object)msg.getBlockId(), (Object)peer.getInetSocketAddress());
            throw new P2pException(P2pException.TypeEnum.BAD_MESSAGE, "block time error");
        }
    }

    private void processBlock(PeerConnection peer, BlockCapsule block) throws P2pException {
        BlockCapsule.BlockId blockId = block.getBlockId();
        if (!this.tronNetDelegate.containBlock(block.getParentBlockId())) {
            logger.warn("Get unlink block {} from {}, head is {}", new Object[]{blockId.getString(), peer.getInetAddress(), this.tronNetDelegate.getHeadBlockId().getString()});
            this.syncService.startSync(peer);
            return;
        }
        long headNum = this.tronNetDelegate.getHeadBlockId().getNum();
        if (block.getNum() < headNum) {
            logger.warn("Receive a low block {}, head {}", (Object)blockId.getString(), (Object)headNum);
            return;
        }
        boolean flag = this.tronNetDelegate.validBlock(block);
        if (flag) {
            this.broadcast(new BlockMessage(block));
        }
        try {
            this.tronNetDelegate.processBlock(block, false);
            if (!flag) {
                this.broadcast(new BlockMessage(block));
            }
            this.witnessProductBlockService.validWitnessProductTwoBlock(block);
            this.tronNetDelegate.getActivePeer().forEach(p -> {
                if (p.getAdvInvReceive().getIfPresent((Object)blockId) != null) {
                    p.setBlockBothHave(blockId);
                }
            });
        }
        catch (Exception e) {
            logger.warn("Process adv block {} from peer {} failed. reason: {}", new Object[]{blockId, peer.getInetAddress(), e.getMessage()});
        }
    }

    private void broadcast(BlockMessage blockMessage) {
        if (this.fastForward) {
            this.relayService.broadcast(blockMessage);
        } else {
            this.advService.broadcast(blockMessage);
        }
    }
}

