/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.message.sync;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.net.message.MessageTypes;
import org.tron.core.net.message.TronMessage;
import org.tron.protos.Protocol;

public class ChainInventoryMessage
extends TronMessage {
    protected Protocol.ChainInventory chainInventory;

    public ChainInventoryMessage(byte[] data) throws Exception {
        super(data);
        this.type = MessageTypes.BLOCK_CHAIN_INVENTORY.asByte();
        this.chainInventory = Protocol.ChainInventory.parseFrom((byte[])data);
    }

    public ChainInventoryMessage(List<BlockCapsule.BlockId> blockIds, Long remainNum) {
        Protocol.ChainInventory.Builder invBuilder = Protocol.ChainInventory.newBuilder();
        blockIds.forEach(blockId -> {
            Protocol.ChainInventory.BlockId.Builder b = Protocol.ChainInventory.BlockId.newBuilder();
            b.setHash(blockId.getByteString());
            b.setNumber(blockId.getNum());
            invBuilder.addIds(b);
        });
        invBuilder.setRemainNum(remainNum.longValue());
        this.chainInventory = invBuilder.build();
        this.type = MessageTypes.BLOCK_CHAIN_INVENTORY.asByte();
        this.data = this.chainInventory.toByteArray();
    }

    public Class<?> getAnswerMessage() {
        return null;
    }

    private Protocol.ChainInventory getChainInventory() {
        return this.chainInventory;
    }

    public List<BlockCapsule.BlockId> getBlockIds() {
        try {
            return this.getChainInventory().getIdsList().stream().map(blockId -> new BlockCapsule.BlockId(blockId.getHash(), blockId.getNumber())).collect(Collectors.toCollection(ArrayList::new));
        }
        catch (Exception e) {
            logger.info("Failed to get blockIds of chain inventory message");
            return null;
        }
    }

    public Long getRemainNum() {
        return this.getChainInventory().getRemainNum();
    }

    public String toString() {
        LinkedList<BlockCapsule.BlockId> blockIdWeGet = new LinkedList<BlockCapsule.BlockId>(this.getBlockIds());
        StringBuilder sb = new StringBuilder(super.toString());
        int size = blockIdWeGet.size();
        sb.append("size: ").append(size);
        if (size >= 1) {
            sb.append(", first blockId: ").append(((BlockCapsule.BlockId)blockIdWeGet.peek()).getString());
            if (size > 1) {
                sb.append(", end blockId: ").append(((BlockCapsule.BlockId)blockIdWeGet.peekLast()).getString());
            }
        }
        return sb.toString();
    }
}

