/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.message.handshake;

import com.google.protobuf.ByteString;
import org.apache.commons.lang3.StringUtils;
import org.tron.common.utils.StringUtil;
import org.tron.core.ChainBaseManager;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.config.args.Args;
import org.tron.core.net.message.MessageTypes;
import org.tron.core.net.message.TronMessage;
import org.tron.p2p.discover.Node;
import org.tron.p2p.utils.ByteArray;
import org.tron.protos.Discover;
import org.tron.protos.Protocol;

public class HelloMessage
extends TronMessage {
    private Protocol.HelloMessage helloMessage;

    public HelloMessage(byte type, byte[] rawData) throws Exception {
        super(type, rawData);
        this.helloMessage = Protocol.HelloMessage.parseFrom((byte[])rawData);
    }

    public HelloMessage(byte[] data) throws Exception {
        super(MessageTypes.P2P_HELLO.asByte(), data);
        this.helloMessage = Protocol.HelloMessage.parseFrom((byte[])data);
    }

    public HelloMessage(Node from, long timestamp, ChainBaseManager chainBaseManager) {
        Discover.Endpoint fromEndpoint = HelloMessage.getEndpointFromNode(from);
        BlockCapsule.BlockId gid = chainBaseManager.getGenesisBlockId();
        Protocol.HelloMessage.BlockId gBlockId = Protocol.HelloMessage.BlockId.newBuilder().setHash(gid.getByteString()).setNumber(gid.getNum()).build();
        BlockCapsule.BlockId sid = chainBaseManager.getSolidBlockId();
        Protocol.HelloMessage.BlockId sBlockId = Protocol.HelloMessage.BlockId.newBuilder().setHash(sid.getByteString()).setNumber(sid.getNum()).build();
        BlockCapsule.BlockId hid = chainBaseManager.getHeadBlockId();
        Protocol.HelloMessage.BlockId hBlockId = Protocol.HelloMessage.BlockId.newBuilder().setHash(hid.getByteString()).setNumber(hid.getNum()).build();
        Protocol.HelloMessage.Builder builder = Protocol.HelloMessage.newBuilder();
        builder.setFrom(fromEndpoint);
        builder.setVersion(Args.getInstance().getNodeP2pVersion());
        builder.setTimestamp(timestamp);
        builder.setGenesisBlockId(gBlockId);
        builder.setSolidBlockId(sBlockId);
        builder.setHeadBlockId(hBlockId);
        builder.setNodeType(chainBaseManager.getNodeType().getType());
        builder.setLowestBlockNum(chainBaseManager.isLiteNode() ? chainBaseManager.getLowestBlockNum() : 0L);
        this.helloMessage = builder.build();
        this.type = MessageTypes.P2P_HELLO.asByte();
        this.data = this.helloMessage.toByteArray();
    }

    public void setHelloMessage(Protocol.HelloMessage helloMessage) {
        this.helloMessage = helloMessage;
        this.data = this.helloMessage.toByteArray();
    }

    public int getVersion() {
        return this.helloMessage.getVersion();
    }

    public int getNodeType() {
        return this.helloMessage.getNodeType();
    }

    public long getLowestBlockNum() {
        return this.helloMessage.getLowestBlockNum();
    }

    public long getTimestamp() {
        return this.helloMessage.getTimestamp();
    }

    public Node getFrom() {
        Discover.Endpoint from = this.helloMessage.getFrom();
        return new Node(from.getNodeId().toByteArray(), org.tron.common.utils.ByteArray.toStr((byte[])from.getAddress().toByteArray()), org.tron.common.utils.ByteArray.toStr((byte[])from.getAddressIpv6().toByteArray()), from.getPort());
    }

    public BlockCapsule.BlockId getGenesisBlockId() {
        return new BlockCapsule.BlockId(this.helloMessage.getGenesisBlockId().getHash(), this.helloMessage.getGenesisBlockId().getNumber());
    }

    public BlockCapsule.BlockId getSolidBlockId() {
        return new BlockCapsule.BlockId(this.helloMessage.getSolidBlockId().getHash(), this.helloMessage.getSolidBlockId().getNumber());
    }

    public BlockCapsule.BlockId getHeadBlockId() {
        return new BlockCapsule.BlockId(this.helloMessage.getHeadBlockId().getHash(), this.helloMessage.getHeadBlockId().getNumber());
    }

    public Class<?> getAnswerMessage() {
        return null;
    }

    public String toString() {
        ByteString signature;
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString()).append("from: ").append(this.getFrom().getPreferInetSocketAddress()).append("\n").append("timestamp: ").append(this.getTimestamp()).append("\n").append("headBlockId: ").append(this.getHeadBlockId().getString()).append("\n").append("nodeType: ").append(this.helloMessage.getNodeType()).append("\n").append("lowestBlockNum: ").append(this.helloMessage.getLowestBlockNum()).append("\n");
        ByteString address = this.helloMessage.getAddress();
        if (address != null && !address.isEmpty()) {
            builder.append("address:").append(StringUtil.encode58Check((byte[])address.toByteArray())).append("\n");
        }
        if ((signature = this.helloMessage.getSignature()) != null && !signature.isEmpty()) {
            builder.append("signature:").append(signature.toByteArray().length).append("\n");
        }
        return builder.toString();
    }

    public Protocol.HelloMessage getInstance() {
        return this.helloMessage;
    }

    public boolean valid() {
        byte[] genesisBlockByte = this.helloMessage.getGenesisBlockId().getHash().toByteArray();
        if (genesisBlockByte.length == 0) {
            return false;
        }
        byte[] solidBlockId = this.helloMessage.getSolidBlockId().getHash().toByteArray();
        if (solidBlockId.length == 0) {
            return false;
        }
        byte[] headBlockId = this.helloMessage.getHeadBlockId().getHash().toByteArray();
        return headBlockId.length != 0;
    }

    public static Discover.Endpoint getEndpointFromNode(Node node) {
        Discover.Endpoint.Builder builder = Discover.Endpoint.newBuilder().setPort(node.getPort());
        if (node.getId() != null) {
            builder.setNodeId(ByteString.copyFrom((byte[])node.getId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)node.getHostV4())) {
            builder.setAddress(ByteString.copyFrom((byte[])ByteArray.fromString((String)node.getHostV4())));
        }
        if (StringUtils.isNotEmpty((CharSequence)node.getHostV6())) {
            builder.setAddressIpv6(ByteString.copyFrom((byte[])ByteArray.fromString((String)node.getHostV6())));
        }
        return builder.build();
    }

    public Protocol.HelloMessage getHelloMessage() {
        return this.helloMessage;
    }
}

