/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.message.adv;

import java.util.List;
import org.tron.common.overlay.message.Message;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.net.message.MessageTypes;
import org.tron.core.net.message.TronMessage;

public class BlockMessage
extends TronMessage {
    private BlockCapsule block;

    public BlockMessage(byte[] data) throws Exception {
        super(data);
        this.type = MessageTypes.BLOCK.asByte();
        this.block = new BlockCapsule(BlockMessage.getCodedInputStream((byte[])data));
        if (Message.isFilter()) {
            Message.compareBytes((byte[])data, (byte[])this.block.getInstance().toByteArray());
            TransactionCapsule.validContractProto((List)this.block.getInstance().getTransactionsList());
        }
    }

    public BlockMessage(BlockCapsule block) {
        this.data = block.getData();
        this.type = MessageTypes.BLOCK.asByte();
        this.block = block;
    }

    public BlockCapsule.BlockId getBlockId() {
        return this.getBlockCapsule().getBlockId();
    }

    public BlockCapsule getBlockCapsule() {
        return this.block;
    }

    public Class<?> getAnswerMessage() {
        return null;
    }

    public Sha256Hash getMessageId() {
        return this.getBlockCapsule().getBlockId();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return super.toString() + this.block.getBlockId().getString() + ", trx size: " + this.block.getTransactions().size() + "\n";
    }
}

