/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.overlay.message.Message;
import org.tron.common.parameter.CommonParameter;
import org.tron.core.config.args.Args;
import org.tron.core.net.P2pEventHandlerImpl;
import org.tron.core.net.message.adv.TransactionMessage;
import org.tron.core.net.messagehandler.TransactionsMsgHandler;
import org.tron.core.net.peer.PeerConnection;
import org.tron.core.net.peer.PeerManager;
import org.tron.core.net.peer.PeerStatusCheck;
import org.tron.core.net.service.adv.AdvService;
import org.tron.core.net.service.effective.EffectiveCheckService;
import org.tron.core.net.service.fetchblock.FetchBlockService;
import org.tron.core.net.service.nodepersist.NodePersistService;
import org.tron.core.net.service.relay.RelayService;
import org.tron.core.net.service.statistics.TronStatsManager;
import org.tron.core.net.service.sync.SyncService;
import org.tron.p2p.P2pConfig;
import org.tron.p2p.P2pEventHandler;
import org.tron.p2p.P2pService;
import org.tron.p2p.utils.NetUtil;

@Component
public class TronNetService {
    private static final Logger logger = LoggerFactory.getLogger((String)"net");
    private static P2pConfig p2pConfig;
    private static P2pService p2pService;
    @Autowired
    private AdvService advService;
    @Autowired
    private SyncService syncService;
    @Autowired
    private PeerStatusCheck peerStatusCheck;
    @Autowired
    private TransactionsMsgHandler transactionsMsgHandler;
    @Autowired
    private FetchBlockService fetchBlockService;
    private CommonParameter parameter = Args.getInstance();
    @Autowired
    private P2pEventHandlerImpl p2pEventHandler;
    @Autowired
    private NodePersistService nodePersistService;
    @Autowired
    private TronStatsManager tronStatsManager;
    @Autowired
    private RelayService relayService;
    @Autowired
    private EffectiveCheckService effectiveCheckService;
    private volatile boolean init;

    private static void setP2pConfig(P2pConfig config) {
        p2pConfig = config;
    }

    public void start() {
        try {
            this.init = true;
            TronNetService.setP2pConfig(this.getConfig());
            p2pService.start(p2pConfig);
            p2pService.register((P2pEventHandler)this.p2pEventHandler);
            this.advService.init();
            this.syncService.init();
            this.peerStatusCheck.init();
            this.transactionsMsgHandler.init();
            this.fetchBlockService.init();
            this.nodePersistService.init();
            this.tronStatsManager.init();
            PeerManager.init();
            this.relayService.init();
            this.effectiveCheckService.init();
            logger.info("Net service start successfully");
        }
        catch (Exception e) {
            logger.error("Net service start failed", (Throwable)e);
        }
    }

    public void close() {
        if (!this.init) {
            return;
        }
        PeerManager.close();
        this.tronStatsManager.close();
        this.nodePersistService.close();
        this.advService.close();
        this.syncService.close();
        this.peerStatusCheck.close();
        this.transactionsMsgHandler.close();
        this.fetchBlockService.close();
        this.effectiveCheckService.close();
        p2pService.close();
        this.relayService.close();
        logger.info("Net service closed successfully");
    }

    public static List<PeerConnection> getPeers() {
        return PeerManager.getPeers();
    }

    public void broadcast(Message msg) {
        this.advService.broadcast(msg);
    }

    public int fastBroadcastTransaction(TransactionMessage msg) {
        return this.advService.fastBroadcastTransaction(msg);
    }

    public static boolean hasIpv4Stack(Set<String> ipSet) {
        for (String ip : ipSet) {
            InetAddress inetAddress;
            try {
                inetAddress = InetAddress.getByName(ip);
            }
            catch (UnknownHostException e) {
                logger.warn("Get inet address failed, {}", (Object)e.getMessage());
                continue;
            }
            if (!(inetAddress instanceof Inet4Address)) continue;
            return true;
        }
        return false;
    }

    private P2pConfig getConfig() {
        P2pConfig config = new P2pConfig();
        return this.updateConfig(config);
    }

    private P2pConfig updateConfig(P2pConfig config) {
        List seeds = this.parameter.getSeedNode().getAddressList();
        seeds.addAll(this.nodePersistService.dbRead());
        logger.debug("Seed InetSocketAddress: {}", (Object)seeds);
        config.getSeedNodes().addAll(seeds);
        config.getActiveNodes().addAll(this.parameter.getActiveNodes());
        config.getTrustNodes().addAll(this.parameter.getPassiveNodes());
        config.getActiveNodes().forEach(n -> config.getTrustNodes().add(n.getAddress()));
        this.parameter.getFastForwardNodes().forEach(f -> config.getTrustNodes().add(f.getAddress()));
        int maxConnections = this.parameter.getMaxConnections();
        int minConnections = this.parameter.getMinConnections();
        int minActiveConnections = this.parameter.getMinActiveConnections();
        if (minConnections > maxConnections) {
            minConnections = maxConnections;
        }
        if (minActiveConnections > minConnections) {
            minActiveConnections = minConnections;
        }
        config.setMaxConnections(maxConnections);
        config.setMinConnections(minConnections);
        config.setMinActiveConnections(minActiveConnections);
        config.setMaxConnectionsWithSameIp(this.parameter.getMaxConnectionsWithSameIp());
        config.setPort(this.parameter.getNodeListenPort());
        config.setNetworkId(this.parameter.getNodeP2pVersion());
        config.setDisconnectionPolicyEnable(this.parameter.isOpenFullTcpDisconnect());
        config.setNodeDetectEnable(this.parameter.isNodeDetectEnable());
        config.setDiscoverEnable(this.parameter.isNodeDiscoveryEnable());
        if (StringUtils.isEmpty((CharSequence)config.getIp()) && TronNetService.hasIpv4Stack(NetUtil.getAllLocalAddress())) {
            config.setIp(this.parameter.getNodeExternalIp());
        }
        if (StringUtils.isNotEmpty((CharSequence)config.getIpv6())) {
            config.getActiveNodes().remove(new InetSocketAddress(config.getIpv6(), config.getPort()));
        }
        if (!this.parameter.nodeEnableIpv6) {
            config.setIpv6(null);
        }
        logger.info("Local ipv4: {}", (Object)config.getIp());
        logger.info("Local ipv6: {}", (Object)config.getIpv6());
        config.setTreeUrls(this.parameter.getDnsTreeUrls());
        if (Objects.nonNull(this.parameter.getDnsPublishConfig())) {
            config.setPublishConfig(this.parameter.getDnsPublishConfig());
        }
        return config;
    }

    public static P2pConfig getP2pConfig() {
        return p2pConfig;
    }

    public static P2pService getP2pService() {
        return p2pService;
    }

    static {
        p2pService = new P2pService();
    }
}

