/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.prometheus.client.Histogram;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.backup.socket.BackupServer;
import org.tron.common.overlay.message.Message;
import org.tron.common.prometheus.Metrics;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.ChainBaseManager;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.PbftSignCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.db.Manager;
import org.tron.core.exception.AccountResourceInsufficientException;
import org.tron.core.exception.BadBlockException;
import org.tron.core.exception.BadItemException;
import org.tron.core.exception.BadNumberBlockException;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractSizeNotEqualToOneException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.exception.DupTransactionException;
import org.tron.core.exception.EventBloomException;
import org.tron.core.exception.ItemNotFoundException;
import org.tron.core.exception.NonCommonBlockException;
import org.tron.core.exception.P2pException;
import org.tron.core.exception.ReceiptCheckErrException;
import org.tron.core.exception.StoreException;
import org.tron.core.exception.TaposException;
import org.tron.core.exception.TooBigTransactionException;
import org.tron.core.exception.TooBigTransactionResultException;
import org.tron.core.exception.TransactionExpirationException;
import org.tron.core.exception.UnLinkedBlockException;
import org.tron.core.exception.VMIllegalException;
import org.tron.core.exception.ValidateScheduleException;
import org.tron.core.exception.ValidateSignatureException;
import org.tron.core.exception.ZksnarkException;
import org.tron.core.metrics.MetricsService;
import org.tron.core.net.TronNetService;
import org.tron.core.net.message.MessageTypes;
import org.tron.core.net.message.adv.BlockMessage;
import org.tron.core.net.message.adv.TransactionMessage;
import org.tron.core.net.peer.PeerConnection;
import org.tron.core.store.WitnessScheduleStore;
import org.tron.protos.Protocol;

@Component
public class TronNetDelegate {
    private static final Logger logger = LoggerFactory.getLogger((String)"net");
    @Autowired
    private Manager dbManager;
    @Autowired
    private ChainBaseManager chainBaseManager;
    @Autowired
    private WitnessScheduleStore witnessScheduleStore;
    private Object blockLock = new Object();
    @Autowired
    private BackupServer backupServer;
    @Autowired
    private MetricsService metricsService;
    private volatile boolean backupServerStartFlag;
    private int blockIdCacheSize = 100;
    private long timeout = 1000L;
    private volatile boolean hitDown = false;
    private Thread hitThread;
    private volatile boolean exit = true;
    private Cache<BlockCapsule.BlockId, Long> freshBlockId = CacheBuilder.newBuilder().maximumSize((long)this.blockIdCacheSize).expireAfterWrite(1L, TimeUnit.HOURS).recordStats().build();

    @PostConstruct
    public void init() {
        this.hitThread = new Thread(() -> {
            LockSupport.park();
            if (this.hitDown && this.exit) {
                System.exit(0);
            }
        });
        this.hitThread.setName("hit-thread");
        this.hitThread.start();
    }

    @PreDestroy
    public void close() {
        try {
            this.hitThread.interrupt();
            this.hitThread = null;
        }
        catch (Exception e) {
            logger.warn("hitThread interrupt error", (Throwable)e);
        }
    }

    public Collection<PeerConnection> getActivePeer() {
        return TronNetService.getPeers();
    }

    public long getSyncBeginNumber() {
        return this.dbManager.getSyncBeginNumber();
    }

    public long getBlockTime(BlockCapsule.BlockId id) throws P2pException {
        try {
            return this.chainBaseManager.getBlockById((Sha256Hash)id).getTimeStamp();
        }
        catch (BadItemException | ItemNotFoundException e) {
            throw new P2pException(P2pException.TypeEnum.DB_ITEM_NOT_FOUND, id.getString());
        }
    }

    public BlockCapsule.BlockId getHeadBlockId() {
        return this.chainBaseManager.getHeadBlockId();
    }

    public BlockCapsule.BlockId getKhaosDbHeadBlockId() {
        return this.chainBaseManager.getKhaosDbHead().getBlockId();
    }

    public BlockCapsule.BlockId getSolidBlockId() {
        return this.chainBaseManager.getSolidBlockId();
    }

    public BlockCapsule.BlockId getGenesisBlockId() {
        return this.chainBaseManager.getGenesisBlockId();
    }

    public BlockCapsule.BlockId getBlockIdByNum(long num) throws P2pException {
        try {
            return this.chainBaseManager.getBlockIdByNum(num);
        }
        catch (ItemNotFoundException e) {
            throw new P2pException(P2pException.TypeEnum.DB_ITEM_NOT_FOUND, "num: " + num);
        }
    }

    public BlockCapsule getGenesisBlock() {
        return this.chainBaseManager.getGenesisBlock();
    }

    public long getHeadBlockTimeStamp() {
        return this.chainBaseManager.getHeadBlockTimeStamp();
    }

    public boolean containBlock(BlockCapsule.BlockId id) {
        return this.chainBaseManager.containBlock((Sha256Hash)id);
    }

    public boolean containBlockInMainChain(BlockCapsule.BlockId id) {
        return this.chainBaseManager.containBlockInMainChain(id);
    }

    public List<BlockCapsule.BlockId> getBlockChainHashesOnFork(BlockCapsule.BlockId forkBlockHash) throws P2pException {
        try {
            return this.dbManager.getBlockChainHashesOnFork(forkBlockHash);
        }
        catch (NonCommonBlockException e) {
            throw new P2pException(P2pException.TypeEnum.HARD_FORKED, forkBlockHash.getString());
        }
    }

    public boolean canChainRevoke(long num) {
        return num >= this.dbManager.getSyncBeginNumber();
    }

    public boolean contain(Sha256Hash hash, MessageTypes type) {
        if (type.equals((Object)MessageTypes.BLOCK)) {
            return this.chainBaseManager.containBlock(hash);
        }
        if (type.equals((Object)MessageTypes.TRX)) {
            return this.dbManager.getTransactionStore().has(hash.getBytes());
        }
        return false;
    }

    public Message getData(Sha256Hash hash, Protocol.Inventory.InventoryType type) throws P2pException {
        try {
            switch (type) {
                case BLOCK: {
                    return new BlockMessage(this.chainBaseManager.getBlockById(hash));
                }
                case TRX: {
                    TransactionCapsule tx = this.chainBaseManager.getTransactionStore().get(hash.getBytes());
                    if (tx != null) {
                        return new TransactionMessage(tx.getInstance());
                    }
                    throw new StoreException();
                }
            }
            throw new StoreException();
        }
        catch (StoreException e) {
            throw new P2pException(P2pException.TypeEnum.DB_ITEM_NOT_FOUND, "type: " + type + ", hash: " + hash.getByteString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processBlock(BlockCapsule block, boolean isSync) throws P2pException {
        if (!this.hitDown && this.dbManager.getLatestSolidityNumShutDown() > 0L && this.dbManager.getLatestSolidityNumShutDown() == this.dbManager.getDynamicPropertiesStore().getLatestBlockHeaderNumberFromDB()) {
            logger.info("Begin shutdown, currentBlockNum:{}, DbBlockNum:{}, solidifiedBlockNum:{}", new Object[]{this.dbManager.getDynamicPropertiesStore().getLatestBlockHeaderNumber(), this.dbManager.getDynamicPropertiesStore().getLatestBlockHeaderNumberFromDB(), this.dbManager.getDynamicPropertiesStore().getLatestSolidifiedBlockNum()});
            this.hitDown = true;
            LockSupport.unpark(this.hitThread);
            return;
        }
        if (this.hitDown) {
            return;
        }
        BlockCapsule.BlockId blockId = block.getBlockId();
        Object object = this.blockLock;
        synchronized (object) {
            try {
                if (this.freshBlockId.getIfPresent((Object)blockId) == null) {
                    if (block.getNum() <= this.getHeadBlockId().getNum()) {
                        logger.warn("Receive a fork block {} witness {}, head {}", new Object[]{block.getBlockId().getString(), Hex.toHexString((byte[])block.getWitnessAddress().toByteArray()), this.getHeadBlockId().getString()});
                    }
                    if (!isSync) {
                        this.metricsService.applyBlock(block);
                    }
                    this.dbManager.getBlockedTimer().set(Metrics.histogramStartTimer((String)"tron:lock_acquire_latency_seconds", (String[])new String[]{"block"}));
                    Histogram.Timer timer = Metrics.histogramStartTimer((String)"tron:block_process_latency_seconds", (String[])new String[]{String.valueOf(isSync)});
                    this.dbManager.pushBlock(block);
                    Metrics.histogramObserve((Histogram.Timer)timer);
                    this.freshBlockId.put((Object)blockId, (Object)System.currentTimeMillis());
                    logger.info("Success process block {}", (Object)blockId.getString());
                    if (!this.backupServerStartFlag && System.currentTimeMillis() - block.getTimeStamp() < 3000L) {
                        this.backupServerStartFlag = true;
                        this.backupServer.initServer();
                    }
                }
            }
            catch (AccountResourceInsufficientException | BadBlockException | BadNumberBlockException | ContractExeException | ContractValidateException | DupTransactionException | EventBloomException | NonCommonBlockException | ReceiptCheckErrException | TaposException | TooBigTransactionException | TooBigTransactionResultException | TransactionExpirationException | UnLinkedBlockException | VMIllegalException | ValidateScheduleException | ValidateSignatureException | ZksnarkException e) {
                this.metricsService.failProcessBlock(block.getNum(), e.getMessage());
                logger.error("Process block failed, {}, reason: {}", (Object)blockId.getString(), (Object)e.getMessage());
                if (e instanceof BadBlockException && ((BadBlockException)e).getType().equals((Object)BadBlockException.TypeEnum.CALC_MERKLE_ROOT_FAILED)) {
                    throw new P2pException(P2pException.TypeEnum.BLOCK_MERKLE_ERROR, e);
                }
                throw new P2pException(P2pException.TypeEnum.BAD_BLOCK, e);
            }
        }
    }

    public void pushTransaction(TransactionCapsule trx) throws P2pException {
        try {
            trx.setTime(System.currentTimeMillis());
            this.dbManager.pushTransaction(trx);
        }
        catch (ContractSizeNotEqualToOneException | VMIllegalException e) {
            throw new P2pException(P2pException.TypeEnum.BAD_TRX, e);
        }
        catch (AccountResourceInsufficientException | ContractExeException | ContractValidateException | DupTransactionException | ReceiptCheckErrException | TaposException | TooBigTransactionException | TooBigTransactionResultException | TransactionExpirationException | ValidateSignatureException e) {
            throw new P2pException(P2pException.TypeEnum.TRX_EXE_FAILED, e);
        }
    }

    public void validSignature(BlockCapsule block) throws P2pException {
        boolean flag;
        try {
            flag = block.validateSignature(this.dbManager.getDynamicPropertiesStore(), this.dbManager.getAccountStore());
        }
        catch (Exception e) {
            throw new P2pException(P2pException.TypeEnum.BLOCK_SIGN_ERROR, (Throwable)e);
        }
        if (!flag) {
            throw new P2pException(P2pException.TypeEnum.BLOCK_SIGN_ERROR, "valid signature failed.");
        }
    }

    public boolean validBlock(BlockCapsule block) throws P2pException {
        long time = System.currentTimeMillis();
        if (block.getTimeStamp() - time > this.timeout) {
            throw new P2pException(P2pException.TypeEnum.BAD_BLOCK, "time:" + time + ",block time:" + block.getTimeStamp());
        }
        this.validSignature(block);
        return this.witnessScheduleStore.getActiveWitnesses().contains(block.getWitnessAddress());
    }

    public PbftSignCapsule getBlockPbftCommitData(long blockNum) {
        return this.chainBaseManager.getPbftSignDataStore().getBlockSignData(blockNum);
    }

    public PbftSignCapsule getSRLPbftCommitData(long epoch) {
        return this.chainBaseManager.getPbftSignDataStore().getSrSignData(epoch);
    }

    public boolean allowPBFT() {
        return this.chainBaseManager.getDynamicPropertiesStore().allowPBFT();
    }

    public Object getForkLock() {
        return this.dbManager.getForkLock();
    }

    public Object getBlockLock() {
        return this.blockLock;
    }

    public boolean isHitDown() {
        return this.hitDown;
    }

    public void setExit(boolean exit) {
        this.exit = exit;
    }
}

