/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.metrics.blockchain;

import com.codahale.metrics.Counter;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import org.bouncycastle.util.encoders.Hex;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.prometheus.Metrics;
import org.tron.common.utils.StringUtil;
import org.tron.core.ChainBaseManager;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.db.Manager;
import org.tron.core.metrics.MetricsUtil;
import org.tron.core.metrics.blockchain.BlockChainInfo;
import org.tron.core.metrics.blockchain.DupWitnessInfo;
import org.tron.core.metrics.blockchain.WitnessInfo;
import org.tron.core.metrics.net.RateInfo;
import org.tron.protos.Protocol;

@Component
public class BlockChainMetricManager {
    @Autowired
    private Manager dbManager;
    @Autowired
    private ChainBaseManager chainBaseManager;
    private Map<String, BlockCapsule> witnessInfo = new ConcurrentHashMap<String, BlockCapsule>();
    private Map<String, Long> dupWitnessBlockNum = new ConcurrentHashMap<String, Long>();
    private long failProcessBlockNum = 0L;
    private String failProcessBlockReason = "";

    public BlockChainInfo getBlockChainInfo() {
        BlockChainInfo blockChainInfo = new BlockChainInfo();
        this.setBlockChainInfo(blockChainInfo);
        return blockChainInfo;
    }

    private void setBlockChainInfo(BlockChainInfo blockChain) {
        blockChain.setHeadBlockTimestamp(this.chainBaseManager.getHeadBlockTimeStamp());
        blockChain.setHeadBlockHash(this.dbManager.getDynamicPropertiesStore().getLatestBlockHeaderHash().toString());
        RateInfo blockProcessTime = MetricsUtil.getRateInfo("blockchain.blockProcessTime");
        blockChain.setBlockProcessTime(blockProcessTime);
        blockChain.setForkCount(this.getForkCount());
        blockChain.setFailForkCount(this.getFailForkCount());
        blockChain.setHeadBlockNum(this.chainBaseManager.getHeadBlockNum());
        blockChain.setTransactionCacheSize(this.dbManager.getPendingTransactions().size() + this.dbManager.getRePushTransactions().size());
        RateInfo missTx = MetricsUtil.getRateInfo("blockchain.missedTransaction");
        blockChain.setMissedTransaction(missTx);
        RateInfo tpsInfo = MetricsUtil.getRateInfo("blockchain.tps");
        blockChain.setTps(tpsInfo);
        List<WitnessInfo> witnesses = this.getSrList();
        blockChain.setWitnesses(witnesses);
        blockChain.setFailProcessBlockNum(this.failProcessBlockNum);
        blockChain.setFailProcessBlockReason(this.failProcessBlockReason);
        List<DupWitnessInfo> dupWitness = this.getDupWitness();
        blockChain.setDupWitness(dupWitness);
    }

    public Protocol.MetricsInfo.BlockChainInfo getBlockChainProtoInfo() {
        Protocol.MetricsInfo.BlockChainInfo.Builder blockChainInfo = Protocol.MetricsInfo.BlockChainInfo.newBuilder();
        BlockChainInfo blockChain = this.getBlockChainInfo();
        blockChainInfo.setHeadBlockNum(blockChain.getHeadBlockNum());
        blockChainInfo.setHeadBlockTimestamp(blockChain.getHeadBlockTimestamp());
        blockChainInfo.setHeadBlockHash(blockChain.getHeadBlockHash());
        blockChainInfo.setFailProcessBlockNum(blockChain.getFailProcessBlockNum());
        blockChainInfo.setFailProcessBlockReason(blockChain.getFailProcessBlockReason());
        blockChainInfo.setForkCount(blockChain.getForkCount());
        blockChainInfo.setFailForkCount(blockChain.getFailForkCount());
        blockChainInfo.setTransactionCacheSize(blockChain.getTransactionCacheSize());
        RateInfo missTransaction = blockChain.getMissedTransaction();
        Protocol.MetricsInfo.RateInfo missTransactionInfo = missTransaction.toProtoEntity();
        blockChainInfo.setMissedTransaction(missTransactionInfo);
        RateInfo blockProcessTime = blockChain.getBlockProcessTime();
        Protocol.MetricsInfo.RateInfo blockProcessTimeInfo = blockProcessTime.toProtoEntity();
        blockChainInfo.setBlockProcessTime(blockProcessTimeInfo);
        RateInfo tps = blockChain.getTps();
        Protocol.MetricsInfo.RateInfo tpsInfo = tps.toProtoEntity();
        blockChainInfo.setTps(tpsInfo);
        for (WitnessInfo witness : blockChain.getWitnesses()) {
            Protocol.MetricsInfo.BlockChainInfo.Witness.Builder witnessInfo = Protocol.MetricsInfo.BlockChainInfo.Witness.newBuilder();
            witnessInfo.setAddress(witness.getAddress());
            witnessInfo.setVersion(witness.getVersion());
            blockChainInfo.addWitnesses(witnessInfo.build());
        }
        for (DupWitnessInfo dupWitness : blockChain.getDupWitness()) {
            Protocol.MetricsInfo.BlockChainInfo.DupWitness.Builder dupWitnessInfo = Protocol.MetricsInfo.BlockChainInfo.DupWitness.newBuilder();
            dupWitnessInfo.setAddress(dupWitness.getAddress());
            dupWitnessInfo.setBlockNum(dupWitness.getBlockNum());
            dupWitnessInfo.setCount(dupWitness.getCount());
            blockChainInfo.addDupWitness(dupWitnessInfo.build());
        }
        return blockChainInfo.build();
    }

    public void applyBlock(BlockCapsule block) {
        BlockCapsule oldBlock;
        long nowTime = System.currentTimeMillis();
        byte[] address = block.getWitnessAddress().toByteArray();
        String witnessAddress = Hex.toHexString((byte[])address);
        if (this.witnessInfo.containsKey(witnessAddress) && !(oldBlock = this.witnessInfo.get(witnessAddress)).getBlockId().equals((Object)block.getBlockId()) && oldBlock.getTimeStamp() == block.getTimeStamp()) {
            MetricsUtil.counterInc("blockchain.dupWitness." + witnessAddress);
            Metrics.counterInc((String)"tron:miner", (double)1.0, (String[])new String[]{StringUtil.encode58Check((byte[])address), "dup"});
            this.dupWitnessBlockNum.put(witnessAddress, block.getNum());
        }
        this.witnessInfo.put(witnessAddress, block);
        long netTime = nowTime - block.getTimeStamp();
        Metrics.histogramObserve((String)"tron:miner_latency_seconds", (double)((double)netTime / 1000.0), (String[])new String[]{StringUtil.encode58Check((byte[])address)});
        MetricsUtil.histogramUpdate("net.latency", netTime);
        MetricsUtil.histogramUpdate("net.latency.witness." + witnessAddress, netTime);
        if (netTime >= 3000L) {
            MetricsUtil.counterInc("net.latency.3S");
            MetricsUtil.counterInc("net.latency.witness." + witnessAddress + ".3S");
        } else if (netTime >= 2000L) {
            MetricsUtil.counterInc("net.latency.2S");
            MetricsUtil.counterInc("net.latency.witness." + witnessAddress + ".2S");
        } else if (netTime >= 1000L) {
            MetricsUtil.counterInc("net.latency.1S");
            MetricsUtil.counterInc("net.latency.witness." + witnessAddress + ".1S");
        }
        if (block.getTransactions().size() > 0) {
            MetricsUtil.meterMark("blockchain.tps", block.getTransactions().size());
            Metrics.counterInc((String)"tron:txs", (double)block.getTransactions().size(), (String[])new String[]{"success", "success"});
        }
    }

    private List<WitnessInfo> getSrList() {
        ArrayList<WitnessInfo> witnessInfos = new ArrayList<WitnessInfo>();
        List witnessList = this.chainBaseManager.getWitnessScheduleStore().getActiveWitnesses();
        for (ByteString witnessAddress : witnessList) {
            String address = Hex.toHexString((byte[])witnessAddress.toByteArray());
            if (!this.witnessInfo.containsKey(address)) continue;
            BlockCapsule block = this.witnessInfo.get(address);
            WitnessInfo witness = new WitnessInfo(address, block.getInstance().getBlockHeader().getRawData().getVersion());
            witnessInfos.add(witness);
        }
        return witnessInfos;
    }

    public int getForkCount() {
        return (int)MetricsUtil.getMeter("blockchain.forkCount").getCount();
    }

    public int getFailForkCount() {
        return (int)MetricsUtil.getMeter("blockchain.failForkCount").getCount();
    }

    private List<DupWitnessInfo> getDupWitness() {
        ArrayList<DupWitnessInfo> dupWitnesses = new ArrayList<DupWitnessInfo>();
        SortedMap<String, Counter> dupWitnessMap = MetricsUtil.getCounters("blockchain.dupWitness.");
        for (Map.Entry<String, Counter> entry : dupWitnessMap.entrySet()) {
            DupWitnessInfo dupWitness = new DupWitnessInfo();
            String witness = entry.getKey().substring("blockchain.dupWitness.".length());
            long blockNum = this.dupWitnessBlockNum.get(witness);
            dupWitness.setAddress(witness);
            dupWitness.setBlockNum(blockNum);
            dupWitness.setCount((int)entry.getValue().getCount());
            dupWitnesses.add(dupWitness);
        }
        return dupWitnesses;
    }

    public Map<String, Long> getDupWitnessBlockNum() {
        return this.dupWitnessBlockNum;
    }

    public void setFailProcessBlockNum(long failProcessBlockNum) {
        this.failProcessBlockNum = failProcessBlockNum;
    }

    public void setFailProcessBlockReason(String failProcessBlockReason) {
        this.failProcessBlockReason = failProcessBlockReason;
    }
}

