/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import metrics_influxdb.InfluxdbReporter;
import metrics_influxdb.api.protocols.InfluxdbProtocols;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.parameter.CommonParameter;
import org.tron.core.metrics.net.RateInfo;

public class MetricsUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)"metrics");
    private static MetricRegistry metricRegistry = new MetricRegistry();

    public static void init() {
        if (CommonParameter.getInstance().isNodeMetricsEnable() && CommonParameter.getInstance().isMetricsStorageEnable()) {
            String ip = CommonParameter.getInstance().getInfluxDbIp();
            int port = CommonParameter.getInstance().getInfluxDbPort();
            String dataBase = CommonParameter.getInstance().getInfluxDbDatabase();
            ScheduledReporter influxReport = InfluxdbReporter.forRegistry((MetricRegistry)metricRegistry).protocol(InfluxdbProtocols.http((String)ip, (int)port, (String)dataBase)).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).skipIdleMetrics(false).build();
            int interval = CommonParameter.getInstance().getMetricsReportInterval() * 1000;
            influxReport.start((long)interval, TimeUnit.MILLISECONDS);
        }
    }

    public static Histogram getHistogram(String key) {
        return metricRegistry.histogram(key);
    }

    public static SortedMap<String, Histogram> getHistograms(String key) {
        return metricRegistry.getHistograms((s, metric) -> s.startsWith(key));
    }

    public static void histogramUpdate(String key, long value) {
        try {
            if (CommonParameter.getInstance().isNodeMetricsEnable()) {
                metricRegistry.histogram(key).update(value);
            }
        }
        catch (Exception e) {
            logger.warn("update histogram failed, key:{}, value:{}", (Object)key, (Object)value);
        }
    }

    public static void histogramUpdateUnCheck(String key, long value) {
        try {
            metricRegistry.histogram(key).update(value);
        }
        catch (Exception e) {
            logger.warn("update histogram uncheck failed, key:{}, value:{}", (Object)key, (Object)value);
        }
    }

    public static Meter getMeter(String name) {
        return metricRegistry.meter(name);
    }

    public static SortedMap<String, Meter> getMeters(String key) {
        return metricRegistry.getMeters((s, metric) -> s.startsWith(key));
    }

    public static void meterMark(String key) {
        try {
            if (CommonParameter.getInstance().isNodeMetricsEnable()) {
                metricRegistry.meter(key).mark(1L);
            }
        }
        catch (Exception e) {
            logger.warn("mark meter failed, key:{}", (Object)key);
        }
    }

    public static void meterMark(String key, long value) {
        try {
            if (CommonParameter.getInstance().isNodeMetricsEnable()) {
                metricRegistry.meter(key).mark(value);
            }
        }
        catch (Exception e) {
            logger.warn("mark meter failed, key:{}, value:{}", (Object)key, (Object)value);
        }
    }

    public static Counter getCounter(String name) {
        return metricRegistry.counter(name);
    }

    public static SortedMap<String, Counter> getCounters(String name) {
        return metricRegistry.getCounters((s, metric) -> s.startsWith(name));
    }

    public static void counterInc(String key) {
        try {
            if (CommonParameter.getInstance().isNodeMetricsEnable()) {
                metricRegistry.counter(key).inc(1L);
            }
        }
        catch (Exception e) {
            logger.warn("inc counter failed, key:{}", (Object)key);
        }
    }

    public static RateInfo getRateInfo(String key) {
        RateInfo rateInfo = new RateInfo();
        Meter meter = MetricsUtil.getMeter(key);
        rateInfo.setCount(meter.getCount());
        rateInfo.setMeanRate(meter.getMeanRate());
        rateInfo.setOneMinuteRate(meter.getOneMinuteRate());
        rateInfo.setFiveMinuteRate(meter.getFiveMinuteRate());
        rateInfo.setFifteenMinuteRate(meter.getFifteenMinuteRate());
        return rateInfo;
    }
}

