/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.metrics;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.metrics.MetricsInfo;
import org.tron.core.metrics.blockchain.BlockChainMetricManager;

@Component
public class MetricsService {
    private static final Logger logger = LoggerFactory.getLogger((String)"metrics");
    @Autowired
    private BlockChainMetricManager blockChainMetricManager;

    public void applyBlock(BlockCapsule block) {
        try {
            this.blockChainMetricManager.applyBlock(block);
        }
        catch (Exception e) {
            logger.warn("record block failed, {}, reason: {}.", (Object)block.getBlockId().toString(), (Object)e.getMessage());
        }
    }

    public void failProcessBlock(long blockNum, String errorInfo) {
        try {
            this.blockChainMetricManager.setFailProcessBlockNum(blockNum);
            this.blockChainMetricManager.setFailProcessBlockReason(errorInfo);
        }
        catch (Exception e) {
            logger.warn("record fail process block failed, {}, reason: {}.", (Object)blockNum, (Object)errorInfo);
        }
    }

    public MetricsInfo getMetricsInfo() {
        return new MetricsInfo();
    }
}

