/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db.common.iterator;

import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractIterator<T>
implements Iterator<Map.Entry<byte[], T>> {
    protected Iterator<Map.Entry<byte[], byte[]>> iterator;
    private TypeToken<T> typeToken = new TypeToken<T>(this.getClass()){};

    public AbstractIterator(Iterator<Map.Entry<byte[], byte[]>> iterator) {
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    protected T of(byte[] value) {
        try {
            Object t = this.typeToken.getRawType().getConstructor(byte[].class).newInstance(new Object[]{value});
            return t;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map.Entry<byte[], T> next() {
        Map.Entry<byte[], byte[]> entry = this.iterator.next();
        return Maps.immutableEntry((Object)entry.getKey(), this.of(entry.getValue()));
    }
}

