/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.ByteArray;
import org.tron.core.ChainBaseManager;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.AssetIssueCapsule;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.ExchangeCapsule;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.config.Parameter;
import org.tron.protos.Protocol;
import org.tron.protos.contract.AssetIssueContractOuterClass;

public class AssetUpdateHelper {
    private static final Logger logger = LoggerFactory.getLogger((String)"DB");
    private ChainBaseManager chainBaseManager;
    private HashMap<String, byte[]> assetNameToIdMap = new HashMap();

    public AssetUpdateHelper(ChainBaseManager chainBaseManager) {
        this.chainBaseManager = chainBaseManager;
    }

    public void doWork() {
        long start = System.currentTimeMillis();
        logger.info("Start to update the asset");
        this.init();
        this.updateAsset();
        this.updateExchange();
        this.updateAccount();
        this.finish();
        logger.info("Complete the asset update, Total time:{} milliseconds", (Object)(System.currentTimeMillis() - start));
    }

    public void init() {
        if (this.chainBaseManager.getAssetIssueV2Store().isNotEmpty()) {
            logger.warn("AssetIssueV2Store is not empty");
        }
        this.chainBaseManager.getAssetIssueV2Store().reset();
        if (this.chainBaseManager.getExchangeV2Store().isNotEmpty()) {
            logger.warn("ExchangeV2Store is not empty");
        }
        this.chainBaseManager.getExchangeV2Store().reset();
        this.chainBaseManager.getDynamicPropertiesStore().saveTokenIdNum(1000000L);
    }

    public List<AssetIssueCapsule> getAllAssetIssues() {
        long blockNum;
        ArrayList<AssetIssueCapsule> result = new ArrayList<AssetIssueCapsule>();
        long latestBlockHeaderNumber = this.chainBaseManager.getDynamicPropertiesStore().getLatestBlockHeaderNumber();
        for (blockNum = 1L; blockNum <= latestBlockHeaderNumber; ++blockNum) {
            if (blockNum % 100000L == 0L) {
                logger.info("The number of block that have processed: {}", (Object)blockNum);
            }
            try {
                BlockCapsule block = this.chainBaseManager.getBlockByNum(blockNum);
                for (TransactionCapsule transaction : block.getTransactions()) {
                    if (transaction.getInstance().getRawData().getContract(0).getType() != Protocol.Transaction.Contract.ContractType.AssetIssueContract) continue;
                    AssetIssueContractOuterClass.AssetIssueContract obj = (AssetIssueContractOuterClass.AssetIssueContract)transaction.getInstance().getRawData().getContract(0).getParameter().unpack(AssetIssueContractOuterClass.AssetIssueContract.class);
                    AssetIssueCapsule assetIssueCapsule = new AssetIssueCapsule(obj);
                    result.add(this.chainBaseManager.getAssetIssueStore().get(assetIssueCapsule.createDbKey()));
                }
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Block does not exist, num:" + blockNum);
            }
        }
        logger.info("Total block:{}", (Object)blockNum);
        if (this.chainBaseManager.getAssetIssueStore().getAllAssetIssues().size() != result.size()) {
            throw new RuntimeException("Asset num is wrong!");
        }
        return result;
    }

    public void updateAsset() {
        long tokenIdNum = this.chainBaseManager.getDynamicPropertiesStore().getTokenIdNum();
        long count = 0L;
        List<AssetIssueCapsule> assetIssueCapsuleList = this.getAllAssetIssues();
        for (AssetIssueCapsule assetIssueCapsule : assetIssueCapsuleList) {
            ++count;
            assetIssueCapsule.setId(Long.toString(++tokenIdNum));
            this.chainBaseManager.getAssetIssueStore().put(assetIssueCapsule.createDbKey(), (ProtoCapsule)assetIssueCapsule);
            assetIssueCapsule.setPrecision(0);
            this.chainBaseManager.getAssetIssueV2Store().put(assetIssueCapsule.createDbV2Key(), (ProtoCapsule)assetIssueCapsule);
            this.assetNameToIdMap.put(ByteArray.toStr((byte[])assetIssueCapsule.createDbKey()), assetIssueCapsule.createDbV2Key());
        }
        this.chainBaseManager.getDynamicPropertiesStore().saveTokenIdNum(tokenIdNum);
        logger.info("Complete the asset store update, Total assets:{}", (Object)count);
    }

    public void updateExchange() {
        long count = 0L;
        for (ExchangeCapsule exchangeCapsule : this.chainBaseManager.getExchangeStore().getAllExchanges()) {
            ++count;
            if (!Arrays.equals(exchangeCapsule.getFirstTokenId(), Parameter.ChainSymbol.TRX_SYMBOL_BYTES)) {
                exchangeCapsule.setFirstTokenId(this.assetNameToIdMap.get(ByteArray.toStr((byte[])exchangeCapsule.getFirstTokenId())));
            }
            if (!Arrays.equals(exchangeCapsule.getSecondTokenId(), Parameter.ChainSymbol.TRX_SYMBOL_BYTES)) {
                exchangeCapsule.setSecondTokenId(this.assetNameToIdMap.get(ByteArray.toStr((byte[])exchangeCapsule.getSecondTokenId())));
            }
            this.chainBaseManager.getExchangeV2Store().put(exchangeCapsule.createDbKey(), (ProtoCapsule)exchangeCapsule);
        }
        logger.info("Complete the exchange store update, Total exchanges:{}", (Object)count);
    }

    public void updateAccount() {
        long count = 0L;
        Iterator iterator = this.chainBaseManager.getAccountStore().iterator();
        while (iterator.hasNext()) {
            HashMap map;
            AccountCapsule accountCapsule = (AccountCapsule)((Map.Entry)iterator.next()).getValue();
            accountCapsule.clearAssetV2();
            if (accountCapsule.getAssetMap().size() != 0) {
                map = new HashMap();
                for (Map.Entry entry : accountCapsule.getAssetMap().entrySet()) {
                    map.put(ByteArray.toStr((byte[])this.assetNameToIdMap.get(entry.getKey())), entry.getValue());
                }
                accountCapsule.addAssetMapV2(map);
            }
            accountCapsule.clearFreeAssetNetUsageV2();
            if (accountCapsule.getAllFreeAssetNetUsage().size() != 0) {
                map = new HashMap();
                for (Map.Entry entry : accountCapsule.getAllFreeAssetNetUsage().entrySet()) {
                    map.put(ByteArray.toStr((byte[])this.assetNameToIdMap.get(entry.getKey())), entry.getValue());
                }
                accountCapsule.addAllFreeAssetNetUsageV2(map);
            }
            accountCapsule.clearLatestAssetOperationTimeV2();
            if (accountCapsule.getLatestAssetOperationTimeMap().size() != 0) {
                map = new HashMap();
                for (Map.Entry entry : accountCapsule.getLatestAssetOperationTimeMap().entrySet()) {
                    map.put(ByteArray.toStr((byte[])this.assetNameToIdMap.get(entry.getKey())), entry.getValue());
                }
                accountCapsule.addAllLatestAssetOperationTimeV2(map);
            }
            if (!accountCapsule.getAssetIssuedName().isEmpty()) {
                accountCapsule.setAssetIssuedID(this.assetNameToIdMap.get(ByteArray.toStr((byte[])accountCapsule.getAssetIssuedName().toByteArray())));
            }
            this.chainBaseManager.getAccountStore().put(accountCapsule.createDbKey(), accountCapsule);
            if (count % 50000L == 0L) {
                logger.info("The number of accounts that have completed the update: {}", (Object)count);
            }
            ++count;
        }
        logger.info("Complete the account store update, total assets: {}", (Object)count);
    }

    public void finish() {
        this.chainBaseManager.getDynamicPropertiesStore().saveTokenUpdateDone(1L);
        this.assetNameToIdMap.clear();
    }
}

